/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.properties;

import com.intellij.diagram.ChangeTracker;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiFilter;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

final class PropertyChangeTracker
extends ChangeTracker<PropertiesFileImpl, Property, PsiElement> {
    private static final PsiFilter<Property> PROPERTY_FILTER = new PsiFilter<Property>(Property.class){

        public boolean areEquivalent(Property e1, Property e2) {
            String key1 = e1.getKey();
            return key1 != null && key1.equals(e2.getKey());
        }
    };
    private HashMap<PropertiesFileImpl, FileStatus> map;

    PropertyChangeTracker(Project project, @Nullable PsiFile before, @Nullable PsiFile after) {
        super(project, before, after);
    }

    public PsiFilter<PropertiesFileImpl>[] getNodeFilters() {
        return new PsiFilter[]{new PsiFilter(PropertiesFile.class)};
    }

    public PsiFilter<Property>[] getNodeContentFilters() {
        return new PsiFilter[]{PROPERTY_FILTER};
    }

    public Map<PropertiesFileImpl, FileStatus> getNodeElements() {
        if (this.map == null) {
            this.map = new HashMap();
            PropertiesFileImpl after = (PropertiesFileImpl)this.getAfter();
            PropertiesFileImpl before = (PropertiesFileImpl)this.getBefore();
            if (after == null) {
                this.map.put(before, FileStatus.DELETED);
            } else if (before == null) {
                this.map.put(after, FileStatus.ADDED);
            } else {
                this.map.put(after, FileStatus.MODIFIED);
            }
        }
        return this.map;
    }

    public ChangeTracker.RelationshipInfo[] getRelationships() {
        return ChangeTracker.RelationshipInfo.EMPTY;
    }

    public PsiNamedElement findElementByFQN(Project project, String fqn) {
        PsiFile psiFile;
        VirtualFile vf;
        File file = new File(fqn);
        if (file.exists() && (vf = LocalFileSystem.getInstance().findFileByIoFile(file)) != null && (psiFile = PsiManager.getInstance((Project)project).findFile(vf)) instanceof PropertiesFile) {
            return psiFile;
        }
        return null;
    }

    public String getPresentableName(PsiNamedElement e) {
        return e instanceof IProperty ? ((IProperty)e).getKey() : super.getPresentableName(e);
    }
}

