/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.ConfigUrlOverrider;
import com.intellij.database.dataSource.DataSourceOptionsPanel;
import com.intellij.database.dataSource.DataSourceSessionTemplate;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.database.dataSource.url.ui.BaseTypeDescriptor;
import com.intellij.database.dataSource.url.ui.DatabaseAuthPanel;
import com.intellij.database.dataSource.url.ui.DatabaseUIUtils;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSessionTemplatePanel {
    private final JComponent myComponent;
    private final List<Widget> myWidgets = new ArrayList<Widget>();
    private final DataSourceSessionTemplate myTemplate;
    private final ActionLink myAddOptions;
    private final UserActivityWatcher.UserActivityProvider myActivityProvider;
    private final Map<String, String> myAdditionalProperties = new LinkedHashMap<String, String>();

    DataSourceSessionTemplatePanel(Project project, DatabaseCredentials credentials, DataSourceSessionTemplate template, Supplier<DataSourceSessionTemplate> currentTemplate, Runnable onTitleChanged) {
        this.myTemplate = template;
        this.myComponent = new JPanel();
        this.myAddOptions = new ActionLink(DatabaseBundle.message((String)"add.options", (Object[])new Object[0]));
        this.myAddOptions.addActionListener(e -> this.showOverrideChooser(this.myAddOptions));
        this.myAddOptions.setDropDownLinkIcon();
        NameWidget nameWidget = new NameWidget(this);
        nameWidget.onNameChanged(onTitleChanged);
        this.myWidgets.add(nameWidget);
        this.myWidgets.add(new AuthWidget(this, project, credentials, template));
        this.myWidgets.add(new ReadonlyWidget(this));
        this.myWidgets.add(new InitScriptWidget(this, project, currentTemplate));
        this.myWidgets.add(new UrlOverridesWidget());
        this.myActivityProvider = UserActivityWatcher.UserActivityProvider.create((JComponent)this.myComponent);
    }

    private void showOverrideChooser(ActionLink link) {
        DefaultActionGroup group = new DefaultActionGroup(ContainerUtil.mapNotNull(this.myWidgets, Widget::getAction));
        JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, DataManager.getInstance().getDataContext((Component)this.myComponent), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).showUnderneathOf((Component)link);
    }

    private void collectWidgets() {
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        for (Widget widget : this.myWidgets) {
            if (!widget.isActive()) continue;
            components.addAll(widget.getComponents());
        }
        this.myComponent.removeAll();
        this.myComponent.setLayout((LayoutManager)new GridLayoutManager(components.size() + 1, 6));
        for (int i = 0; i < components.size(); ++i) {
            JComponent component = (JComponent)components.get(i);
            component.setBorder((Border)JBUI.Borders.emptyBottom((int)8));
            this.myComponent.add((Component)component, DatabaseUIUtils.createRowConstraints(i));
        }
        GridConstraints constraints = DatabaseUIUtils.createRowConstraints(components.size());
        constraints.setVSizePolicy(DatabaseUIUtils.getPolicy(true));
        this.myComponent.add((Component)this.myAddOptions, constraints);
        this.myComponent.revalidate();
        this.myComponent.repaint();
        this.myActivityProvider.stateChanged((Object)this);
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public void save(@NotNull DataSourceSessionTemplate template) {
        if (template == null) {
            DataSourceSessionTemplatePanel.$$$reportNull$$$0(0);
        }
        for (String name : JBIterable.from((Iterable)template.getAdditionalPropertiesNames()).append(this.myAdditionalProperties.keySet())) {
            template.setAdditionalProperty(name, this.myAdditionalProperties.get(name));
        }
        for (Widget widget : this.myWidgets) {
            widget.save(template);
        }
    }

    public void reset(@NotNull DataSourceSessionTemplate template) {
        if (template == null) {
            DataSourceSessionTemplatePanel.$$$reportNull$$$0(1);
        }
        this.myAdditionalProperties.clear();
        for (String name : template.getAdditionalPropertiesNames()) {
            DbImplUtilCore.putOrRemove(this.myAdditionalProperties, (Object)name, (Object)template.getAdditionalProperty(name));
        }
        for (Widget widget : this.myWidgets) {
            widget.reset(template);
        }
        this.collectWidgets();
    }

    @Nls
    public String getTitle() {
        NameWidget nameWidget = (NameWidget)ContainerUtil.findInstance(this.myWidgets, NameWidget.class);
        return nameWidget == null ? "" : nameWidget.getText();
    }

    public void hidePassword() {
        DatabaseAuthProvider.AuthWidget widget;
        AuthWidget auth = (AuthWidget)ContainerUtil.findInstance(this.myWidgets, AuthWidget.class);
        if (auth != null && auth.myAuthPanel != null && (widget = auth.myAuthPanel.getAuthWidget()) != null) {
            widget.hidePassword();
        }
    }

    public void reloadCredentials() {
        DatabaseAuthProvider.AuthWidget widget;
        AuthWidget auth = (AuthWidget)ContainerUtil.findInstance(this.myWidgets, AuthWidget.class);
        if (auth != null && auth.myAuthPanel != null && (widget = auth.myAuthPanel.getAuthWidget()) != null) {
            widget.reloadCredentials();
        }
    }

    @Nls
    public static String getTitle(@NotNull DataSourceSessionTemplate template) {
        if (template == null) {
            DataSourceSessionTemplatePanel.$$$reportNull$$$0(2);
        }
        return template.getTemplateName();
    }

    @NotNull
    private static JComponent withLabel(JComponent c2, @NotNull @Nls String label) {
        if (label == null) {
            DataSourceSessionTemplatePanel.$$$reportNull$$$0(3);
        }
        JPanel component = new JPanel((LayoutManager)new GridLayoutManager(1, 6));
        JBLabel lbl = new JBLabel(label);
        component.add((Component)lbl, DatabaseUIUtils.createLabelConstraints(0, 0, lbl.getPreferredSize().width));
        component.add((Component)c2, DatabaseUIUtils.createSimpleConstraints(0, 1, 5));
        JPanel jPanel = component;
        if (jPanel == null) {
            DataSourceSessionTemplatePanel.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceSessionTemplatePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceSessionTemplatePanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withLabel";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private class NameWidget
    extends SimpleWidget {
        private JTextField myNameField;

        private NameWidget(DataSourceSessionTemplatePanel dataSourceSessionTemplatePanel) {
        }

        @Override
        @Nls
        @Nullable
        public String getName() {
            return null;
        }

        @Override
        public void save(@NotNull DataSourceSessionTemplate template) {
            if (template == null) {
                NameWidget.$$$reportNull$$$0(0);
            }
            template.setTemplateName(this.getText());
        }

        @NlsSafe
        private String getText() {
            return this.getNameField().getText();
        }

        private JTextField getNameField() {
            this.getComponents();
            return this.myNameField;
        }

        @Override
        public void reset(@NotNull DataSourceSessionTemplate template) {
            if (template == null) {
                NameWidget.$$$reportNull$$$0(1);
            }
            this.setActive(true);
            this.getNameField().setText(template.getTemplateName());
        }

        @Override
        protected List<JComponent> createComponents() {
            this.myNameField = new JBTextField();
            return Collections.singletonList(DataSourceSessionTemplatePanel.withLabel(this.myNameField, DatabaseBundle.message((String)"data.source.settings.name.label", (Object[])new Object[0])));
        }

        public void onNameChanged(final @NotNull Runnable changed) {
            if (changed == null) {
                NameWidget.$$$reportNull$$$0(2);
            }
            this.getNameField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(this){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    changed.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceSessionTemplatePanel$NameWidget$1", "textChanged"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changed";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DataSourceSessionTemplatePanel$NameWidget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reset";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onNameChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class AuthWidget
    extends SimpleWidget {
        private final Project myProject;
        private final DatabaseCredentials myCredentials;
        private final DataSourceSessionTemplate myTemplate;
        private DatabaseAuthPanel myAuthPanel;

        private AuthWidget(DataSourceSessionTemplatePanel dataSourceSessionTemplatePanel, Project project, DatabaseCredentials credentials, DataSourceSessionTemplate template) {
            this.myProject = project;
            this.myCredentials = credentials;
            this.myTemplate = template;
        }

        @Override
        @Nls
        @Nullable
        public String getName() {
            return DatabaseBundle.message((String)"notification.title.authentication", (Object[])new Object[0]);
        }

        @Override
        public void save(@NotNull DataSourceSessionTemplate template) {
            if (template == null) {
                AuthWidget.$$$reportNull$$$0(0);
            }
            if (!this.isActive()) {
                template.setAuthProviderIdOverride(null);
            } else {
                this.getAuthPanel().save((DatabaseConnectionConfig)template, true);
            }
        }

        @Override
        @Nullable
        public AnAction getAction() {
            if (DatabaseAuthPanel.getApplicable((DatabaseConnectionConfig)this.myTemplate).size() < 2) {
                return null;
            }
            return super.getAction();
        }

        @Override
        public void reset(@NotNull DataSourceSessionTemplate template) {
            if (template == null) {
                AuthWidget.$$$reportNull$$$0(1);
            }
            this.setActive(template.getAuthProviderIdOverride() != null);
            this.getAuthPanel().reset((DatabaseConnectionConfig)template, true);
        }

        private DatabaseAuthPanel getAuthPanel() {
            this.getComponents();
            return this.myAuthPanel;
        }

        @Override
        protected List<JComponent> createComponents() {
            this.myAuthPanel = new DatabaseAuthPanel(this.myProject, (DatabaseConnectionConfig)this.myTemplate, this.myCredentials);
            return Collections.singletonList(this.myAuthPanel.getComponent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "template";
            objectArray2[1] = "com/intellij/database/dataSource/DataSourceSessionTemplatePanel$AuthWidget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reset";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ReadonlyWidget
    extends SimpleWidget {
        private JBCheckBox myReadonlyBox;

        private ReadonlyWidget(DataSourceSessionTemplatePanel dataSourceSessionTemplatePanel) {
        }

        @Override
        @Nls
        @Nullable
        public String getName() {
            return DatabaseBundle.message((String)"data.source.read.only.label", (Object[])new Object[0]);
        }

        @Override
        public void save(@NotNull DataSourceSessionTemplate template) {
            if (template == null) {
                ReadonlyWidget.$$$reportNull$$$0(0);
            }
            template.setReadonlyOverride(this.isActive() ? Boolean.valueOf(this.getReadonlyBox().isSelected()) : null);
        }

        private JBCheckBox getReadonlyBox() {
            this.getComponents();
            return this.myReadonlyBox;
        }

        @Override
        public void reset(@NotNull DataSourceSessionTemplate template) {
            if (template == null) {
                ReadonlyWidget.$$$reportNull$$$0(1);
            }
            this.setActive(template.getReadonlyOverride() != null);
            this.getReadonlyBox().setSelected(template.isReadOnly());
        }

        @Override
        protected List<JComponent> createComponents() {
            this.myReadonlyBox = new JBCheckBox(this.getName());
            return Collections.singletonList(this.myReadonlyBox);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "template";
            objectArray2[1] = "com/intellij/database/dataSource/DataSourceSessionTemplatePanel$ReadonlyWidget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reset";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class InitScriptWidget
    extends SimpleWidget {
        private final Project myProject;
        private final Supplier<DataSourceSessionTemplate> myCurrentTemplate;
        private EditorTextField myField;

        private InitScriptWidget(@NotNull DataSourceSessionTemplatePanel dataSourceSessionTemplatePanel, @NotNull Project project, Supplier<DataSourceSessionTemplate> currentTemplate) {
            if (project == null) {
                InitScriptWidget.$$$reportNull$$$0(0);
            }
            if (currentTemplate == null) {
                InitScriptWidget.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myCurrentTemplate = currentTemplate;
        }

        @Override
        @Nls
        @Nullable
        public String getName() {
            return StringUtil.trimEnd((String)DatabaseBundle.message((String)"data.source.startup.script.label", (Object[])new Object[0]), (String)":");
        }

        @Override
        public void save(@NotNull DataSourceSessionTemplate template) {
            if (template == null) {
                InitScriptWidget.$$$reportNull$$$0(2);
            }
            template.setInitScript(this.isActive() ? this.getField().getText() : null);
        }

        @Override
        public void reset(@NotNull DataSourceSessionTemplate template) {
            if (template == null) {
                InitScriptWidget.$$$reportNull$$$0(3);
            }
            String script2 = template.getInitScript();
            this.setActive(!Objects.equals(template.getDataSource().getInitScript(), script2));
            this.getField().setText(StringUtil.notNullize((String)script2));
        }

        private EditorTextField getField() {
            this.getComponents();
            return this.myField;
        }

        @Override
        protected List<JComponent> createComponents() {
            this.myField = DataSourceOptionsPanel.createInitScriptField(this.myProject, () -> DbSqlUtilCore.getSqlDialect((Dbms)this.myCurrentTemplate.get().getDbms()));
            return Collections.singletonList(DataSourceSessionTemplatePanel.withLabel((JComponent)this.myField, DatabaseBundle.message((String)"data.source.startup.script.label", (Object[])new Object[0])));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentTemplate";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DataSourceSessionTemplatePanel$InitScriptWidget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reset";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class UrlOverridesWidget
    implements Widget {
        private final List<UrlParamOverrideWidget> mySubWidgets = new ArrayList<UrlParamOverrideWidget>();

        private UrlOverridesWidget() {
        }

        @Override
        @Nls
        @Nullable
        public String getName() {
            return null;
        }

        @Override
        public boolean isActive() {
            return !this.mySubWidgets.isEmpty();
        }

        @Override
        public void save(@NotNull DataSourceSessionTemplate template) {
            if (template == null) {
                UrlOverridesWidget.$$$reportNull$$$0(0);
            }
            ConfigUrlOverrider urlOverrider = template.getUrlOverrider();
            Set toRemove = (Set)JBIterable.from((Iterable)urlOverrider.getParams()).map(Map.Entry::getKey).addAllTo(new HashSet());
            for (UrlParamOverrideWidget widget : this.mySubWidgets) {
                if (widget.isActive()) {
                    toRemove.remove(widget.myParamName);
                }
                widget.save(template);
            }
            for (String p : toRemove) {
                urlOverrider.setParam(p, null);
            }
        }

        @Override
        public void reset(@NotNull DataSourceSessionTemplate template) {
            if (template == null) {
                UrlOverridesWidget.$$$reportNull$$$0(1);
            }
            ConfigUrlOverrider urlOverrider = template.getUrlOverrider();
            Map<String, UrlParamOverrideWidget> existing = this.existingProperties();
            ArrayList<UrlParamOverrideWidget> overrideWidgets = new ArrayList<UrlParamOverrideWidget>();
            for (Map.Entry p : urlOverrider.getParams()) {
                UrlParamOverrideWidget widget = existing.get(p.getKey());
                if (widget != null) {
                    overrideWidgets.add(widget);
                    continue;
                }
                String caption = UrlParamOverrideWidget.getParamCaption(urlOverrider.getParamInfo(), (String)p.getKey());
                overrideWidgets.add(new UrlParamOverrideWidget((String)p.getKey(), caption));
            }
            this.mySubWidgets.clear();
            this.mySubWidgets.addAll(overrideWidgets);
            this.sortSubWidgets(urlOverrider.getParamInfo());
            for (UrlParamOverrideWidget widget : this.mySubWidgets) {
                widget.reset(template);
            }
        }

        private void sortSubWidgets(@Nullable StatelessParametersHolder info2) {
            Object2IntOpenHashMap indices = new Object2IntOpenHashMap();
            if (info2 != null) {
                int idx = 0;
                for (String p : info2.getParameterNames()) {
                    indices.put((Object)p, idx++);
                }
            }
            this.mySubWidgets.sort(Comparator.comparing(arg_0 -> UrlOverridesWidget.lambda$sortSubWidgets$0((Object2IntMap)indices, arg_0)).thenComparing(w -> w.myParamName));
        }

        @NotNull
        private Map<String, UrlParamOverrideWidget> existingProperties() {
            Map map2 = JBIterable.from(this.mySubWidgets).toReverseMap(w -> w.myParamName);
            if (map2 == null) {
                UrlOverridesWidget.$$$reportNull$$$0(2);
            }
            return map2;
        }

        @Override
        public List<JComponent> getComponents() {
            ArrayList<JComponent> res2 = new ArrayList<JComponent>();
            for (UrlParamOverrideWidget widget : this.mySubWidgets) {
                if (!widget.isActive()) continue;
                res2.addAll(widget.getComponents());
            }
            return res2;
        }

        @Override
        @Nullable
        public AnAction getAction() {
            AnAction action;
            Map<String, UrlParamOverrideWidget> existingProperties = this.existingProperties();
            DefaultActionGroup res2 = new DefaultActionGroup();
            final ConfigUrlOverrider urlOverrider = DataSourceSessionTemplatePanel.this.myTemplate.getUrlOverrider();
            StatelessParametersHolder info2 = urlOverrider.getParamInfo();
            if (info2 != null) {
                for (final String p : info2.getParameterNames()) {
                    UrlParamOverrideWidget widget = existingProperties.get(p);
                    if (widget != null) {
                        action = widget.getAction();
                        if (action == null) continue;
                        res2.add(action);
                        continue;
                    }
                    if (UrlOverridesWidget.isHiddenParameter(p)) continue;
                    final String caption = UrlParamOverrideWidget.getParamCaption(info2, p);
                    res2.add((AnAction)new ToggleAction(caption){

                        @NotNull
                        public ActionUpdateThread getActionUpdateThread() {
                            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                            if (actionUpdateThread == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return actionUpdateThread;
                        }

                        public boolean isSelected(@NotNull AnActionEvent e) {
                            if (e == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return false;
                        }

                        public void setSelected(@NotNull AnActionEvent e, boolean state) {
                            if (e == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            UrlParamOverrideWidget widget = new UrlParamOverrideWidget(p, caption);
                            UrlOverridesWidget.this.mySubWidgets.add(widget);
                            UrlOverridesWidget.this.sortSubWidgets(urlOverrider.getParamInfo());
                            DataSourceSessionTemplatePanel.this.collectWidgets();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[switch (n) {
                                default -> 2;
                                case 1, 2 -> 3;
                            }];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceSessionTemplatePanel$UrlOverridesWidget$1";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "e";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getActionUpdateThread";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceSessionTemplatePanel$UrlOverridesWidget$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray;
                                    objectArray[2] = "isSelected";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray;
                                    objectArray[2] = "setSelected";
                                    break;
                                }
                            }
                            String string = String.format(v0, objectArray);
                            throw switch (n) {
                                default -> new IllegalStateException(string);
                                case 1, 2 -> new IllegalArgumentException(string);
                            };
                        }
                    });
                }
            }
            HashSet visited = info2 == null ? Collections.emptySet() : new HashSet(info2.getParameterNames());
            for (UrlParamOverrideWidget widget : existingProperties.values()) {
                if (visited.contains(widget.myParamName) || (action = widget.getAction()) == null) continue;
                res2.add(action);
            }
            return res2;
        }

        private static boolean isHiddenParameter(String p) {
            if ("password".equals(p) || "user".equals(p)) {
                return true;
            }
            return "host".equals(p) || "port".equals(p) || "file".equals(p) || "path".equals(p) || "SID".equals(p) || "service".equals(p) || "tns_name".equals(p) || "localdb_pipe".equals(p) || "instance".equals(p);
        }

        private static /* synthetic */ Integer lambda$sortSubWidgets$0(Object2IntMap indices, UrlParamOverrideWidget w) {
            return indices.getOrDefault((Object)w.myParamName, Integer.MAX_VALUE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceSessionTemplatePanel$UrlOverridesWidget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceSessionTemplatePanel$UrlOverridesWidget";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "existingProperties";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static interface Widget {
        public boolean isActive();

        @Nls
        @Nullable
        public String getName();

        public void save(@NotNull DataSourceSessionTemplate var1);

        public void reset(@NotNull DataSourceSessionTemplate var1);

        @Nullable
        public AnAction getAction();

        public List<JComponent> getComponents();
    }

    private class UrlParamOverrideWidget
    extends SimpleWidget {
        private final String myParamName;
        @Nls
        private String myCaption;
        private JBTextField myField;

        private UrlParamOverrideWidget(@Nls @NotNull String paramName, String caption) {
            if (paramName == null) {
                UrlParamOverrideWidget.$$$reportNull$$$0(0);
            }
            if (caption == null) {
                UrlParamOverrideWidget.$$$reportNull$$$0(1);
            }
            this.myParamName = paramName;
            this.myCaption = caption;
            this.setActive(true);
        }

        @Nls
        @NotNull
        private static String getParamCaption(@Nullable StatelessParametersHolder info2, @NotNull String p) {
            if (p == null) {
                UrlParamOverrideWidget.$$$reportNull$$$0(2);
            }
            StatelessParametersHolder.ParameterInfo pInfo = info2 == null ? null : info2.getParameterInfo(p);
            String string = BaseTypeDescriptor.formatCaption(pInfo == null ? p : pInfo.getType(), p);
            if (string == null) {
                UrlParamOverrideWidget.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = this.myCaption;
            if (string == null) {
                UrlParamOverrideWidget.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public void save(@NotNull DataSourceSessionTemplate template) {
            if (template == null) {
                UrlParamOverrideWidget.$$$reportNull$$$0(5);
            }
            template.getUrlOverrider().setParam(this.myParamName, this.isActive() ? this.getField().getText() : null);
        }

        @Override
        public void reset(@NotNull DataSourceSessionTemplate template) {
            if (template == null) {
                UrlParamOverrideWidget.$$$reportNull$$$0(6);
            }
            ConfigUrlOverrider urlOverrider = template.getUrlOverrider();
            this.myCaption = UrlParamOverrideWidget.getParamCaption(urlOverrider.getParamInfo(), this.myParamName);
            String override = urlOverrider.getParam(this.myParamName);
            this.setActive(override != null);
            if (override == null) {
                override = (String)urlOverrider.getOrigParams().get(this.myParamName);
            }
            this.getField().setText(StringUtil.notNullize((String)override));
        }

        private JBTextField getField() {
            this.getComponents();
            return this.myField;
        }

        @Override
        protected List<JComponent> createComponents() {
            @NlsSafe String value = (String)DataSourceSessionTemplatePanel.this.myTemplate.getUrlOverrider().getOrigParams().get(this.myParamName);
            this.myField = new JBTextField(StringUtil.notNullize((String)value));
            return Collections.singletonList(DataSourceSessionTemplatePanel.withLabel((JComponent)this.myField, this.getName() + ":"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paramName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caption";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceSessionTemplatePanel$UrlParamOverrideWidget";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceSessionTemplatePanel$UrlParamOverrideWidget";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParamCaption";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getParamCaption";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private abstract class SimpleWidget
    implements Widget {
        private List<JComponent> myComponents;
        private boolean isActive;

        private SimpleWidget() {
        }

        @Override
        public boolean isActive() {
            return this.isActive;
        }

        protected void setActive(boolean active) {
            this.isActive = active;
        }

        @Override
        @Nullable
        public AnAction getAction() {
            String name = this.getName();
            if (name == null) {
                return null;
            }
            return new ToggleAction(name){

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                    if (actionUpdateThread == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return actionUpdateThread;
                }

                public boolean isDumbAware() {
                    return true;
                }

                public boolean isSelected(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return SimpleWidget.this.isActive();
                }

                public void setSelected(@NotNull AnActionEvent e, boolean state) {
                    if (e == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    SimpleWidget.this.setActive(state);
                    DataSourceSessionTemplatePanel.this.collectWidgets();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 1, 2 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/dataSource/DataSourceSessionTemplatePanel$SimpleWidget$1";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionUpdateThread";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/dataSource/DataSourceSessionTemplatePanel$SimpleWidget$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "isSelected";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "setSelected";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string);
                        case 1, 2 -> new IllegalArgumentException(string);
                    };
                }
            };
        }

        @Override
        public List<JComponent> getComponents() {
            if (this.myComponents == null) {
                this.myComponents = this.createComponents();
            }
            return this.myComponents;
        }

        protected abstract List<JComponent> createComponents();
    }
}

