/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloseSessionAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CloseSessionAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        DatabaseSession session;
        if (e == null) {
            CloseSessionAction.$$$reportNull$$$0(1);
        }
        boolean visible = (session = DatabaseSessionManager.findSession((AnActionEvent)e)) != null;
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && CloseSessionAction.canClose(session));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DatabaseSession session;
        if (e == null) {
            CloseSessionAction.$$$reportNull$$$0(2);
        }
        if ((session = DatabaseSessionManager.findSession((AnActionEvent)e)) != null) {
            CloseSessionAction.close(session);
        }
    }

    public static boolean canClose(@NotNull DatabaseSession session) {
        if (session == null) {
            CloseSessionAction.$$$reportNull$$$0(3);
        }
        return SessionsUtil.canClose((DatabaseSession)session);
    }

    public static void close(@NotNull DatabaseSession session) {
        if (session == null) {
            CloseSessionAction.$$$reportNull$$$0(4);
        }
        SessionsUtil.close((DatabaseSession)session);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/CloseSessionAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/CloseSessionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canClose";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "close";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    public static class CloseAll
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                CloseAll.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseAll.$$$reportNull$$$0(1);
            }
            LocalDataSource localDataSource = CloseAll.getDataSource(e);
            Project project = e.getProject();
            if (localDataSource == null || project == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(CloseAll.canCloseAll(project, localDataSource));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseAll.$$$reportNull$$$0(2);
            }
            LocalDataSource localDataSource = CloseAll.getDataSource(e);
            Project project = e.getProject();
            if (localDataSource != null && project != null) {
                CloseAll.closeAll(project, localDataSource);
            }
        }

        public static boolean canCloseAll(@NotNull Project project, @NotNull LocalDataSource localDataSource) {
            if (project == null) {
                CloseAll.$$$reportNull$$$0(3);
            }
            if (localDataSource == null) {
                CloseAll.$$$reportNull$$$0(4);
            }
            List sessions = DatabaseSessionManager.getSessions((Project)project, (LocalDataSource)localDataSource);
            for (DatabaseSession session : sessions) {
                if (CloseSessionAction.canClose(session)) continue;
                return false;
            }
            return true;
        }

        public static void closeAll(@NotNull Project project, @NotNull LocalDataSource localDataSource) {
            if (project == null) {
                CloseAll.$$$reportNull$$$0(5);
            }
            if (localDataSource == null) {
                CloseAll.$$$reportNull$$$0(6);
            }
            List sessions = DatabaseSessionManager.getSessions((Project)project, (LocalDataSource)localDataSource);
            for (DatabaseSession session : sessions) {
                CloseSessionAction.close(session);
            }
        }

        @Nullable
        private static LocalDataSource getDataSource(@NotNull AnActionEvent e) {
            PsiElement[] data;
            if (e == null) {
                CloseAll.$$$reportNull$$$0(7);
            }
            return (data = (PsiElement[])e.getData(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY)) == null || data.length != 1 ? null : DbImplUtil.getMaybeLocalDataSource((DasDataSource)((DasDataSource)ObjectUtils.tryCast((Object)data[0], DasDataSource.class)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/CloseSessionAction$CloseAll";
                    break;
                }
                case 1: 
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localDataSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/CloseSessionAction$CloseAll";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "canCloseAll";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "closeAll";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataSource";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
            };
        }
    }
}

