/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.actions.QueryActionBase;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleBase;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.dump.ConsoleHandler;
import com.intellij.database.dump.DatabaseViewHandler;
import com.intellij.database.dump.DumpHandler;
import com.intellij.database.dump.ExtractionHelper;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.actions.ConsoleSource;
import com.intellij.database.run.actions.DbTablesSource;
import com.intellij.database.run.actions.DumpSource;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DumpAction {
    private final DataExtractorFactory myFactory;
    private final ExtractionConfig myConfig;

    public DumpAction(@NotNull DataExtractorFactory factory, @NotNull ExtractionConfig config) {
        if (factory == null) {
            DumpAction.$$$reportNull$$$0(0);
        }
        if (config == null) {
            DumpAction.$$$reportNull$$$0(1);
        }
        this.myFactory = factory;
        this.myConfig = config;
    }

    public void actionPerformed(@NotNull Project project, @NotNull DumpSource<?> source) {
        DumpHandler<?> handler2;
        if (project == null) {
            DumpAction.$$$reportNull$$$0(2);
        }
        if (source == null) {
            DumpAction.$$$reportNull$$$0(3);
        }
        if ((handler2 = DumpAction.createHandler(project, source, this.createHelper(), this.myConfig, this.myFactory)) == null) {
            return;
        }
        handler2.performDump(project);
    }

    @Nullable
    public static DumpHandler<?> createHandler(@NotNull Project project, @NotNull DumpSource<?> source, ExtractionHelper manager, @NotNull ExtractionConfig config, @NotNull DataExtractorFactory factory) {
        DatabaseViewHandler databaseViewHandler;
        if (project == null) {
            DumpAction.$$$reportNull$$$0(4);
        }
        if (source == null) {
            DumpAction.$$$reportNull$$$0(5);
        }
        if (config == null) {
            DumpAction.$$$reportNull$$$0(6);
        }
        if (factory == null) {
            DumpAction.$$$reportNull$$$0(7);
        }
        if (source instanceof ConsoleSource) {
            databaseViewHandler = DumpAction.createConsoleHandler((ConsoleSource)source, manager, factory, config);
        } else if (source instanceof DumpSource.DataGridSource) {
            DumpSource.DataGridSource gridSource = (DumpSource.DataGridSource)source;
            databaseViewHandler = GridHelper.get((CoreGrid)gridSource.getGrid()).createDumpHandler((DumpSource)gridSource, manager, factory, config);
        } else {
            databaseViewHandler = new DatabaseViewHandler(project, ((DbTablesSource)source).getSources(), manager, config, factory);
        }
        return databaseViewHandler;
    }

    @Nullable
    private static DumpHandler<?> createConsoleHandler(@NotNull ConsoleSource source, @NotNull ExtractionHelper manager, @NotNull DataExtractorFactory factory, @NotNull ExtractionConfig config) {
        if (source == null) {
            DumpAction.$$$reportNull$$$0(8);
        }
        if (manager == null) {
            DumpAction.$$$reportNull$$$0(9);
        }
        if (factory == null) {
            DumpAction.$$$reportNull$$$0(10);
        }
        if (config == null) {
            DumpAction.$$$reportNull$$$0(11);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        if (!source.getConsole().beforeExecuteQueries(source.getModel())) {
            return null;
        }
        JBIterable<String> queries = source.getSources();
        if (queries.isEmpty()) {
            return null;
        }
        Project project = source.getConsole().getProject();
        return new ConsoleHandler(project, queries, source.getConsole(), manager, factory, config);
    }

    @Nullable
    public static DumpSource<?> getDumpSource(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            DumpAction.$$$reportNull$$$0(12);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null) {
            return dataGrid.isReady() && !dataGrid.isEmpty() ? GridHelper.get((CoreGrid)dataGrid).createDumpSource(dataGrid, e) : null;
        }
        JdbcConsole console = JdbcConsole.findConsole(e);
        JdbcConsoleProvider.Info info2 = QueryActionBase.getInfoClassic(e, DatabaseSettings.getDefaultExecOption(), null);
        if (console != null && info2 != null) {
            return new ConsoleSource(console, DumpAction.getAdjustedScriptModel(info2));
        }
        JBIterable elements = DatabaseContextFun.getSelectedDbElementsExpandingGroups(e.getDataContext()).filter(o -> DbImplUtilCore.isDataTable((ObjectKind)o.getKind()));
        JBIterable<DbTable> tables = DumpAction.getTables((JBIterable<DbElement>)elements);
        return tables.isEmpty() ? null : new DbTablesSource(tables);
    }

    @NotNull
    private static ScriptModel<?> getAdjustedScriptModel(@NotNull JdbcConsoleProvider.Info info2) {
        if (info2 == null) {
            DumpAction.$$$reportNull$$$0(13);
        }
        TextRange range = ScriptModelUtil.getSelectionForConsole((Editor)info2.editor, info2.execOption);
        TextRange adjusted = ScriptModelUtil.adjustSelectionRange(info2.model, (Document)info2.editor.getDocument(), range, info2.execOption);
        ScriptModel scriptModel = info2.model.subModel(adjusted);
        if (scriptModel == null) {
            DumpAction.$$$reportNull$$$0(14);
        }
        return scriptModel;
    }

    @NotNull
    private static JBIterable<DbTable> getTables(@NotNull JBIterable<DbElement> elements) {
        if (elements == null) {
            DumpAction.$$$reportNull$$$0(15);
        }
        Set sources = elements.map(e -> e.getDataSource()).toSet();
        List canConnectSources = ContainerUtil.filter((Collection)sources, DbImplUtilCore::canConnectTo);
        JBIterable jBIterable = elements.filter(e -> canConnectSources.contains(e.getDataSource())).flatten(r -> ((JBTreeTraverser)((JBTreeTraverser)DbImplUtilCore.traverseVisibleObjects((DasDataSource)r.getDataSource()).withRoot(r)).expand(Conditions.not((Condition)DasUtil.byClass(DasSchemaChild.class)))).filter(DbTable.class));
        if (jBIterable == null) {
            DumpAction.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    @NotNull
    public static Dbms getDbms(@Nullable DumpSource<?> object) {
        if (object instanceof ConsoleSource) {
            Dbms dbms = DbImplUtil.getDbms((JdbcConsoleBase)((ConsoleSource)object).getConsole());
            if (dbms == null) {
                DumpAction.$$$reportNull$$$0(17);
            }
            return dbms;
        }
        if (object instanceof DbTablesSource) {
            Dbms dbms = DbImplUtilCore.getDbms((DbElement)((DbElement)((DbTablesSource)object).getSources().first()));
            if (dbms == null) {
                DumpAction.$$$reportNull$$$0(18);
            }
            return dbms;
        }
        if (object instanceof DumpSource.DataGridSource) {
            Dbms dbms = DataGridUtil.getDbms(((DumpSource.DataGridSource)object).getGrid());
            if (dbms == null) {
                DumpAction.$$$reportNull$$$0(19);
            }
            return dbms;
        }
        Dbms dbms = Dbms.UNKNOWN;
        if (dbms == null) {
            DumpAction.$$$reportNull$$$0(20);
        }
        return dbms;
    }

    @NotNull
    public abstract ExtractionHelper createHelper();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 16, 17, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/DumpAction";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/DumpAction";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdjustedScriptModel";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTables";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleHandler";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDumpSource";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAdjustedScriptModel";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTables";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 16, 17, 18, 19, 20 -> new IllegalStateException(string);
        };
    }

    public static class ToFile
    extends DumpAction {
        private final File myFile;

        public ToFile(@NotNull DataExtractorFactory factory, @NotNull ExtractionConfig config, @NotNull File file) {
            if (factory == null) {
                ToFile.$$$reportNull$$$0(0);
            }
            if (config == null) {
                ToFile.$$$reportNull$$$0(1);
            }
            if (file == null) {
                ToFile.$$$reportNull$$$0(2);
            }
            super(factory, config);
            this.myFile = file;
        }

        @Override
        @NotNull
        public ExtractionHelper createHelper() {
            return new ExtractionHelper.FileExtractionHelper(this.myFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "factory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "config";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/DumpAction$ToFile";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ToClipboard
    extends DumpAction {
        public ToClipboard(@NotNull DataExtractorFactory factory, @NotNull ExtractionConfig config) {
            if (factory == null) {
                ToClipboard.$$$reportNull$$$0(0);
            }
            if (config == null) {
                ToClipboard.$$$reportNull$$$0(1);
            }
            super(factory, config);
        }

        @Override
        @NotNull
        public ExtractionHelper createHelper() {
            return new ExtractionHelper.ClipboardExtractionHelper();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "factory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "config";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/DumpAction$ToClipboard";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

