/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DialogBootstrapper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.VmElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelModifiedCache;
import com.intellij.database.schemaEditor.model.state.DbObjectModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Pair;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 72\u00020\u0001:\u00017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020$JF\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020'2\u001a\u0010(\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010+\u0012\u0004\u0012\u00020,0*0)2\u001a\u0010-\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010+\u0012\u0004\u0012\u00020,0*0)J,\u0010.\u001a\u00020 2\u0010\u0010/\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u000301002\u0012\u00102\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0018\u000103J\u000e\u00104\u001a\u00020$H\u0096@\u00a2\u0006\u0002\u00105J\b\u00106\u001a\u00020 H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0014\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u00068"}, d2={"Lcom/intellij/database/schemaEditor/DbEditorDialogModel;", "Lcom/intellij/openapi/Disposable;", "bootstrapper", "Lcom/intellij/database/editor/DialogBootstrapper;", "<init>", "(Lcom/intellij/database/editor/DialogBootstrapper;)V", "modelController", "Lcom/intellij/database/schemaEditor/model/DbEditorModelController;", "getModelController", "()Lcom/intellij/database/schemaEditor/model/DbEditorModelController;", "myMatcher", "Lcom/intellij/database/schemaEditor/ElementMatcher;", "targetOwner", "Lcom/intellij/database/schemaEditor/ElementOwner;", "getTargetOwner", "()Lcom/intellij/database/schemaEditor/ElementOwner;", "identity", "Lcom/intellij/database/schemaEditor/ElementIdentity;", "getIdentity", "()Lcom/intellij/database/schemaEditor/ElementIdentity;", "editorModel", "Lcom/intellij/database/schemaEditor/model/DbEditorModel;", "getEditorModel", "()Lcom/intellij/database/schemaEditor/model/DbEditorModel;", "supplier", "Lkotlin/Function0;", "Lcom/intellij/database/script/generator/ScriptingOptions;", "getSupplier", "()Lkotlin/jvm/functions/Function0;", "setSupplier", "(Lkotlin/jvm/functions/Function0;)V", "fillContext", "", "handler", "Lcom/intellij/database/view/DatabaseRefactoringHandler;", "isModified", "", "collectChangesInVm", "localDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "toRemove", "", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/database/util/ObjectPath;", "Lcom/intellij/database/model/basic/VmElement;", "toAdd", "fillCorrespondence", "correspondence", "", "Lcom/intellij/database/model/ElementDelta;", "filter", "Ljava/util/function/Predicate;", "waitBackgroundTasks", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "Companion", "intellij.database.impl"})
public class DbEditorDialogModel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DbEditorModelController modelController;
    @NotNull
    private final ElementMatcher myMatcher;
    @NotNull
    private final ElementOwner targetOwner;
    @NotNull
    private final ElementIdentity<?> identity;
    @NotNull
    private final DbEditorModel<?, ?> editorModel;
    @NotNull
    private Function0<? extends ScriptingOptions> supplier;

    public DbEditorDialogModel(@NotNull DialogBootstrapper bootstrapper) {
        Intrinsics.checkNotNullParameter((Object)bootstrapper, (String)"bootstrapper");
        this.modelController = bootstrapper.getController();
        this.myMatcher = bootstrapper.getElementMatcher();
        this.targetOwner = bootstrapper.getTargetElementOwner();
        this.identity = bootstrapper.getElementIdentity();
        this.editorModel = bootstrapper.getModel();
        this.supplier = DbEditorDialogModel::supplier$lambda$0;
        this.modelController.setScriptingOptions(() -> DbEditorDialogModel._init_$lambda$0(this));
    }

    @NotNull
    public final DbEditorModelController getModelController() {
        return this.modelController;
    }

    @NotNull
    public final ElementOwner getTargetOwner() {
        return this.targetOwner;
    }

    @NotNull
    public final ElementIdentity<?> getIdentity() {
        return this.identity;
    }

    @NotNull
    public final DbEditorModel<?, ?> getEditorModel() {
        return this.editorModel;
    }

    @NotNull
    public final Function0<ScriptingOptions> getSupplier() {
        return this.supplier;
    }

    public final void setSupplier(@NotNull Function0<? extends ScriptingOptions> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.supplier = function0;
    }

    public final void fillContext(@NotNull DatabaseRefactoringHandler handler2) {
        BasicElement original;
        ElementOwner oOwner;
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        LocalDataSource localDataSource = handler2.getDataSource();
        ElementMatcher elementMatcher = this.modelController.getMatcher();
        Intrinsics.checkNotNullExpressionValue((Object)elementMatcher, (String)"getMatcher(...)");
        ElementMatcher matcher = elementMatcher;
        ElementOwner elementOwner = oOwner = matcher.getOriginalOwner();
        BasicElement basicElement = original = elementOwner != null ? elementOwner.find(this.identity) : null;
        if (this.identity.getMetaObject().kindOf(BasicMateNamespace.class) && localDataSource.shouldTrackNamespaces()) {
            ObjectPath src = BasicPaths.of((BasicElement)original);
            ObjectPath tgt = BasicPaths.of((BasicElement)this.targetOwner.findOrCreate(this.identity));
            handler2.getScopeUpdater().toRemove(src);
            handler2.getScopeUpdater().toAdd(tgt);
            handler2.include(tgt);
        } else if (original == null) {
            ElementIdentity targetParentId = this.myMatcher.getParent(this.identity);
            if (targetParentId != null) {
                ElementOwner elementOwner2 = oOwner;
                BasicElement originalParent = elementOwner2 != null ? elementOwner2.find(targetParentId) : null;
                handler2.include(originalParent);
            }
        } else {
            BasicElement target;
            handler2.include(original);
            if (original instanceof BasicMajorObject && (target = this.targetOwner.find(this.identity)) != null) {
                String originName = ((BasicMajorObject)original).getNaturalName();
                String targetName = target.getNaturalName();
                if (originName != null && targetName != null && !Intrinsics.areEqual((Object)targetName, (Object)originName)) {
                    handler2.include(ModelFun.getObjectPath((BasicElement)target));
                }
            }
        }
        if (original == null) {
            handler2.setElementToFocus(BasicPaths.of((BasicElement)this.targetOwner.findOrCreate(this.identity)));
        }
    }

    public final boolean isModified() {
        DbEditorModelController controller = this.modelController;
        ElementMatcher elementMatcher = controller.getMatcher();
        Intrinsics.checkNotNullExpressionValue((Object)elementMatcher, (String)"getMatcher(...)");
        ElementMatcher matcher = elementMatcher;
        DbModelModifiedCache dbModelModifiedCache = controller.getModifiedCache();
        Intrinsics.checkNotNullExpressionValue((Object)dbModelModifiedCache, (String)"getModifiedCache(...)");
        DbModelModifiedCache modCache = dbModelModifiedCache;
        ElementOwner oOwner = matcher.getOriginalOwner();
        for (ElementIdentity identity : this.targetOwner.getCached()) {
            boolean exists;
            DbEditorModel model = controller.getStructureNodeModel(identity);
            ElementOwner elementOwner = oOwner;
            BasicElement original = elementOwner != null ? elementOwner.find(identity) : null;
            boolean existed = original != null;
            ElementIdentity elementIdentity = identity;
            Intrinsics.checkNotNull((Object)elementIdentity);
            boolean bl = exists = !this.targetOwner.isDropped(elementIdentity);
            if (existed != exists) {
                return true;
            }
            if (model == null || !modCache.isModified(model)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public final void collectChangesInVm(@NotNull LocalDataSource localDataSource, @NotNull List<Pair<ObjectPath, VmElement>> toRemove, @NotNull List<Pair<ObjectPath, VmElement>> toAdd) {
        Intrinsics.checkNotNullParameter((Object)localDataSource, (String)"localDataSource");
        Intrinsics.checkNotNullParameter(toRemove, (String)"toRemove");
        Intrinsics.checkNotNullParameter(toAdd, (String)"toAdd");
        generator = (ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(localDataSource.getDbms());
        oOwner = this.myMatcher.getOriginalOwner();
        for (ElementIdentity identity : this.targetOwner.getCached()) {
            if (ElementIdentity.tryCast((ElementIdentity)identity, VmElement.class) == null) continue;
            parent = this.myMatcher.getParent(vmId);
            v0 = oOwner;
            v1 = orig = v0 != null ? (VmElement)v0.find(vmId) : null;
            if (orig == null) ** GOTO lbl-1000
            v2 = parent;
            if (v2 == null) lbl-1000:
            // 2 sources

            {
                v3 = null;
            } else {
                v3 = oOwner.find(v2);
            }
            origParent = v3;
            tgt = (VmElement)this.targetOwner.find(vmId);
            v4 = tgtParent = tgt == null || parent == null ? null : this.targetOwner.find(parent);
            if (tgt != null && orig != null && generator.isEqual((BasicElement)orig, (BasicElement)tgt, (ScriptingOptions)DefaultScriptingOptions.INSTANCE)) continue;
            if (orig != null && origParent != null) {
                v5 = Pair.create((Object)ObjectPaths.of((DasObject)((DasObject)origParent)), (Object)orig);
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"create(...)");
                toRemove.add((Pair<ObjectPath, VmElement>)v5);
            }
            if (tgt == null || tgtParent == null) continue;
            v6 = Pair.create((Object)ObjectPaths.of((DasObject)((DasObject)tgtParent)), (Object)tgt);
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"create(...)");
            toAdd.add((Pair<ObjectPath, VmElement>)v6);
        }
    }

    public final void fillCorrespondence(@NotNull Set<ElementDelta<?>> correspondence, @Nullable Predicate<ElementIdentity<?>> filter) {
        Intrinsics.checkNotNullParameter(correspondence, (String)"correspondence");
        Companion.fillCorrespondence(correspondence, this.myMatcher.getOriginalOwner(), this.targetOwner, this.modelController, filter);
    }

    @Nullable
    public Object waitBackgroundTasks(@NotNull Continuation<? super Boolean> $completion) {
        return DbEditorDialogModel.waitBackgroundTasks$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object waitBackgroundTasks$suspendImpl(DbEditorDialogModel $this, Continuation<? super Boolean> $completion) {
        return $this.modelController.getTransactionManager().waitAllFinished($completion);
    }

    public void dispose() {
    }

    private static final DefaultScriptingOptions supplier$lambda$0() {
        return DefaultScriptingOptions.INSTANCE;
    }

    private static final ScriptingOptions _init_$lambda$0(DbEditorDialogModel this$0) {
        return (ScriptingOptions)this$0.supplier.invoke();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\u00020\u00052\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0018\u00010\u000fJ\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\nJ\u001c\u0010\u0012\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J0\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0018\u00010\u000fJ$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u000b\u001a\u00020\nH\u0002J.\u0010\u0004\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/schemaEditor/DbEditorDialogModel$Companion;", "", "<init>", "()V", "fillCorrespondence", "", "correspondence", "", "Lcom/intellij/database/model/ElementDelta;", "originalOwner", "Lcom/intellij/database/schemaEditor/ElementOwner;", "targetOwner", "controller", "Lcom/intellij/database/schemaEditor/model/DbEditorModelController;", "filter", "Ljava/util/function/Predicate;", "Lcom/intellij/database/schemaEditor/ElementIdentity;", "fillModelCache", "fillModifiedCache", "identity", "findSearchPathExample", "isInterestingObject", "", "orig", "Lcom/intellij/database/model/basic/BasicElement;", "edited", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void fillCorrespondence(@NotNull Set<ElementDelta<?>> correspondence, @Nullable ElementOwner originalOwner, @NotNull ElementOwner targetOwner, @NotNull DbEditorModelController controller, @Nullable Predicate<ElementIdentity<?>> filter) {
            Intrinsics.checkNotNullParameter(correspondence, (String)"correspondence");
            Intrinsics.checkNotNullParameter((Object)targetOwner, (String)"targetOwner");
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            this.fillModelCache(controller, targetOwner);
            for (ElementIdentity identity : targetOwner.getCached()) {
                Predicate<ElementIdentity<?>> predicate = filter;
                if ((predicate != null ? !predicate.test(identity) : false) || identity.getMetaObject().kindOf(BasicRoot.class)) continue;
                ElementOwner elementOwner = originalOwner;
                BasicElement original = elementOwner != null ? elementOwner.find(identity) : null;
                BasicElement target = targetOwner.find(identity);
                if (original == null && target == null || original instanceof BasicDataObject || target instanceof BasicDataObject || original != null && target != null && controller.getObjectModelState(identity) == null) continue;
                this.fillCorrespondence(original, target, correspondence);
                correspondence.add(ElementDelta.Companion.create(original, target));
            }
        }

        public final void fillModelCache(@NotNull DbEditorModelController controller, @NotNull ElementOwner targetOwner) {
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            Intrinsics.checkNotNullParameter((Object)targetOwner, (String)"targetOwner");
            for (ElementIdentity identity : targetOwner.getCached()) {
                Intrinsics.checkNotNull((Object)identity);
                this.fillModifiedCache(controller, identity);
            }
        }

        private final void fillModifiedCache(DbEditorModelController controller, ElementIdentity<?> identity) {
            DbEditorModel<?, DbStructureObjectModelState<?>> model = controller.getStructureNodeModel(identity);
            if (model != null) {
                controller.getModifiedCache().isModified(model);
            }
        }

        @Nullable
        public final ElementIdentity<?> findSearchPathExample(@NotNull ElementOwner targetOwner, @NotNull DbEditorModelController controller, @Nullable Predicate<ElementIdentity<?>> filter) {
            Intrinsics.checkNotNullParameter((Object)targetOwner, (String)"targetOwner");
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            ElementIdentity res2 = null;
            for (ElementIdentity identity : targetOwner.getCached()) {
                BasicMetaObject m2;
                Predicate<ElementIdentity<?>> predicate = filter;
                if ((predicate != null ? !predicate.test(identity) : false) || identity.getMetaObject().kindOf(BasicRoot.class)) continue;
                Intrinsics.checkNotNull((Object)identity);
                if (!this.isInterestingObject(controller, identity, targetOwner)) continue;
                ElementIdentity elementIdentity = res2;
                BasicMetaObject m1 = elementIdentity != null ? elementIdentity.getMetaObject() : null;
                Intrinsics.checkNotNullExpressionValue((Object)identity.getMetaObject(), (String)"getMetaObject(...)");
                if (Intrinsics.areEqual((Object)m1, (Object)m2) || m1 != null && BasicMetaUtils.getDepth((BasicMetaObject)m1) > BasicMetaUtils.getDepth((BasicMetaObject)m2)) continue;
                res2 = identity;
            }
            return res2;
        }

        private final boolean isInterestingObject(DbEditorModelController controller, ElementIdentity<?> identity, ElementOwner targetOwner) {
            DbEditorModel<?, DbObjectModelState<?>> dbEditorModel = controller.getObjectModel(identity);
            if (dbEditorModel == null) {
                return false;
            }
            DbEditorModel<?, DbObjectModelState<?>> model = dbEditorModel;
            boolean targetExists = targetOwner.find(identity) != null;
            ElementOwner elementOwner = targetOwner.getOriginal();
            boolean sourceExists = (elementOwner != null ? elementOwner.find(identity) : null) != null;
            return targetExists != sourceExists || controller.getModifiedCache().isModified(model);
        }

        private final void fillCorrespondence(BasicElement orig, BasicElement edited, Set<ElementDelta<?>> correspondence) {
            BasicElement e1 = orig;
            BasicElement e2 = edited;
            while (e1 != null && e2 != null) {
                if (e1.getKind() == ObjectKind.ROOT) {
                    e1 = e1.getParent();
                    e2 = e2.getParent();
                    continue;
                }
                if (!correspondence.add(ElementDelta.Companion.create(e1, e2))) break;
                e1 = e1.getParent();
                e2 = e2.getParent();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

