/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.DbModelRegistry;
import com.intellij.database.dataSource.DataSourceFun;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObjectFun;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.FamilyWithId;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewPanel;
import com.intellij.database.view.DatabaseViewTreeFun;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.SelectInDatabaseView;
import com.intellij.database.view.structure.DvHostNode;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.actions.SelectInContextImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0015\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0002\u00a2\u0006\u0002\u0010\u0006\u001a\u0010\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b*\u00020\u0002\u001a\f\u0010\t\u001a\u0004\u0018\u00010\u0005*\u00020\u0002\u001a\u0010\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\b*\u00020\u0002\u001a\u0010\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\b*\u00020\u0002\u001a\u0010\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b*\u00020\u0002\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\r*\u00020\u0002\u001a\u0010\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u0002\u001a\f\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0002\u001a\u0010\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015*\u00020\u0002\u001a\u0010\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\b*\u00020\u0002\u001a\u0010\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\b*\u00020\u0002\u001a\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\b*\b\u0012\u0004\u0012\u00020\u001a0\bH\u0002\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\r*\u00020\u001aH\u0002\u001a\u0010\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\b*\u00020\u0002\u001a(\u0010 \u001a\b\u0012\u0004\u0012\u0002H!0\b\"\b\b\u0000\u0010!*\u00020\u001a*\u00020\u00022\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#\u001a\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\b2\u0006\u0010&\u001a\u00020\u0002\u001a\u0010\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\b*\u00020\u0002\u001a\u0010\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001a0\b*\u00020\u0002\u001a\u0012\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015*\u00020\u0002H\u0000\u001a\u0012\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001a0\b*\u00020\u0002H\u0002\u001a\f\u0010+\u001a\u0004\u0018\u00010\u001a*\u00020\u0002\u001a\f\u0010,\u001a\u0004\u0018\u00010\r*\u00020\u0002\u001a$\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00170\bH\u0007\u001a\u001b\u00100\u001a\u0004\u0018\u00010.2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u0017H\u0083\b\u001a#\u00102\u001a\b\u0012\u0004\u0012\u0002H30\b\"\u0006\b\u0000\u00103\u0018\u0001*\n\u0012\u0006\b\u0001\u0012\u0002040\bH\u0086\b\u001aE\u00105\u001a\b\u0012\u0004\u0012\u0002H30\b\"\b\b\u0000\u00106*\u000204\"\b\b\u0001\u00103*\u000204*\b\u0012\u0004\u0012\u0002H60\b2\u0016\b\b\u00107\u001a\u0010\u0012\u0004\u0012\u0002H6\u0012\u0006\u0012\u0004\u0018\u0001H308H\u0082\b\"\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00069"}, d2={"fromDatabaseTree", "", "Lcom/intellij/openapi/actionSystem/DataContext;", "getSelectedNodesArray", "", "Lcom/intellij/database/model/basic/BasicNode;", "(Lcom/intellij/openapi/actionSystem/DataContext;)[Lcom/intellij/database/model/basic/BasicNode;", "getSelectedNodes", "Lcom/intellij/util/containers/JBIterable;", "getSelectedSingleNode", "getSelectedNodesExpandingGroups", "getSelectedNodesWithParentsForGroups", "getSelectedElements", "Lcom/intellij/database/model/basic/BasicElement;", "getSelectedSingleElement", "getSelectedTreeNodeRanks", "", "Lcom/intellij/database/view/structure/DvTreeNodeRank;", "getSelectionRelatedSingleDataSource", "Lcom/intellij/database/view/DataSourceNode;", "getSelectionRelatedDataSources", "", "getSelectedDataSources", "Lcom/intellij/database/model/RawDataSource;", "getActualElements", "toBasicElements", "Lcom/intellij/database/psi/DbElement;", "toBasicElement", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "(Lcom/intellij/openapi/actionSystem/DataContext;)Lcom/intellij/openapi/project/Project;", "getSelectedDbElements", "T", "clazz", "Ljava/lang/Class;", "getSelectedPsiElements", "Lcom/intellij/psi/PsiElement;", "dataContext", "getSelectedDbElementsExpandingGroups", "getSelectedDbElementsWithParentsForGroups", "getSelectedDbElementsIfNoSelectionInTheTreeAsList", "getSelectedDbElementsIfNoSelectionInTheTree", "getSelectedDbElementFromEditor", "getEditorObject", "findDbDataSources", "Lcom/intellij/database/psi/DbDataSource;", "dataSources", "findDbDataSource", "dataSource", "filterBy", "Y", "", "filterMap2", "X", "f", "Lkotlin/Function1;", "intellij.database.impl"})
@JvmName(name="DatabaseContextFun")
@SourceDebugExtension(value={"SMAP\nDatabaseContextFun.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseContextFun.kt\ncom/intellij/database/view/DatabaseContextFun\n+ 2 UiDataProvider.kt\ncom/intellij/openapi/actionSystem/UiDataProviderKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,353:1\n346#1:361\n352#1:362\n352#1:363\n346#1:368\n346#1:369\n346#1:376\n346#1:377\n346#1:379\n343#1:403\n238#2:354\n238#2:355\n238#2:356\n238#2:357\n238#2:360\n238#2:364\n238#2:365\n238#2:366\n238#2:367\n238#2:370\n238#2:371\n238#2:372\n238#2:375\n238#2:378\n238#2:380\n238#2:383\n238#2:386\n238#2:387\n238#2:399\n238#2:400\n238#2:401\n238#2:402\n30#3,2:358\n30#3,2:373\n30#3,2:381\n30#3,2:384\n4225#4,11:388\n*S KotlinDebug\n*F\n+ 1 DatabaseContextFun.kt\ncom/intellij/database/view/DatabaseContextFun\n*L\n89#1:361\n97#1:362\n98#1:363\n150#1:368\n155#1:369\n227#1:376\n228#1:377\n256#1:379\n339#1:403\n46#1:354\n53#1:355\n61#1:356\n69#1:357\n83#1:360\n109#1:364\n126#1:365\n134#1:366\n141#1:367\n166#1:370\n170#1:371\n202#1:372\n224#1:375\n252#1:378\n269#1:380\n288#1:383\n298#1:386\n301#1:387\n307#1:399\n308#1:400\n328#1:401\n330#1:402\n75#1:358,2\n219#1:373,2\n270#1:381,2\n289#1:384,2\n303#1:388,11\n*E\n"})
public final class DatabaseContextFun {
    /*
     * WARNING - void declaration
     */
    public static final boolean fromDatabaseTree(@NotNull DataContext $this$fromDatabaseTree) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)$this$fromDatabaseTree, (String)"<this>");
        DataContext dataContext = $this$fromDatabaseTree;
        DataKey<Boolean> dataKey = DatabaseView.DATABASE_TREE_IS_ORIGIN;
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DATABASE_TREE_IS_ORIGIN");
        DataKey<Boolean> key$iv = dataKey;
        boolean $i$f$get = false;
        return $this$get$iv.getData(key$iv) != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BasicNode[] getSelectedNodesArray(@NotNull DataContext $this$getSelectedNodesArray) {
        void $this$get$iv;
        BasicNode[] selectedNodes;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedNodesArray, (String)"<this>");
        DataContext dataContext = $this$getSelectedNodesArray;
        DataKey<BasicNode[]> dataKey = DatabaseView.DATABASE_NODES;
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DATABASE_NODES");
        DataKey<BasicNode[]> key$iv = dataKey;
        boolean $i$f$get = false;
        BasicNode[] basicNodeArray = selectedNodes = (BasicNode[])$this$get$iv.getData(key$iv);
        if (selectedNodes == null) {
            basicNodeArray = DatabaseViewPanel.Companion.getEMPTY_NODES_ARRAY();
        }
        return basicNodeArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JBIterable<BasicNode> getSelectedNodes(@NotNull DataContext $this$getSelectedNodes) {
        JBIterable jBIterable;
        void $this$get$iv;
        BasicNode[] nodes;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedNodes, (String)"<this>");
        BasicNode[] basicNodeArray = $this$getSelectedNodes;
        DataKey<BasicNode[]> dataKey = DatabaseView.DATABASE_NODES;
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DATABASE_NODES");
        DataKey<BasicNode[]> key$iv = dataKey;
        boolean $i$f$get = false;
        basicNodeArray = nodes = (BasicNode[])$this$get$iv.getData(key$iv);
        if (!(basicNodeArray == null || basicNodeArray.length == 0)) {
            BasicNode[] basicNodeArray2 = nodes;
            JBIterable jBIterable2 = JBIterable.of((Object[])Arrays.copyOf(basicNodeArray2, basicNodeArray2.length));
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"of(...)");
        } else {
            JBIterable jBIterable3 = JBIterable.empty();
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"empty(...)");
        }
        return jBIterable;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final BasicNode getSelectedSingleNode(@NotNull DataContext $this$getSelectedSingleNode) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedSingleNode, (String)"<this>");
        DataContext dataContext = $this$getSelectedSingleNode;
        DataKey<BasicNode[]> dataKey = DatabaseView.DATABASE_NODES;
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DATABASE_NODES");
        DataKey<BasicNode[]> key$iv = dataKey;
        boolean $i$f$get = false;
        BasicNode[] nodes = (BasicNode[])$this$get$iv.getData(key$iv);
        return nodes != null && nodes.length == 1 ? nodes[0] : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JBIterable<BasicNode> getSelectedNodesExpandingGroups(@NotNull DataContext $this$getSelectedNodesExpandingGroups) {
        void $this$filterBy$iv;
        BasicNode[] $this$get$iv;
        BasicNode[] nodes;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedNodesExpandingGroups, (String)"<this>");
        Project project = DatabaseContextFun.getProject($this$getSelectedNodesExpandingGroups);
        if (project == null) {
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return jBIterable;
        }
        Project project2 = project;
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service22 = false;
        Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DvTreeStructureService ss = (DvTreeStructureService)object;
        DataContext $i$f$service22 = $this$getSelectedNodesExpandingGroups;
        DataKey<BasicNode[]> dataKey = DatabaseView.DATABASE_NODES;
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DATABASE_NODES");
        DataKey<BasicNode[]> key$iv = dataKey;
        boolean $i$f$get22 = false;
        $this$get$iv = nodes = (BasicNode[])$this$get$iv.getData(key$iv);
        if ($this$get$iv == null || $this$get$iv.length == 0) {
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return jBIterable;
        }
        BasicNode[] basicNodeArray = nodes;
        JBIterable $i$f$get22 = ((JBTreeTraverser)JBTreeTraverser.from(arg_0 -> DatabaseContextFun.getSelectedNodesExpandingGroups$lambda$1(arg_0 -> DatabaseContextFun.getSelectedNodesExpandingGroups$lambda$0(ss, arg_0), arg_0)).withRoots((Object[])Arrays.copyOf(basicNodeArray, basicNodeArray.length))).traverse(TreeTraversal.LEAVES_DFS);
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$get22, (String)"traverse(...)");
        boolean $i$f$filterBy = false;
        JBIterable jBIterable = $this$filterBy$iv.filter(BasicNode.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        JBIterable jBIterable2 = jBIterable.filter(arg_0 -> DatabaseContextFun.getSelectedNodesExpandingGroups$lambda$3(DatabaseContextFun::getSelectedNodesExpandingGroups$lambda$2, arg_0)).unique();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"unique(...)");
        JBIterable result2 = jBIterable2;
        return result2;
    }

    @NotNull
    public static final JBIterable<BasicNode> getSelectedNodesWithParentsForGroups(@NotNull DataContext $this$getSelectedNodesWithParentsForGroups) {
        JBIterable $this$filterMap2$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedNodesWithParentsForGroups, (String)"<this>");
        JBIterable<BasicNode> jBIterable = DatabaseContextFun.getSelectedNodes($this$getSelectedNodesWithParentsForGroups);
        Function1 f$iv = DatabaseContextFun::getSelectedNodesWithParentsForGroups$lambda$0;
        boolean $i$f$filterMap2 = false;
        JBIterable jBIterable2 = $this$filterMap2$iv.filterMap(new Function(f$iv){
            final /* synthetic */ Function1<X, Y> $f;
            {
                this.$f = $f;
            }

            public final Y fun(X x) {
                Intrinsics.checkNotNullParameter(x, (String)"x");
                return (Y)this.$f.invoke(x);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filterMap(...)");
        $this$filterMap2$iv = jBIterable2;
        f$iv = DatabaseContextFun::getSelectedNodesWithParentsForGroups$lambda$1;
        $i$f$filterMap2 = false;
        JBIterable jBIterable3 = $this$filterMap2$iv.filterMap(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"filterMap(...)");
        JBIterable jBIterable4 = jBIterable3.unique();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"unique(...)");
        return jBIterable4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JBIterable<BasicElement> getSelectedElements(@NotNull DataContext $this$getSelectedElements) {
        JBIterable jBIterable;
        void $this$get$iv;
        BasicElement[] elements;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedElements, (String)"<this>");
        BasicElement[] basicElementArray = $this$getSelectedElements;
        DataKey<BasicElement[]> dataKey = DatabaseView.DATABASE_ELEMENTS;
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DATABASE_ELEMENTS");
        DataKey<BasicElement[]> key$iv = dataKey;
        boolean $i$f$get = false;
        basicElementArray = elements = (BasicElement[])$this$get$iv.getData(key$iv);
        if (!(basicElementArray == null || basicElementArray.length == 0)) {
            BasicElement[] basicElementArray2 = elements;
            JBIterable jBIterable2 = JBIterable.of((Object[])Arrays.copyOf(basicElementArray2, basicElementArray2.length));
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"of(...)");
        } else {
            JBIterable jBIterable3 = JBIterable.empty();
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"empty(...)");
        }
        return jBIterable;
    }

    @Nullable
    public static final BasicElement getSelectedSingleElement(@NotNull DataContext $this$getSelectedSingleElement) {
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedSingleElement, (String)"<this>");
        BasicNode node = DatabaseContextFun.getSelectedSingleNode($this$getSelectedSingleElement);
        return node instanceof BasicElement ? (BasicElement)node : (node instanceof Family ? (((Family)node).size() == 1 ? ((Family)node).first() : null) : (node instanceof DataSourceNode ? (BasicElement)((DataSourceNode)node).getModelRoot() : null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<DvTreeNodeRank> getSelectedTreeNodeRanks(@NotNull DataContext $this$getSelectedTreeNodeRanks) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedTreeNodeRanks, (String)"<this>");
        DataContext dataContext = $this$getSelectedTreeNodeRanks;
        DataKey<EnumSet<DvTreeNodeRank>> dataKey = DatabaseView.DATABASE_NODE_RANKS;
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DATABASE_NODE_RANKS");
        DataKey<EnumSet<DvTreeNodeRank>> key$iv = dataKey;
        boolean $i$f$get = false;
        EnumSet enumSet = (EnumSet)$this$get$iv.getData(key$iv);
        return enumSet != null ? (Set)enumSet : SetsKt.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final DataSourceNode getSelectionRelatedSingleDataSource(@NotNull DataContext $this$getSelectionRelatedSingleDataSource) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectionRelatedSingleDataSource, (String)"<this>");
        DataContext dataContext = $this$getSelectionRelatedSingleDataSource;
        DataKey<DataSourceNode> dataKey = DatabaseView.DATABASE_RELATED_SINGLE_DATA_SOURCE;
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DATABASE_RELATED_SINGLE_DATA_SOURCE");
        DataKey<DataSourceNode> key$iv = dataKey;
        boolean $i$f$get = false;
        return (DataSourceNode)$this$get$iv.getData(key$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<DataSourceNode> getSelectionRelatedDataSources(@NotNull DataContext $this$getSelectionRelatedDataSources) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectionRelatedDataSources, (String)"<this>");
        DataSourceNode[] dataSourceNodeArray = $this$getSelectionRelatedDataSources;
        DataKey<DataSourceNode[]> dataKey = DatabaseView.DATABASE_RELATED_DATA_SOURCES;
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DATABASE_RELATED_DATA_SOURCES");
        DataKey<DataSourceNode[]> key$iv = dataKey;
        boolean $i$f$get = false;
        DataSourceNode[] arrayOfDSNs = (DataSourceNode[])$this$get$iv.getData(key$iv);
        if (arrayOfDSNs == null) {
            return CollectionsKt.emptyList();
        }
        dataSourceNodeArray = arrayOfDSNs;
        return CollectionsKt.listOf((Object[])Arrays.copyOf(dataSourceNodeArray, dataSourceNodeArray.length));
    }

    @NotNull
    public static final JBIterable<RawDataSource> getSelectedDataSources(@NotNull DataContext $this$getSelectedDataSources) {
        JBIterable jBIterable;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedDataSources, (String)"<this>");
        if (DatabaseContextFun.fromDatabaseTree($this$getSelectedDataSources)) {
            JBIterable<BasicNode> $this$filterBy$iv = DatabaseContextFun.getSelectedNodes($this$getSelectedDataSources);
            boolean $i$f$filterBy = false;
            JBIterable jBIterable2 = $this$filterBy$iv.filter(DataSourceNode.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
            JBIterable jBIterable3 = jBIterable2.map(arg_0 -> DatabaseContextFun.getSelectedDataSources$lambda$0((Function1)getSelectedDataSources.1.INSTANCE, arg_0));
            Intrinsics.checkNotNull((Object)jBIterable3);
            jBIterable = jBIterable3;
        } else {
            JBIterable<DbElement> $this$filterBy$iv = DatabaseContextFun.getSelectedDbElements($this$getSelectedDataSources);
            boolean $i$f$filterBy = false;
            JBIterable jBIterable4 = $this$filterBy$iv.filter(DbDataSource.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"filter(...)");
            JBIterable jBIterable5 = jBIterable4.filterMap(arg_0 -> DatabaseContextFun.getSelectedDataSources$lambda$1(getSelectedDataSources.2.INSTANCE, arg_0));
            Intrinsics.checkNotNull((Object)jBIterable5);
            jBIterable = jBIterable5;
        }
        return jBIterable;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JBIterable<BasicElement> getActualElements(@NotNull DataContext $this$getActualElements) {
        void $this$get$iv;
        void $this$get$iv2;
        Intrinsics.checkNotNullParameter((Object)$this$getActualElements, (String)"<this>");
        if (DatabaseContextFun.fromDatabaseTree((DataContext)$this$getActualElements)) {
            return DatabaseContextFun.getSelectedElements((DataContext)$this$getActualElements);
        }
        DbElement[] dbElementArray = $this$getActualElements;
        Intrinsics.checkNotNullExpressionValue(DatabaseView.DB_ELEMENTS, (String)"DB_ELEMENTS");
        DbElement[] key$iv = DatabaseView.DB_ELEMENTS;
        boolean $i$f$get = false;
        DbElement[] dbElements = (DbElement[])$this$get$iv2.getData(key$iv);
        if (dbElements != null && !(dbElements.length == 0)) {
            key$iv = dbElements;
            JBIterable jBIterable = JBIterable.of((Object[])Arrays.copyOf(key$iv, key$iv.length));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
            return DatabaseContextFun.toBasicElements((JBIterable<DbElement>)jBIterable);
        }
        key$iv = $this$getActualElements;
        DataKey dataKey = CommonDataKeys.PSI_ELEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PSI_ELEMENT");
        DataKey key$iv2 = dataKey;
        boolean $i$f$get2 = false;
        PsiElement psiElement = (PsiElement)$this$get$iv.getData(key$iv2);
        if (psiElement != null) {
            JBIterable<BasicElement> jBIterable;
            if (psiElement instanceof DbElement) {
                JBIterable jBIterable2 = JBIterable.of((Object)psiElement);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"of(...)");
                jBIterable = DatabaseContextFun.toBasicElements((JBIterable<DbElement>)jBIterable2);
            } else {
                JBIterable jBIterable3 = SqlPsiFacade.getInstance((Project)psiElement.getProject()).findRelatedDbElements(psiElement, true);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"findRelatedDbElements(...)");
                jBIterable = DatabaseContextFun.toBasicElements((JBIterable<DbElement>)jBIterable3);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.empty();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
        return jBIterable;
    }

    private static final JBIterable<BasicElement> toBasicElements(JBIterable<DbElement> $this$toBasicElements) {
        JBIterable jBIterable = $this$toBasicElements.filterMap(arg_0 -> DatabaseContextFun.toBasicElements$lambda$0(toBasicElements.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
        return jBIterable;
    }

    private static final BasicElement toBasicElement(DbElement $this$toBasicElement) {
        BasicElement basicElement;
        if ($this$toBasicElement instanceof DbDataSource) {
            RawDataSource rawDataSource = ((DbDataSource)$this$toBasicElement).getDelegateDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)rawDataSource, (String)"getDelegateDataSource(...)");
            basicElement = (BasicElement)DataSourceFun.getRealModelRoot((RawDataSource)rawDataSource);
        } else {
            Object object = $this$toBasicElement.getDelegate();
            basicElement = object instanceof BasicElement ? (BasicElement)object : null;
        }
        return basicElement;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Project getProject(@NotNull DataContext $this$project) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"<this>");
        DataContext dataContext = $this$project;
        DataKey dataKey = CommonDataKeys.PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PROJECT");
        DataKey key$iv = dataKey;
        boolean $i$f$get = false;
        return (Project)$this$get$iv.getData(key$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JBIterable<DbElement> getSelectedDbElements(@NotNull DataContext $this$getSelectedDbElements) {
        JBIterable jBIterable;
        void $this$get$iv;
        PsiElement[] psiArray;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedDbElements, (String)"<this>");
        if (DatabaseContextFun.fromDatabaseTree($this$getSelectedDbElements)) {
            Project project = DatabaseContextFun.getProject($this$getSelectedDbElements);
            if (project == null) {
                JBIterable jBIterable2 = JBIterable.empty();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"empty(...)");
                return jBIterable2;
            }
            Project project2 = project;
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<DbModelRegistry> serviceClass$iv = DbModelRegistry.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            DbModelRegistry modelRegistry = (DbModelRegistry)object;
            JBIterable<BasicNode> selectedNodes = DatabaseContextFun.getSelectedNodes($this$getSelectedDbElements);
            JBIterable jBIterable3 = selectedNodes.filterMap(arg_0 -> DatabaseContextFun.getSelectedDbElements$lambda$1(arg_0 -> DatabaseContextFun.getSelectedDbElements$lambda$0(modelRegistry, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"filterMap(...)");
            return jBIterable3;
        }
        DataContext modelRegistry = $this$getSelectedDbElements;
        Intrinsics.checkNotNullExpressionValue((Object)LangDataKeys.PSI_ELEMENT_ARRAY, (String)"PSI_ELEMENT_ARRAY");
        PsiElement[] key$iv = LangDataKeys.PSI_ELEMENT_ARRAY;
        boolean $i$f$get2 = false;
        key$iv = psiArray = (PsiElement[])$this$get$iv.getData((DataKey)key$iv);
        if (!(key$iv == null || key$iv.length == 0)) {
            PsiElement[] $i$f$get2 = psiArray;
            JBIterable jBIterable4 = JBIterable.of((Object[])Arrays.copyOf($i$f$get2, $i$f$get2.length));
            jBIterable = jBIterable4;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"of(...)");
        } else {
            JBIterable jBIterable5 = JBIterable.empty();
            jBIterable = jBIterable5;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable5, (String)"empty(...)");
        }
        JBIterable psiElements = jBIterable;
        JBIterable jBIterable6 = psiElements.filterMap(arg_0 -> DatabaseContextFun.getSelectedDbElements$lambda$3(DatabaseContextFun::getSelectedDbElements$lambda$2, arg_0)).flatMap((Function)Functions.id());
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable6, (String)"flatMap(...)");
        JBIterable $this$filterBy$iv = jBIterable6;
        boolean $i$f$filterBy = false;
        JBIterable jBIterable7 = $this$filterBy$iv.filter(PsiElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable7, (String)"filter(...)");
        JBIterable jBIterable8 = psiElements.append((Iterable)jBIterable7);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable8, (String)"append(...)");
        JBIterable $this$filterBy$iv2 = jBIterable8;
        boolean $i$f$filterBy2 = false;
        JBIterable jBIterable9 = $this$filterBy$iv2.filter(DbElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable9, (String)"filter(...)");
        return jBIterable9;
    }

    @NotNull
    public static final <T extends DbElement> JBIterable<T> getSelectedDbElements(@NotNull DataContext $this$getSelectedDbElements, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedDbElements, (String)"<this>");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        JBIterable jBIterable = DatabaseContextFun.getSelectedDbElements($this$getSelectedDbElements).filter(clazz);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JBIterable<PsiElement> getSelectedPsiElements(@NotNull DataContext dataContext) {
        void $this$filterBy$iv;
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        DataContext dataContext2 = dataContext;
        DataKey dataKey = LangDataKeys.PSI_ELEMENT_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PSI_ELEMENT_ARRAY");
        DataKey key$iv = dataKey;
        boolean $i$f$get = false;
        PsiElement[] psiElementArray = (PsiElement[])$this$get$iv.getData(key$iv);
        if (psiElementArray == null) {
            psiElementArray = new PsiElement[]{};
        }
        PsiElement[] psiElements = psiElementArray;
        JBIterable jBIterable = JBIterable.of((Object[])Arrays.copyOf(psiElements, psiElements.length));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
        JBIterable elements = jBIterable;
        key$iv = elements.filterMap(arg_0 -> DatabaseContextFun.getSelectedPsiElements$lambda$1(DatabaseContextFun::getSelectedPsiElements$lambda$0, arg_0)).flatMap((Function)Functions.id());
        Intrinsics.checkNotNullExpressionValue((Object)key$iv, (String)"flatMap(...)");
        boolean $i$f$filterBy = false;
        JBIterable jBIterable2 = $this$filterBy$iv.filter(PsiElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        JBIterable jBIterable3 = elements.append((Iterable)jBIterable2);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"append(...)");
        return jBIterable3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JBIterable<DbElement> getSelectedDbElementsExpandingGroups(@NotNull DataContext $this$getSelectedDbElementsExpandingGroups) {
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedDbElementsExpandingGroups, (String)"<this>");
        if (DatabaseContextFun.fromDatabaseTree($this$getSelectedDbElementsExpandingGroups)) {
            void $this$get$iv;
            DataContext dataContext = $this$getSelectedDbElementsExpandingGroups;
            DataKey dataKey = CommonDataKeys.PROJECT;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PROJECT");
            DataKey key$iv = dataKey;
            boolean $i$f$get = false;
            Project project = (Project)$this$get$iv.getData(key$iv);
            if (project == null) {
                JBIterable jBIterable = JBIterable.empty();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
                return jBIterable;
            }
            Project project2 = project;
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<DbModelRegistry> serviceClass$iv = DbModelRegistry.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            DbModelRegistry modelRegistry = (DbModelRegistry)object;
            JBIterable jBIterable = DatabaseContextFun.getSelectedNodesExpandingGroups($this$getSelectedDbElementsExpandingGroups).filterMap(arg_0 -> DatabaseContextFun.getSelectedDbElementsExpandingGroups$lambda$1(arg_0 -> DatabaseContextFun.getSelectedDbElementsExpandingGroups$lambda$0(modelRegistry, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
            return jBIterable;
        }
        return DatabaseContextFun.getSelectedDbElementsIfNoSelectionInTheTree($this$getSelectedDbElementsExpandingGroups);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JBIterable<DbElement> getSelectedDbElementsWithParentsForGroups(@NotNull DataContext $this$getSelectedDbElementsWithParentsForGroups) {
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedDbElementsWithParentsForGroups, (String)"<this>");
        if (DatabaseContextFun.fromDatabaseTree($this$getSelectedDbElementsWithParentsForGroups)) {
            void $this$get$iv;
            DataContext dataContext = $this$getSelectedDbElementsWithParentsForGroups;
            DataKey dataKey = CommonDataKeys.PROJECT;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PROJECT");
            DataKey key$iv = dataKey;
            boolean $i$f$get = false;
            Project project = (Project)$this$get$iv.getData(key$iv);
            if (project == null) {
                JBIterable jBIterable = JBIterable.empty();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
                return jBIterable;
            }
            Project project2 = project;
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<DbModelRegistry> serviceClass$iv = DbModelRegistry.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            DbModelRegistry modelRegistry = (DbModelRegistry)object;
            JBIterable jBIterable = DatabaseContextFun.getSelectedNodesWithParentsForGroups($this$getSelectedDbElementsWithParentsForGroups).filterMap(arg_0 -> DatabaseContextFun.getSelectedDbElementsWithParentsForGroups$lambda$1(arg_0 -> DatabaseContextFun.getSelectedDbElementsWithParentsForGroups$lambda$0(modelRegistry, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
            return jBIterable;
        }
        return DatabaseContextFun.getSelectedDbElementsIfNoSelectionInTheTree($this$getSelectedDbElementsWithParentsForGroups);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<DbElement> getSelectedDbElementsIfNoSelectionInTheTreeAsList(@NotNull DataContext $this$getSelectedDbElementsIfNoSelectionInTheTreeAsList) {
        DbElement element;
        void $this$get$iv;
        void $this$get$iv2;
        DataContext $this$filterIsInstance$iv;
        void $this$get$iv3;
        Object[] elements;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedDbElementsIfNoSelectionInTheTreeAsList, (String)"<this>");
        DataContext dataContext = $this$getSelectedDbElementsIfNoSelectionInTheTreeAsList;
        DataContext dataContext2 = DatabaseView.DB_ELEMENTS;
        Intrinsics.checkNotNullExpressionValue(dataContext2, (String)"DB_ELEMENTS");
        DataContext key$iv = dataContext2;
        boolean $i$f$get = false;
        if (elements != null) {
            void $this$get$iv4;
            elements = (DbElement[])$this$get$iv4.getData(key$iv);
            return ArraysKt.asList((Object[])elements);
        }
        key$iv = $this$getSelectedDbElementsIfNoSelectionInTheTreeAsList;
        DataKey dataKey = LangDataKeys.PSI_ELEMENT_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PSI_ELEMENT_ARRAY");
        DataKey key$iv2 = dataKey;
        boolean $i$f$get2 = false;
        DataContext psiElements = (DataContext)$this$get$iv3.getData(key$iv2);
        if (psiElements != null) {
            void $this$filterIsInstanceTo$iv$iv;
            $this$filterIsInstance$iv = psiElements;
            boolean $i$f$filterIsInstance = false;
            DataContext dataContext3 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof DbElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List dbElements = (List)destination$iv$iv;
            if (!((Collection)dbElements).isEmpty()) {
                return dbElements;
            }
        }
        $this$filterIsInstance$iv = $this$getSelectedDbElementsIfNoSelectionInTheTreeAsList;
        DataKey dataKey2 = CommonDataKeys.PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"PROJECT");
        DataKey key$iv3 = dataKey2;
        boolean $i$f$get3 = false;
        Project project = (Project)$this$get$iv2.getData(key$iv3);
        key$iv3 = $this$getSelectedDbElementsIfNoSelectionInTheTreeAsList;
        DataKey dataKey3 = PlatformCoreDataKeys.FILE_EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"FILE_EDITOR");
        DataKey key$iv4 = dataKey3;
        boolean $i$f$get4 = false;
        FileEditor fileEditor = (FileEditor)$this$get$iv.getData(key$iv4);
        DbElement dbElement = element = project == null || fileEditor == null ? null : DatabaseContextFun.getSelectedDbElementFromEditor($this$getSelectedDbElementsIfNoSelectionInTheTreeAsList);
        return dbElement != null ? CollectionsKt.listOf((Object)dbElement) : CollectionsKt.emptyList();
    }

    private static final JBIterable<DbElement> getSelectedDbElementsIfNoSelectionInTheTree(DataContext $this$getSelectedDbElementsIfNoSelectionInTheTree) {
        return UtilKt.asJBIterable((Iterable)DatabaseContextFun.getSelectedDbElementsIfNoSelectionInTheTreeAsList($this$getSelectedDbElementsIfNoSelectionInTheTree));
    }

    @Nullable
    public static final DbElement getSelectedDbElementFromEditor(@NotNull DataContext $this$getSelectedDbElementFromEditor) {
        SelectInContext context;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedDbElementFromEditor, (String)"<this>");
        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)$this$getSelectedDbElementFromEditor);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
        AnActionEvent event = anActionEvent;
        SelectInContext selectInContext = context = SelectInContextImpl.createContext((AnActionEvent)event);
        return selectInContext == null ? null : SelectInDatabaseView.askProviders(selectInContext);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final BasicElement getEditorObject(@NotNull DataContext $this$getEditorObject) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getEditorObject, (String)"<this>");
        DataContext dataContext = $this$getEditorObject;
        DataKey dataKey = DatabaseDataKeysCore.DATABASE_EDITOR_OBJECT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"DATABASE_EDITOR_OBJECT");
        DataKey key$iv = dataKey;
        boolean $i$f$get = false;
        BasicElement element = (BasicElement)$this$get$iv.getData(key$iv);
        if (element == null) {
            void $this$get$iv2;
            key$iv = $this$getEditorObject;
            DataKey dataKey2 = DatabaseDataKeysCore.DB_EDITOR_OBJECT;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"DB_EDITOR_OBJECT");
            DataKey key$iv2 = dataKey2;
            boolean $i$f$get2 = false;
            DbElement o = (DbElement)$this$get$iv2.getData(key$iv2);
            if (o != null) {
                element = DasObjectFun.getBasicElement((DbElement)o);
            }
        }
        return element;
    }

    @ApiStatus.Internal
    @NotNull
    public static final JBIterable<DbDataSource> findDbDataSources(@NotNull Project project, @NotNull JBIterable<RawDataSource> dataSources) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(dataSources, (String)"dataSources");
        JBIterable jBIterable = dataSources.filterMap(arg_0 -> DatabaseContextFun.findDbDataSources$lambda$1(arg_0 -> DatabaseContextFun.findDbDataSources$lambda$0(project, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
        return jBIterable;
    }

    @ApiStatus.Internal
    private static final DbDataSource findDbDataSource(Project project, RawDataSource dataSource) {
        boolean $i$f$findDbDataSource = false;
        return DbImplUtil.getDbDataSource((Project)project, (DasDataSource)((DasDataSource)dataSource));
    }

    public static final /* synthetic */ <Y> JBIterable<Y> filterBy(JBIterable<? extends Object> $this$filterBy) {
        Intrinsics.checkNotNullParameter($this$filterBy, (String)"<this>");
        boolean $i$f$filterBy = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"Y");
        JBIterable jBIterable = $this$filterBy.filter(Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    private static final <X, Y> JBIterable<Y> filterMap2(JBIterable<X> $this$filterMap2, Function1<? super X, ? extends Y> f) {
        boolean $i$f$filterMap2 = false;
        JBIterable jBIterable = $this$filterMap2.filterMap(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
        return jBIterable;
    }

    private static final Iterable<Object> getSelectedNodesExpandingGroups$iterateGroupChildren(DvTreeStructureService ss, Object node) {
        Iterable iterable;
        if (node instanceof FamilyWithId) {
            iterable = SequencesKt.asIterable((Sequence)ss.childrenOf((BasicNode)node));
        } else {
            List list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
            iterable = list;
        }
        return iterable;
    }

    private static final Iterable getSelectedNodesExpandingGroups$lambda$0(DvTreeStructureService $ss, Object node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return DatabaseContextFun.getSelectedNodesExpandingGroups$iterateGroupChildren($ss, node);
    }

    private static final Iterable getSelectedNodesExpandingGroups$lambda$1(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean getSelectedNodesExpandingGroups$lambda$2(BasicNode x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return x instanceof BasicObjectNode || x instanceof DataSourceNode;
    }

    private static final boolean getSelectedNodesExpandingGroups$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final BasicNode getSelectedNodesWithParentsForGroups$lambda$0(BasicNode node) {
        BasicNode basicNode;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof DataSourceNode) {
            BasicRoot basicRoot = ((DataSourceNode)node).getModelRoot();
            basicNode = basicRoot != null ? (BasicNode)basicRoot : node;
        } else {
            basicNode = node;
        }
        return basicNode;
    }

    private static final BasicNode getSelectedNodesWithParentsForGroups$lambda$1(BasicNode node) {
        BasicNode basicNode;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof HostFamily) {
            BasicElement basicElement = ((HostFamily)node).getHost();
            Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getHost(...)");
            basicNode = (BasicNode)basicElement;
        } else {
            basicNode = node instanceof DvHostNode ? (BasicNode)((DvHostNode)node).host : node;
        }
        return basicNode;
    }

    private static final RawDataSource getSelectedDataSources$lambda$0(Function1 $tmp0, Object p0) {
        return (RawDataSource)$tmp0.invoke(p0);
    }

    private static final RawDataSource getSelectedDataSources$lambda$1(Function1 $tmp0, Object p0) {
        return (RawDataSource)$tmp0.invoke(p0);
    }

    private static final BasicElement toBasicElements$lambda$0(Function1 $tmp0, Object p0) {
        return (BasicElement)$tmp0.invoke(p0);
    }

    private static final DbElement getSelectedDbElements$lambda$0(DbModelRegistry $modelRegistry, BasicNode node) {
        Intrinsics.checkNotNull((Object)node);
        return DatabaseViewTreeFun.getDbWrapperFor(node, $modelRegistry);
    }

    private static final DbElement getSelectedDbElements$lambda$1(Function1 $tmp0, Object p0) {
        return (DbElement)$tmp0.invoke(p0);
    }

    private static final JBIterable getSelectedDbElements$lambda$2(PsiElement it) {
        return DbNavigationUtils.unwrapElements(it);
    }

    private static final JBIterable getSelectedDbElements$lambda$3(Function1 $tmp0, Object p0) {
        return (JBIterable)$tmp0.invoke(p0);
    }

    private static final JBIterable getSelectedPsiElements$lambda$0(PsiElement it) {
        return DbNavigationUtils.unwrapElements(it);
    }

    private static final JBIterable getSelectedPsiElements$lambda$1(Function1 $tmp0, Object p0) {
        return (JBIterable)$tmp0.invoke(p0);
    }

    private static final DbElement getSelectedDbElementsExpandingGroups$lambda$0(DbModelRegistry $modelRegistry, BasicNode node) {
        Intrinsics.checkNotNull((Object)node);
        return DatabaseViewTreeFun.getDbWrapperFor(node, $modelRegistry);
    }

    private static final DbElement getSelectedDbElementsExpandingGroups$lambda$1(Function1 $tmp0, Object p0) {
        return (DbElement)$tmp0.invoke(p0);
    }

    private static final DbElement getSelectedDbElementsWithParentsForGroups$lambda$0(DbModelRegistry $modelRegistry, BasicNode node) {
        Intrinsics.checkNotNull((Object)node);
        return DatabaseViewTreeFun.getDbWrapperFor(node, $modelRegistry);
    }

    private static final DbElement getSelectedDbElementsWithParentsForGroups$lambda$1(Function1 $tmp0, Object p0) {
        return (DbElement)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final DbDataSource findDbDataSources$lambda$0(Project $project, RawDataSource it) {
        void project$iv;
        Project project = $project;
        Intrinsics.checkNotNull((Object)it);
        RawDataSource dataSource$iv = it;
        boolean $i$f$findDbDataSource = false;
        return DbImplUtil.getDbDataSource((Project)project$iv, (DasDataSource)((DasDataSource)dataSource$iv));
    }

    private static final DbDataSource findDbDataSources$lambda$1(Function1 $tmp0, Object p0) {
        return (DbDataSource)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ BasicElement access$toBasicElement(DbElement $receiver) {
        return DatabaseContextFun.toBasicElement($receiver);
    }
}

