/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.view.structure.DvCreateFolderCommand;
import com.intellij.database.view.structure.UiDslUtil;
import com.intellij.database.view.structure.forest.DvFolder;
import com.intellij.database.view.structure.forest.DvForestService;
import com.intellij.database.view.structure.forest.DvNiceFolder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0014J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/view/structure/DvForestCreateNewFolderDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "mainPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "pathField", "Ljavax/swing/JLabel;", "nameField", "Lcom/intellij/ui/components/JBTextField;", "parentFolder", "Lcom/intellij/database/view/structure/forest/DvFolder;", "createCenterPanel", "Ljavax/swing/JComponent;", "setup", "", "validateName", "applyFields", "createTheNewFolder", "dispose", "Companion", "intellij.database.impl"})
public final class DvForestCreateNewFolderDialog
extends DialogWrapper
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private DialogPanel mainPanel;
    private JLabel pathField;
    private JBTextField nameField;
    private DvFolder parentFolder;

    public DvForestCreateNewFolderDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, false, DialogWrapper.IdeModalityType.MODELESS);
        this.project = project;
        this.setTitle(DatabaseBundle.message((String)"forest.dialog.createNewFolder.title", (Object[])new Object[0]));
        this.setOKButtonText(DatabaseBundle.message((String)"forest.dialog.createNewFolder.createButtonText", (Object[])new Object[0]));
        this.setOKActionEnabled(false);
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        this.mainPanel = BuilderKt.panel(arg_0 -> DvForestCreateNewFolderDialog.createCenterPanel$lambda$0(this, arg_0));
        DialogPanel dialogPanel = this.mainPanel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainPanel");
            dialogPanel = null;
        }
        return (JComponent)dialogPanel;
    }

    private final void setup(DvFolder parentFolder) {
        JBTextField jBTextField;
        this.parentFolder = parentFolder;
        boolean hasParent = parentFolder instanceof DvNiceFolder;
        JLabel jLabel = this.pathField;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pathField");
            jLabel = null;
        }
        jLabel.setVisible(hasParent);
        if (hasParent) {
            JLabel jLabel2 = this.pathField;
            if (jLabel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pathField");
                jLabel2 = null;
            }
            jLabel2.setText(StringsKt.replace$default((String)((DvNiceFolder)parentFolder).getPath(), (String)"/", (String)" / ", (boolean)false, (int)4, null) + " / ");
        }
        if ((jBTextField = this.nameField) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nameField");
            jBTextField = null;
        }
        jBTextField.setText(DatabaseBundle.message((String)"forest.dialog.createNewFolder.defaultNewFolderName", (Object[])new Object[0]));
        this.validateName();
    }

    private final void validateName() {
        JBTextField jBTextField = this.nameField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nameField");
            jBTextField = null;
        }
        String name = jBTextField.getText();
        Intrinsics.checkNotNull((Object)name);
        boolean ok2 = !StringsKt.isBlank((CharSequence)name) && name.length() <= 60 && !StringsKt.contains$default((CharSequence)name, (char)'/', (boolean)false, (int)2, null);
        this.setOKActionEnabled(ok2);
    }

    protected void applyFields() {
        super.applyFields();
        this.createTheNewFolder();
    }

    private final void createTheNewFolder() {
        JBTextField jBTextField = this.nameField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nameField");
            jBTextField = null;
        }
        String string = jBTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String name = ((Object)StringsKt.trim((CharSequence)string)).toString();
        DvFolder dvFolder = this.parentFolder;
        if (dvFolder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parentFolder");
            dvFolder = null;
        }
        new DvCreateFolderCommand(this.project, dvFolder, name).doIt();
    }

    public void dispose() {
        super.dispose();
    }

    private static final Unit createCenterPanel$lambda$0(DvForestCreateNewFolderDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DvForestCreateNewFolderDialog.createCenterPanel$lambda$0$0(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0(DvForestCreateNewFolderDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon = AllIcons.Nodes.Folder;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Folder");
        $this$row.icon(icon).gap(RightGap.SMALL);
        UiDslUtil.useComponent($this$row.label(""), arg_0 -> DvForestCreateNewFolderDialog.createCenterPanel$lambda$0$0$0(this$0, arg_0)).gap(RightGap.SMALL);
        UiDslUtil.useComponent($this$row.textField().focused().onChanged(arg_0 -> DvForestCreateNewFolderDialog.createCenterPanel$lambda$0$0$1(this$0, arg_0)), arg_0 -> DvForestCreateNewFolderDialog.createCenterPanel$lambda$0$0$2(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0$0(DvForestCreateNewFolderDialog this$0, JLabel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.pathField = it;
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0$1(DvForestCreateNewFolderDialog this$0, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.validateName();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0$2(DvForestCreateNewFolderDialog this$0, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.nameField = it;
        return Unit.INSTANCE;
    }

    @JvmStatic
    public static final void doIt(@NotNull Project project, @Nullable DvFolder parentFolder) {
        Companion.doIt(project, parentFolder);
    }

    @JvmStatic
    private static final DvFolder getTheRootFolder(Project project) {
        return DvForestCreateNewFolderDialog.Companion.getTheRootFolder(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0003\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/view/structure/DvForestCreateNewFolderDialog$Companion;", "", "<init>", "()V", "doIt", "", "project", "Lcom/intellij/openapi/project/Project;", "parentFolder", "Lcom/intellij/database/view/structure/forest/DvFolder;", "getTheRootFolder", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDvForestCreateNewFolderDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvForestCreateNewFolderDialog.kt\ncom/intellij/database/view/structure/DvForestCreateNewFolderDialog$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,111:1\n30#2,2:112\n*S KotlinDebug\n*F\n+ 1 DvForestCreateNewFolderDialog.kt\ncom/intellij/database/view/structure/DvForestCreateNewFolderDialog$Companion\n*L\n46#1:112,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void doIt(@NotNull Project project, @Nullable DvFolder parentFolder) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            DvFolder dvFolder = parentFolder;
            if (dvFolder == null) {
                dvFolder = this.getTheRootFolder(project);
            }
            DvFolder theParentFolder = dvFolder;
            DvForestCreateNewFolderDialog dia = new DvForestCreateNewFolderDialog(project);
            dia.setup(theParentFolder);
            dia.show();
        }

        @JvmStatic
        private final DvFolder getTheRootFolder(Project project) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DvForestService> serviceClass$iv = DvForestService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DvFolder)((DvForestService)object).getForest().getRoot();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

