/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.gradle;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.run.QsRunConfigurationService;
import com.intellij.quarkus.settings.QuarkusSettings;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.util.Collection;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0007H\u0016J:\u0010\b\u001a\u00020\t2\u0016\u0010\n\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/quarkus/gradle/QsGradleProjectDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "Ljava/lang/Void;", "<init>", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "onSuccessImport", "", "imported", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModelsProvider;", "intellij.quarkus.gradle"})
public final class QsGradleProjectDataService
extends AbstractProjectDataService<ModuleData, Void> {
    @NotNull
    public Key<ModuleData> getTargetDataKey() {
        Key key = ProjectKeys.MODULE;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"MODULE");
        return key;
    }

    public void onSuccessImport(@NotNull Collection<? extends DataNode<ModuleData>> imported, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter(imported, (String)"imported");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        if (projectData == null) {
            return;
        }
        QuarkusSettings settings = QuarkusSettings.Companion.getInstance(project);
        if (!settings.getAutoCreateRunConfiguration()) {
            return;
        }
        ReadAction.nonBlocking(() -> QsGradleProjectDataService.onSuccessImport$lambda$0(project, modelsProvider, projectData)).inSmartMode(project).expireWith((Disposable)settings).submit((Executor)NonUrgentExecutor.getInstance());
    }

    private static final void onSuccessImport$lambda$0(Project $project, IdeModelsProvider $modelsProvider, ProjectData $projectData) {
        if (!QuarkusUtils.INSTANCE.hasQuarkusLibrary($project)) {
            return;
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> QsGradleProjectDataService.onSuccessImport$lambda$0$0($modelsProvider, $projectData));
    }

    private static final void onSuccessImport$lambda$0$0(IdeModelsProvider $modelsProvider, ProjectData $projectData) {
        Module[] moduleArray = $modelsProvider.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"getModules(...)");
        for (Module module : moduleArray) {
            String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
            if (rootProjectPath == null || !Intrinsics.areEqual((Object)rootProjectPath, (Object)$projectData.getLinkedExternalProjectPath()) || !QuarkusUtils.INSTANCE.hasQuarkusLibrary(module)) continue;
            String string = module.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.endsWith$default((String)string, (String)"native-test", (boolean)false, (int)2, null)) continue;
            VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getSourceRoots(false);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSourceRoots(...)");
            if (((Object[])virtualFileArray).length == 0) continue;
            QsRunConfigurationService qsRunConfigurationService = QsRunConfigurationService.Companion.getInstance();
            Intrinsics.checkNotNull((Object)module);
            qsRunConfigurationService.createRunConfiguration(module);
        }
    }
}

