/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.run.application;

import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.PtyOptions;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.microservices.jvm.debugger.scheduled.ScheduledDebuggerConfiguration;
import com.intellij.microservices.jvm.debugger.scheduled.ScheduledDebuggerConfigurationKt;
import com.intellij.microservices.jvm.debugger.scheduled.ScheduledDebuggerRunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.quarkus.run.application.QsApplicationRunConfiguration;
import com.intellij.quarkus.run.application.QsKillableProcessHandler;
import com.intellij.terminal.TerminalExecutionConsole;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/quarkus/run/application/QsApplicationRunConfigurationState;", "Lcom/intellij/execution/application/ApplicationConfiguration$JavaApplicationCommandLineState;", "Lcom/intellij/quarkus/run/application/QsApplicationRunConfiguration;", "configuration", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "<init>", "(Lcom/intellij/quarkus/run/application/QsApplicationRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "createConsole", "Lcom/intellij/execution/ui/ConsoleView;", "executor", "Lcom/intellij/execution/Executor;", "scheduledDebuggerConfiguration", "Lcom/intellij/microservices/jvm/debugger/scheduled/ScheduledDebuggerConfiguration;", "createProcessHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "remoteEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "targetedCommandLineBuilder", "Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "targetedCommandLine", "Lcom/intellij/execution/target/TargetedCommandLine;", "process", "Ljava/lang/Process;", "createTargetedCommandLine", "request", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "emulateTerminal", "", "prepareTargetEnvironmentRequest", "", "targetProgressIndicator", "Lcom/intellij/execution/target/TargetProgressIndicator;", "handleCreatedTargetEnvironment", "intellij.quarkus"})
public final class QsApplicationRunConfigurationState
extends ApplicationConfiguration.JavaApplicationCommandLineState<QsApplicationRunConfiguration> {
    @Nullable
    private ScheduledDebuggerConfiguration scheduledDebuggerConfiguration;

    public QsApplicationRunConfigurationState(@NotNull QsApplicationRunConfiguration configuration, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super((ApplicationConfiguration)configuration, environment);
    }

    @Nullable
    protected ConsoleView createConsole(@NotNull Executor executor) {
        ConsoleView consoleView;
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        if (this.emulateTerminal()) {
            TerminalExecutionConsole console = new TerminalExecutionConsole(((QsApplicationRunConfiguration)this.getConfiguration()).getProject(), null);
            JavaRunConfigurationExtensionManager javaRunConfigurationExtensionManager = JavaRunConfigurationExtensionManager.Companion.getInstance();
            RunConfigurationBase runConfigurationBase = this.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfigurationBase, (String)"getConfiguration(...)");
            consoleView = javaRunConfigurationExtensionManager.decorateExecutionConsole(runConfigurationBase, this.getRunnerSettings(), (ConsoleView)console, executor);
        } else {
            consoleView = super.createConsole(executor);
        }
        return consoleView;
    }

    @NotNull
    protected OSProcessHandler createProcessHandler(@NotNull TargetEnvironment remoteEnvironment, @NotNull TargetedCommandLineBuilder targetedCommandLineBuilder, @NotNull TargetedCommandLine targetedCommandLine, @NotNull Process process) {
        OSProcessHandler oSProcessHandler;
        block0: {
            Intrinsics.checkNotNullParameter((Object)remoteEnvironment, (String)"remoteEnvironment");
            Intrinsics.checkNotNullParameter((Object)targetedCommandLineBuilder, (String)"targetedCommandLineBuilder");
            Intrinsics.checkNotNullParameter((Object)targetedCommandLine, (String)"targetedCommandLine");
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            oSProcessHandler = this.emulateTerminal() ? (OSProcessHandler)new QsKillableProcessHandler(process, targetedCommandLine.getCommandPresentation(remoteEnvironment), targetedCommandLine.getCharset(), targetedCommandLineBuilder.getFilesToDeleteOnTermination()) : super.createProcessHandler(remoteEnvironment, targetedCommandLineBuilder, targetedCommandLine, process);
            Intrinsics.checkNotNull((Object)oSProcessHandler);
            OSProcessHandler it = oSProcessHandler;
            boolean bl = false;
            ScheduledDebuggerConfiguration scheduledDebuggerConfiguration = this.scheduledDebuggerConfiguration;
            if (scheduledDebuggerConfiguration == null) break block0;
            scheduledDebuggerConfiguration.setupProcessHandler((ProcessHandler)it);
        }
        return oSProcessHandler;
    }

    @NotNull
    protected TargetedCommandLineBuilder createTargetedCommandLine(@NotNull TargetEnvironmentRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        TargetedCommandLineBuilder targetedCommandLineBuilder = super.createTargetedCommandLine(request);
        Intrinsics.checkNotNullExpressionValue((Object)targetedCommandLineBuilder, (String)"createTargetedCommandLine(...)");
        TargetedCommandLineBuilder targetedCommandLine = targetedCommandLineBuilder;
        if (this.emulateTerminal()) {
            targetedCommandLine.setPtyOptions(new PtyOptions(){

                public int getInitialColumns() {
                    return LocalPtyOptions.Companion.defaults().getInitialColumns();
                }

                public int getInitialRows() {
                    return LocalPtyOptions.Companion.defaults().getInitialRows();
                }
            });
        }
        return targetedCommandLine;
    }

    private final boolean emulateTerminal() {
        return ((QsApplicationRunConfiguration)this.getConfiguration()).emulateTerminal$intellij_quarkus() && this.getTargetEnvironmentRequest() instanceof LocalTargetEnvironmentRequest && !SystemInfo.isWindows;
    }

    public void prepareTargetEnvironmentRequest(@NotNull TargetEnvironmentRequest request, @NotNull TargetProgressIndicator targetProgressIndicator) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
        if (((QsApplicationRunConfiguration)this.getConfiguration()).isEnableScheduledDebugger()) {
            String string;
            Project project = ((QsApplicationRunConfiguration)this.getConfiguration()).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            this.scheduledDebuggerConfiguration = ScheduledDebuggerConfigurationKt.configureScheduledDebuggerByTargetName((Project)project, (TargetEnvironmentRequest)request);
            this.getJavaParameters().setUseDynamicVMOptions(true);
            ParametersList parametersList = this.getJavaParameters().getVMParametersList();
            ScheduledDebuggerConfiguration scheduledDebuggerConfiguration = this.scheduledDebuggerConfiguration;
            if (scheduledDebuggerConfiguration != null) {
                RunConfigurationBase runConfigurationBase = this.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)runConfigurationBase, (String)"getConfiguration(...)");
                string = scheduledDebuggerConfiguration.generateCommandLineParameter((ScheduledDebuggerRunConfiguration)runConfigurationBase);
            } else {
                string = null;
            }
            parametersList.add(string);
        }
        super.prepareTargetEnvironmentRequest(request, targetProgressIndicator);
    }

    public void handleCreatedTargetEnvironment(@NotNull TargetEnvironment environment, @NotNull TargetProgressIndicator targetProgressIndicator) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
        if (((QsApplicationRunConfiguration)this.getConfiguration()).isEnableScheduledDebugger()) {
            ScheduledDebuggerConfiguration scheduledDebuggerConfiguration = this.scheduledDebuggerConfiguration;
            if (scheduledDebuggerConfiguration != null) {
                scheduledDebuggerConfiguration.handleCreatedTargetEnvironment(environment);
            }
        }
        super.handleCreatedTargetEnvironment(environment, targetProgressIndicator);
    }
}

