/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.frontend.split;

import com.intellij.ide.vfs.VirtualFileId;
import com.intellij.ide.vfs.VirtualFileIdKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RemoteFilePath;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.vcs.frontend.split.ThinClientFilePath;
import java.io.File;
import java.nio.file.Path;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J'\u0010\u0004\u001a\u00020\u00052\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00072\u000b\u0010\u0012\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0016J%\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00072\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001d\u0010\u0013\u001a\u00020\u00052\u000b\u0010\u0015\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001d\u0010\u0016\u001a\u00020\u00052\u000b\u0010\u0015\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u000b\u0010\u0012\u001a\u00070\t\u00a2\u0006\u0002\b\u001bH\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/vcs/frontend/split/ThinClientVcsContextFactory;", "Lcom/intellij/platform/vcs/rd/ThinClientVcsContextFactory;", "<init>", "()V", "createFilePathOn", "Lcom/intellij/openapi/vcs/FilePath;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileName", "", "Lorg/jetbrains/annotations/NonNls;", "isDirectory", "", "virtualFileId", "Lcom/intellij/ide/vfs/VirtualFileId;", "file", "Ljava/io/File;", "parent", "name", "createFilePath", "Ljava/nio/file/Path;", "path", "createFilePathOnNonLocal", "createLocalChangeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.platform.vcs.frontend.split"})
public final class ThinClientVcsContextFactory
implements com.intellij.platform.vcs.rd.ThinClientVcsContextFactory {
    @NotNull
    public FilePath createFilePathOn(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return (FilePath)new ThinClientFilePath(virtualFile);
    }

    @NotNull
    public FilePath createFilePathOn(@NotNull String fileName, boolean isDirectory, @Nullable VirtualFileId virtualFileId) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        VirtualFileId virtualFileId2 = virtualFileId;
        return (FilePath)new ThinClientFilePath(fileName, isDirectory, (VirtualFile)(virtualFileId2 != null ? VirtualFileIdKt.virtualFile((VirtualFileId)virtualFileId2) : null));
    }

    @Deprecated(message="Deprecated in VcsContextFactory")
    @NotNull
    public FilePath createFilePathOn(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return (FilePath)new ThinClientFilePath(string, false, null, 4, null);
    }

    @NotNull
    public FilePath createFilePathOn(@NotNull File file, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return (FilePath)new ThinClientFilePath(string, isDirectory, null, 4, null);
    }

    @NotNull
    public FilePath createFilePathOn(@NotNull VirtualFile parent, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (FilePath)new ThinClientFilePath(parent.getPath() + "/" + name, false, null, 4, null);
    }

    @NotNull
    public FilePath createFilePath(@NotNull Path file, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path = file.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        return (FilePath)new ThinClientFilePath(((Object)path).toString(), isDirectory, null, 4, null);
    }

    @NotNull
    public FilePath createFilePath(@NotNull VirtualFile parent, @NotNull String fileName, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return (FilePath)new ThinClientFilePath(parent.getPath() + "/" + fileName, isDirectory, null, 4, null);
    }

    @NotNull
    public FilePath createFilePath(@NotNull String path, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (FilePath)new ThinClientFilePath(path, isDirectory, null, 4, null);
    }

    @NotNull
    public FilePath createFilePathOnNonLocal(@NotNull String path, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (FilePath)new RemoteFilePath(path, isDirectory);
    }

    @NotNull
    public LocalChangeList createLocalChangeList(@NotNull Project project, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        throw new IllegalStateException("Changes lists should not be created in Thin Client".toString());
    }
}

