/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.css;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.javascript.flex.css.SwitchToCssDialectQuickFix;
import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptorStub;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueValidator;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.descriptor.value.CssColorValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueValidatorImpl;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorProviderImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.Gray;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.css.JavaFxCSSDialect;
import org.jetbrains.plugins.javaFX.css.JavaFxCssHelper;
import org.jetbrains.plugins.javaFX.css.JavaFxCssPropertyDescriptor;
import org.jetbrains.plugins.javaFX.css.refs.JavaFxStylesheetsIndex;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;

public final class JavaFxCSSElementDescriptionProvider
extends CssElementDescriptorProviderImpl {
    static final Map<String, Color> ourAdditionalColors = new HashMap<String, Color>(1);
    private final CssValueValidatorImpl myValueValidator = new CssValueValidatorImpl(this, (CssElementDescriptorProvider)this){

        public boolean isValid(@Nullable PsiElement term, @NotNull CssValueDescriptor valueDescriptor) {
            if (valueDescriptor == null) {
                1.$$$reportNull$$$0(0);
            }
            if (valueDescriptor instanceof CssColorValue && term instanceof CssTerm && ((CssTerm)term).getTermType() == CssTermTypes.IDENT) {
                return true;
            }
            return super.isValid(term, valueDescriptor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescriptor", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider$1", "isValid"));
        }
    };

    public boolean isMyContext(@Nullable PsiElement context) {
        return JavaFxCSSElementDescriptionProvider.isJavaFXCSS(context);
    }

    public boolean shouldAskOtherProviders(PsiElement context) {
        return false;
    }

    @NotNull
    public CssValueValidator getValueValidator() {
        CssValueValidatorImpl cssValueValidatorImpl = this.myValueValidator;
        if (cssValueValidatorImpl == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(0);
        }
        return cssValueValidatorImpl;
    }

    public static boolean isJavaFXCSS(PsiElement context) {
        return JavaFxCSSElementDescriptionProvider.isJavaFXCSS(context, true);
    }

    public static boolean isJavaFXCSS(PsiElement context, boolean acceptInjected) {
        if (context == null || !context.isValid()) {
            return false;
        }
        PsiFile file = context.getContainingFile();
        if (file == null) {
            return false;
        }
        Project project = context.getProject();
        if (JavaFxCSSElementDescriptionProvider.isInjected(context, project)) {
            return acceptInjected;
        }
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        CssDialectMappings dialectMappings = CssDialectMappings.getInstance((Project)project);
        String dialectName = (String)dialectMappings.getMapping(virtualFile);
        if (JavaFxCSSDialect.getInstance().getName().equals(dialectName)) {
            return true;
        }
        if (dialectName == null || dialectName.equals(CssDialect.CLASSIC.getName())) {
            boolean hasJavaFxDeclarations = (Boolean)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
                CssDeclaration cssDeclaration = (CssDeclaration)PsiTreeUtil.findChildOfType((PsiElement)file, CssDeclaration.class);
                boolean result = JavaFxCSSElementDescriptionProvider.isJavaFXDeclaration(cssDeclaration) || JavaFxCSSElementDescriptionProvider.isJavaFXDeclaration((CssDeclaration)PsiTreeUtil.findChildOfType((PsiElement)PsiTreeUtil.findChildOfType((PsiElement)file, CssRuleset.class), CssDeclaration.class));
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{file});
            });
            return hasJavaFxDeclarations || JavaFxCSSElementDescriptionProvider.canUseIndex(project) && JavaFxStylesheetsIndex.isUsedInFxml(project, file);
        }
        return false;
    }

    private static boolean canUseIndex(Project project) {
        return !ActionUtil.isDumbMode((Project)project) && !ApplicationManager.getApplication().isDispatchThread();
    }

    private static boolean isJavaFXDeclaration(CssDeclaration cssDeclaration) {
        String propertyName;
        return cssDeclaration != null && (propertyName = cssDeclaration.getPropertyName()).startsWith("-fx-");
    }

    private static boolean isInjected(PsiElement context, Project project) {
        PsiLanguageInjectionHost injectionHost = InjectedLanguageManager.getInstance((Project)project).getInjectionHost(context);
        if (injectionHost != null) {
            PsiClass containingClass;
            PsiMethod psiMethod;
            PsiMethodCallExpression methodCallExpression;
            PsiFile topLevelFile = injectionHost.getContainingFile();
            if (topLevelFile != null && JavaFxFileTypeFactory.isFxml((PsiFile)topLevelFile)) {
                return true;
            }
            if (topLevelFile instanceof PsiClassOwner && (methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)injectionHost, PsiMethodCallExpression.class)) != null && (psiMethod = methodCallExpression.resolveMethod()) != null && "setStyle".equals(psiMethod.getName()) && (containingClass = psiMethod.getContainingClass()) != null && "javafx.scene.Node".equals(containingClass.getQualifiedName())) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public CssPropertyDescriptor getPropertyDescriptor(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(1);
        }
        return new JavaFxCssPropertyDescriptor(propertyName);
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> findPropertyDescriptors(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(2);
        }
        if ("-fx-font-family".equals(propertyName)) {
            Collection collection = super.findPropertyDescriptors("font-family", context);
            if (collection == null) {
                JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(3);
            }
            return collection;
        }
        List<CssPropertyDescriptor> list = Collections.singletonList(this.getPropertyDescriptor(propertyName, context));
        if (list == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> findPseudoSelectorDescriptors(@NotNull String name, @Nullable PsiElement context) {
        if (name == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(5);
        }
        List<Object> list = JavaFxCssHelper.getPseudoClasses().contains(name) ? Collections.singletonList(new CssPseudoSelectorDescriptorStub(name)) : Collections.emptyList();
        if (list == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public Collection<? extends CssValueDescriptor> getNamedValueDescriptors(@NotNull String name, @Nullable CssValueDescriptor parent) {
        Collection<CssValueDescriptor> descriptors;
        if (name == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(7);
        }
        if (!(descriptors = JavaFxCssHelper.getNamedValueDescriptors(name)).isEmpty()) {
            Collection<CssValueDescriptor> collection = descriptors;
            if (collection == null) {
                JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(8);
            }
            return collection;
        }
        Collection collection = super.getNamedValueDescriptors(name, parent);
        if (collection == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssFunctionDescriptor> findFunctionDescriptors(@NotNull String functionName, @Nullable PsiElement context) {
        Collection<CssFunctionDescriptor> descriptors;
        if (functionName == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(10);
        }
        if (!(descriptors = JavaFxCssHelper.getFunctionDescriptors(functionName)).isEmpty()) {
            Collection<CssFunctionDescriptor> collection = descriptors;
            if (collection == null) {
                JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(11);
            }
            return collection;
        }
        Collection collection = super.findFunctionDescriptors(functionName, context);
        if (collection == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(12);
        }
        return collection;
    }

    public boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
        if (selector == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(13);
        }
        if (context == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(14);
        }
        return true;
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> getAllPseudoSelectorDescriptors(@Nullable PsiElement context) {
        List list = ContainerUtil.map(JavaFxCssHelper.getPseudoClasses(), CssPseudoSelectorDescriptorStub::new);
        if (list == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> getAllPropertyDescriptors(@Nullable PsiElement context) {
        List list = ContainerUtil.map(JavaFxCssHelper.getPropertyNames(), JavaFxCssPropertyDescriptor::new);
        if (list == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(16);
        }
        return list;
    }

    public String @NotNull [] getSimpleSelectors(@NotNull PsiElement context) {
        if (context == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(17);
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(18);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public PsiElement @NotNull [] getDeclarationsForSimpleSelector(@NotNull CssSimpleSelector selector) {
        if (selector == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(19);
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(20);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public boolean providesClassicCss() {
        return false;
    }

    public Color getColorByValue(@NotNull String value) {
        if (value == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(21);
        }
        return ourAdditionalColors.get(value);
    }

    public boolean isColorTerm(@NotNull CssTerm term) {
        if (term == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(22);
        }
        return ourAdditionalColors.get(term.getText()) != null;
    }

    public LocalQuickFix @NotNull [] getQuickFixesForUnknownProperty(@NotNull String propertyName, @NotNull PsiElement context, boolean isOnTheFly) {
        if (propertyName == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(23);
        }
        if (context == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(24);
        }
        if (!isOnTheFly) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(25);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)context);
        if (vFile == null || !FileTypeRegistry.getInstance().isFileOfType(vFile, (FileType)CssFileType.INSTANCE)) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(26);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        String dialectName = (String)CssDialectMappings.getInstance((Project)context.getProject()).getMapping(vFile);
        if (dialectName == null || dialectName.equals(CssDialect.CLASSIC.getName())) {
            List propertyDescriptors;
            Collection<Object> collection = propertyDescriptors = propertyName.startsWith("-fx-") ? this.findPropertyDescriptors(propertyName, context) : Collections.emptyList();
            if (!propertyDescriptors.isEmpty()) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new SwitchToCssDialectQuickFix(JavaFxCSSDialect.getInstance())};
                if (localQuickFixArray == null) {
                    JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(27);
                }
                return localQuickFixArray;
            }
        }
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            JavaFxCSSElementDescriptionProvider.$$$reportNull$$$0(28);
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    static {
        ourAdditionalColors.put("transparent", Gray.TRANSPARENT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 5, 7, 10, 13, 14, 17, 19, 21, 22, 23, 24 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider";
                break;
            }
            case 1: 
            case 2: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 14: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "term";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueValidator";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findPropertyDescriptors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findPseudoSelectorDescriptors";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedValueDescriptors";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findFunctionDescriptors";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPseudoSelectorDescriptors";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPropertyDescriptors";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleSelectors";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationsForSimpleSelector";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixesForUnknownProperty";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findPseudoSelectorDescriptors";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNamedValueDescriptors";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findFunctionDescriptors";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleSelector";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleSelectors";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationsForSimpleSelector";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getColorByValue";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isColorTerm";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixesForUnknownProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 5, 7, 10, 13, 14, 17, 19, 21, 22, 23, 24 -> new IllegalArgumentException(string);
        };
    }
}

