/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospectorKt;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DatabaseFragmentIntrospectionTask;
import com.intellij.database.introspection.DatabaseIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.SchemaFragmentIntrospectionTask;
import com.intellij.database.introspection.SchemasIntrospectionTask;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSingleDatabaseRoot;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.util.TreePattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005:\u0004CDEFB)\b\u0014\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0014J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001bH\u0014J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001dH\u0014J!\u0010\u001e\u001a\u00020\u00162\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 \"\u00020!H\u0016\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020!H\u0014J\b\u0010%\u001a\u00020\u0016H&J \u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u00182\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010\u0014H\u0014J&\u0010*\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u00182\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00010\u00112\u0006\u0010,\u001a\u00020-H$J\b\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u0018H\u0014J\u0018\u00101\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u000202H\u0014J8\u00103\u001a\u00020\u00162\f\u00104\u001a\b\u0012\u0004\u0012\u000206052\u0006\u00107\u001a\u00020-2\u0018\u00108\u001a\u0014\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0 09H\u0016J\u001a\u0010;\u001a\u0004\u0018\u00010!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010<\u001a\u00020:H\u0014J\u0012\u0010=\u001a\u0004\u0018\u00010!2\u0006\u0010<\u001a\u00020:H\u0014J&\u0010>\u001a\u00180?R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J5\u0010@\u001a\u001a\u0012\u0006\b\u0001\u0012\u00028\u00000AR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010B\u00a8\u0006G"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "R", "Lcom/intellij/database/model/basic/BasicModSingleDatabaseRoot;", "S", "Lcom/intellij/database/model/basic/BasicModSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "nature", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;Lcom/intellij/database/Dbms;Lcom/intellij/database/model/ModelFactory;)V", "optimizeTasks", "", "Lcom/intellij/database/introspection/IntrospectionTask;", "originalTasks", "", "introspectNamespaces", "", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "task", "introspectDatabase", "Lcom/intellij/database/introspection/DatabaseIntrospectionTask;", "introspectSchemas", "Lcom/intellij/database/introspection/SchemasIntrospectionTask;", "introspectDatabaseSchemas", "databases", "", "Lcom/intellij/database/model/basic/BasicDatabase;", "([Lcom/intellij/database/model/basic/BasicDatabase;)V", "retrieveSchemasOfDatabase", "database", "retrieveAndApplySchemas", "introspectAutomatically", "tran", "namespaces", "Lcom/intellij/database/model/basic/BasicNamespace;", "introspectSchemasAuto", "schemas", "whole", "", "getDefaultScope", "Lcom/intellij/database/util/TreePattern;", "introspectServerObjectsInner", "introspectDatabaseFragments", "Lcom/intellij/database/introspection/DatabaseFragmentIntrospectionTask;", "introspectNativeDefinitions", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "withNestedElements", "result", "", "", "reifyDatabase", "databaseName", "findDatabase", "createServerObjectsRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractServerObjectsRetriever;", "createNativeRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseNativeRetriever;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModSingleDatabaseRoot;)Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseNativeRetriever;", "BaseDatabaseRetriever", "BaseDatabaseSchemasRetriever", "BaseServerObjectsRetriever", "BaseNativeRetriever", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nBaseSingleDatabaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseSingleDatabaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,174:1\n1#2:175\n1869#3,2:176\n1321#4,2:178\n*S KotlinDebug\n*F\n+ 1 BaseSingleDatabaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector\n*L\n76#1:176,2\n87#1:178,2\n*E\n"})
public abstract class BaseSingleDatabaseIntrospector<R extends BasicModSingleDatabaseRoot, S extends BasicModSchema>
extends BaseNativeIntrospector<R, R, S> {
    protected BaseSingleDatabaseIntrospector(@NotNull DBIntrospectionContext context, @NotNull BaseIntrospector.Nature nature, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)nature, (String)"nature");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        super(context, nature, dbms, modelFactory);
    }

    @Override
    @NotNull
    protected List<IntrospectionTask> optimizeTasks(@NotNull Collection<? extends IntrospectionTask> originalTasks) {
        Intrinsics.checkNotNullParameter(originalTasks, (String)"originalTasks");
        List<IntrospectionTask> tasks = super.optimizeTasks(originalTasks);
        ArrayList tasksToPerform = new ArrayList(tasks.size());
        ArrayList namedFragmentTasks = new ArrayList();
        for (IntrospectionTask task : tasks) {
            if (task instanceof SchemaFragmentIntrospectionTask) {
                ((Collection)namedFragmentTasks).add(task);
                continue;
            }
            ((Collection)tasksToPerform).add(task);
        }
        tasksToPerform.addAll(namedFragmentTasks);
        return tasksToPerform;
    }

    @Override
    protected void introspectNamespaces(@NotNull DBTransaction transaction, @NotNull IntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.introspectNamespacesInTran(transaction);
    }

    @Override
    protected void introspectDatabase(@NotNull DBTransaction transaction, @NotNull DatabaseIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.introspectAutoInTran(transaction, null);
    }

    @Override
    protected void introspectSchemas(@NotNull DBTransaction transaction, @NotNull SchemasIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Iterable iterable = ((BasicModSingleDatabaseRoot)this.getRoot()).getNamespaces();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getNamespaces(...)");
        List schemas = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)iterable), arg_0 -> BaseSingleDatabaseIntrospector.introspectSchemas$lambda$0(task, arg_0)));
        this.introspectAutoInTran(transaction, schemas);
    }

    public void introspectDatabaseSchemas(BasicDatabase ... databases) {
        Intrinsics.checkNotNullParameter((Object)databases, (String)"databases");
        this.trace("Introspecting database schemas brief info");
        boolean bl = this.getInitialized();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-BaseSingleDatabaseIntrospector$introspectDatabaseSchemas$32 = false;
            String $i$a$-assert-BaseSingleDatabaseIntrospector$introspectDatabaseSchemas$32 = "Introspector is not initialized yet.";
            throw new AssertionError((Object)$i$a$-assert-BaseSingleDatabaseIntrospector$introspectDatabaseSchemas$32);
        }
        boolean bl2 = bl = databases.length == 0 || databases.length == 1 && Intrinsics.areEqual((Object)databases[0], this.getRoot());
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Invalid or alien databases.";
            throw new AssertionError((Object)string);
        }
        this.retrieveAndApplySchemas();
    }

    @Override
    protected void retrieveSchemasOfDatabase(@NotNull DBTransaction transaction, @NotNull BasicDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        if (Intrinsics.areEqual((Object)database, this.getRoot())) {
            this.introspectNamespacesInTran(transaction);
        } else {
            IntrospectionQueryContext.logError$default((IntrospectionQueryContext)this, (String)("Requested to retrieve schemas of alien database: " + database), null, (int)2, null);
        }
    }

    public abstract void retrieveAndApplySchemas();

    @Override
    protected void introspectAutomatically(@NotNull DBTransaction tran, @Nullable Collection<? extends BasicNamespace> namespaces) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        ArrayList<BasicModSchema> schemas = new ArrayList<BasicModSchema>();
        boolean whole = false;
        Collection<? extends BasicNamespace> collection = namespaces;
        if (collection != null) {
            $this$forEach$iv = collection;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BasicSchema schema;
                BasicNamespace namespace = (BasicNamespace)element$iv;
                boolean bl = false;
                boolean bl2 = this.getModel().contains((DasObject)namespace);
                if (_Assertions.ENABLED && !bl2) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                if ((namespace instanceof BasicSchema ? (BasicSchema)namespace : null) == null) continue;
                schema = schema;
                Intrinsics.checkNotNull((Object)schema, (String)"null cannot be cast to non-null type S of com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector");
                schemas.add((BasicModSchema)schema);
            }
        }
        if (schemas.isEmpty()) {
            whole = true;
            this.introspectNamespacesInTran(tran);
            Iterable iterable = ((BasicModSingleDatabaseRoot)this.getRoot()).getNamespaces();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getNamespaces(...)");
            $this$forEach$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)iterable), arg_0 -> BaseSingleDatabaseIntrospector.introspectAutomatically$lambda$1(this, arg_0));
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BasicModSchema it = (BasicModSchema)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type S of com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector");
                schemas.add(it);
            }
        }
        if (!((Collection)schemas).isEmpty()) {
            this.introspectSchemasAuto(tran, (List)schemas, whole);
        }
        this.postIntrospectionProcess();
    }

    protected abstract void introspectSchemasAuto(@NotNull DBTransaction var1, @NotNull List<? extends S> var2, boolean var3);

    @NotNull
    public TreePattern getDefaultScope() {
        return BaseSingleDatabaseIntrospectorKt.getSINGLE_DB_SCOPE();
    }

    @Override
    protected void introspectServerObjectsInner(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        BaseNativeIntrospector.AbstractDatabaseRetriever<BasicModDatabase> databaseRetriever = this.createDatabaseRetriever(tran, (BasicModDatabase)this.getRoot());
        databaseRetriever.retrieveAuxiliaryObjects();
    }

    @Override
    protected void introspectDatabaseFragments(@NotNull DBTransaction transaction, @NotNull DatabaseFragmentIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.introspectServerObjectsInTran(transaction);
    }

    @Override
    public void introspectNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements, boolean withNestedElements, @NotNull Map<BasicElement, String[]> result) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)arg_0 -> BaseSingleDatabaseIntrospector.introspectNativeDefinitions$lambda$0(this, elements, withNestedElements, result, arg_0)));
    }

    @Override
    @Nullable
    protected BasicDatabase reifyDatabase(@NotNull DBTransaction transaction, @NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        if (Intrinsics.areEqual((Object)databaseName, (Object)((DasNamed)this.getRoot()).getName()) || Intrinsics.areEqual((Object)databaseName, (Object)"@") || ((CharSequence)databaseName).length() == 0) {
            return (BasicDatabase)this.getRoot();
        }
        this.introspectServerInfo();
        return Intrinsics.areEqual((Object)databaseName, (Object)((DasNamed)this.getRoot()).getName()) ? (BasicDatabase)this.getRoot() : null;
    }

    @Override
    @Nullable
    protected BasicDatabase findDatabase(@NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        return Intrinsics.areEqual((Object)databaseName, (Object)((DasNamed)this.getRoot()).getName()) || Intrinsics.areEqual((Object)databaseName, (Object)"@") || ((CharSequence)databaseName).length() == 0 ? (BasicDatabase)this.getRoot() : null;
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractServerObjectsRetriever createServerObjectsRetriever(@NotNull DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        return new BaseServerObjectsRetriever(transaction);
    }

    @Override
    @NotNull
    protected BaseNativeRetriever<? extends R> createNativeRetriever(@NotNull DBTransaction transaction, @NotNull R database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(database, (String)"database");
        return new BaseNativeRetriever<R>(this, transaction){};
    }

    private static final boolean introspectSchemas$lambda$0(SchemasIntrospectionTask $task, BasicModSchema it) {
        return $task.getSchemaNames().contains(it.getName());
    }

    private static final boolean introspectAutomatically$lambda$1(BaseSingleDatabaseIntrospector this$0, BasicModSchema it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.inIntrospectionScope((BasicNamespace)it);
    }

    private static final Unit introspectNativeDefinitions$lambda$0(BaseSingleDatabaseIntrospector this$0, Iterable $elements, boolean $withNestedElements, Map $result, DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        BaseNativeRetriever<BasicModSingleDatabaseRoot> retriever = this$0.createNativeRetriever(transaction, (R)((BasicModSingleDatabaseRoot)this$0.getRoot()));
        retriever.retrieveNativeDefinitions($elements, $withNestedElements, $result);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00a4\u0004\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004B\u0011\b\u0014\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseDatabaseRetriever;", "R", "Lcom/intellij/database/model/basic/BasicModSingleDatabaseRoot;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "<init>", "(Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;)V", "intellij.database.dialects.base"})
    protected abstract class BaseDatabaseRetriever<R extends BasicModSingleDatabaseRoot>
    extends BaseNativeIntrospector.AbstractDatabaseRetriever<R> {
        protected BaseDatabaseRetriever(DBTransaction transaction) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            BaseNativeIntrospector baseNativeIntrospector = BaseSingleDatabaseIntrospector.this;
            BasicRoot basicRoot = BaseSingleDatabaseIntrospector.this.getModel().getRoot();
            Intrinsics.checkNotNull((Object)basicRoot, (String)"null cannot be cast to non-null type R of com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector.BaseDatabaseRetriever");
            super(baseNativeIntrospector, transaction, (BasicModDatabase)((BasicModSingleDatabaseRoot)basicRoot));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u00a4\u0004\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u0002*\b\b\u0003\u0010\u0003*\u00020\u00042$\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006B\u001f\b\u0014\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00030\n\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseDatabaseSchemasRetriever;", "R", "Lcom/intellij/database/model/basic/BasicModSingleDatabaseRoot;", "S", "Lcom/intellij/database/model/basic/BasicModSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseSchemasRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schemas", "", "<init>", "(Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Ljava/util/List;)V", "intellij.database.dialects.base"})
    protected abstract class BaseDatabaseSchemasRetriever<R extends BasicModSingleDatabaseRoot, S extends BasicModSchema>
    extends BaseNativeIntrospector.AbstractDatabaseSchemasRetriever<R, S> {
        protected BaseDatabaseSchemasRetriever(@NotNull DBTransaction transaction, List<? extends S> schemas) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
            BaseNativeIntrospector baseNativeIntrospector = BaseSingleDatabaseIntrospector.this;
            BasicRoot basicRoot = BaseSingleDatabaseIntrospector.this.getModel().getRoot();
            Intrinsics.checkNotNull((Object)basicRoot, (String)"null cannot be cast to non-null type R of com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector.BaseDatabaseSchemasRetriever");
            super(baseNativeIntrospector, transaction, (BasicModDatabase)((BasicModSingleDatabaseRoot)basicRoot), schemas);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00a4\u0004\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004B\u0011\b\u0014\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseNativeRetriever;", "R", "Lcom/intellij/database/model/basic/BasicModSingleDatabaseRoot;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "<init>", "(Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;)V", "intellij.database.dialects.base"})
    protected abstract class BaseNativeRetriever<R extends BasicModSingleDatabaseRoot>
    extends BaseNativeIntrospector.AbstractNativeRetriever<R> {
        protected BaseNativeRetriever(DBTransaction transaction) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            BaseNativeIntrospector baseNativeIntrospector = BaseSingleDatabaseIntrospector.this;
            BasicRoot basicRoot = BaseSingleDatabaseIntrospector.this.getModel().getRoot();
            Intrinsics.checkNotNull((Object)basicRoot, (String)"null cannot be cast to non-null type R of com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector.BaseNativeRetriever");
            super(baseNativeIntrospector, transaction, (BasicModDatabase)((BasicModSingleDatabaseRoot)basicRoot));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0094\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseServerObjectsRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractServerObjectsRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "<init>", "(Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;)V", "intellij.database.dialects.base"})
    protected class BaseServerObjectsRetriever
    extends BaseNativeIntrospector.AbstractServerObjectsRetriever {
        public BaseServerObjectsRetriever(DBTransaction transaction) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            super(transaction);
        }
    }
}

