/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql.inspections;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/dialects/mssql/inspections/MsBuiltinInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "<init>", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.dialects.mssql.ex"})
public final class MsBuiltinInspection
extends SqlInspectionBase {
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        if (!dialect.getDbms().isMicrosoft()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result, onTheFly){
            final /* synthetic */ boolean $onTheFly;
            {
                this.$onTheFly = $onTheFly;
                super($manager, (SqlLanguageDialect)$dialect, (Collection)$result);
            }

            public void visitSqlFunctionCallExpression(SqlFunctionCallExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                BuiltinFunction builtinFunction = o.getFunctionDefinition();
                if (builtinFunction == null) {
                    return;
                }
                BuiltinFunction builtinFunction2 = builtinFunction;
                if (!StringsKt.equals((String)builtinFunction2.getName(), (String)"isnull", (boolean)true)) {
                    return;
                }
                Object object = o.getParameterList();
                if (object == null || (object = object.getExpressionList()) == null) {
                    return;
                }
                Object expressions = object;
                if (expressions.size() != 2) {
                    return;
                }
                DasType dasType = ((SqlExpression)expressions.get(0)).getDasType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                DasType type1 = dasType;
                DasType dasType2 = ((SqlExpression)expressions.get(1)).getDasType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getDasType(...)");
                DasType type2 = dasType2;
                if (DasTypeUtilsKt.getCategory((DasType)type1) != DasTypeCategory.STRING && DasTypeUtilsKt.getCategory((DasType)type2) != DasTypeCategory.STRING) {
                    return;
                }
                if (type1.toDataType().getLength() < type2.toDataType().getLength()) {
                    PsiElement psiElement = (PsiElement)o;
                    String string = AnalysisBundle.message((String)"MsBuiltinInspection.inspection.message.second.argument.isnull.implicitly.truncated", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.reportProblem(psiElement, string);
                }
            }

            private final void reportProblem(PsiElement anchor, @InspectionMessage String message) {
                this.addDescriptor(this.myManager.createProblemDescriptor(anchor, message, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
            }
        };
    }
}

