/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.rename;

import com.intellij.css.util.CssPsiUtilCore;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssCustomPropertyRenameHandler
extends PsiElementRenameHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        CssDeclaration elementToRename;
        PsiElement element;
        if (dataContext == null) {
            CssCustomPropertyRenameHandler.$$$reportNull$$$0(0);
        }
        if ((element = CssCustomPropertyRenameHandler.getElement((DataContext)dataContext)) == null) {
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            if (editor != null && psiFile != null) {
                element = BaseRefactoringAction.getElementAtCaret((Editor)editor, (PsiFile)psiFile);
            }
        }
        return (elementToRename = CssCustomPropertyRenameHandler.getElementToRename(element)) != null && !CssCustomPropertyRenameHandler.isVetoed((PsiElement)elementToRename);
    }

    @Nullable
    private static CssDeclaration getElementToRename(@Nullable PsiElement context) {
        if (context == null || CssPsiUtilCore.getStylesheetLanguage((PsiElement)context) == null) {
            return null;
        }
        ASTNode node = context.getNode();
        if (node != null && node.getElementType() == CssElementTypes.CSS_IDENT) {
            for (PsiReference reference : context.getReferences()) {
                ProgressIndicatorProvider.checkCanceled();
                if (reference instanceof PsiPolyVariantReference) {
                    for (ResolveResult result : ((PsiPolyVariantReference)reference).multiResolve(false)) {
                        ProgressIndicatorProvider.checkCanceled();
                        PsiElement element = result.getElement();
                        if (!(element instanceof CssDeclaration)) continue;
                        return (CssDeclaration)element;
                    }
                    continue;
                }
                return (CssDeclaration)ObjectUtils.tryCast((Object)reference.resolve(), CssDeclaration.class);
            }
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, @NotNull DataContext dataContext) {
        if (project == null) {
            CssCustomPropertyRenameHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            CssCustomPropertyRenameHandler.$$$reportNull$$$0(2);
        }
        PsiElement context = BaseRefactoringAction.getElementAtCaret((Editor)editor, (PsiFile)file);
        CssDeclaration elementToRename = CssCustomPropertyRenameHandler.getElementToRename(context);
        if (context != null && elementToRename != null) {
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                String initialName = (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext);
                CssCustomPropertyRenameHandler.rename((PsiElement)elementToRename, (Project)project, (PsiElement)context, (Editor)editor, (String)initialName);
                return;
            }
            CssCustomPropertyRenameHandler.invoke((PsiElement)elementToRename, (Project)project, (PsiElement)context, (Editor)editor);
        }
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            CssCustomPropertyRenameHandler.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            CssCustomPropertyRenameHandler.$$$reportNull$$$0(4);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/actions/rename/CssCustomPropertyRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

