/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPropertyInfo;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.CssUtilCore;
import com.intellij.psi.css.impl.util.completion.AngleUserLookup;
import com.intellij.psi.css.impl.util.completion.CounterUserLookup;
import com.intellij.psi.css.impl.util.completion.FrequencyUserLookup;
import com.intellij.psi.css.impl.util.completion.IntegerUserLookup;
import com.intellij.psi.css.impl.util.completion.LengthUserLookup;
import com.intellij.psi.css.impl.util.completion.PercentageUserLookup;
import com.intellij.psi.css.impl.util.completion.ResolutionUserLookup;
import com.intellij.psi.css.impl.util.completion.ShapeUserLookup;
import com.intellij.psi.css.impl.util.completion.TimeUserLookup;
import com.intellij.psi.css.impl.util.completion.UriUserLookup;
import com.intellij.psi.css.impl.util.table.CssBorderWidthValue;
import com.intellij.psi.css.impl.util.table.CssColorValue;
import com.intellij.psi.css.impl.util.table.CssExpandedValue;
import com.intellij.psi.css.impl.util.table.CssFontFamilyDescriptor;
import com.intellij.psi.css.impl.util.table.CssFontFamilyValue;
import com.intellij.psi.css.impl.util.table.CssFunctionPropertyValue;
import com.intellij.psi.css.impl.util.table.CssImageValue;
import com.intellij.psi.css.impl.util.table.CssLookupValue;
import com.intellij.psi.css.impl.util.table.CssMarginWidthValue;
import com.intellij.psi.css.impl.util.table.CssPropertyDescriptorImpl;
import com.intellij.psi.css.impl.util.table.CssPropertyValueImpl;
import com.intellij.psi.css.impl.util.table.CssReferencePropertyValue;
import com.intellij.psi.css.impl.util.table.CssStringPropertyValue;
import com.intellij.psi.css.impl.util.table.CssTableValue;
import com.intellij.psi.css.impl.util.table.CssVendorSpecificPropertyUtil;
import com.intellij.psi.css.impl.util.table.VoiceFamilyPropertyDescriptor;
import com.intellij.reference.SoftReference;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class CssElementDescriptorFactory {
    private static final Logger LOG = Logger.getInstance(CssElementDescriptorFactory.class);
    private Reference<Map<String, CssPropertyDescriptor>> myDescriptorMapRef;

    @NotNull
    private synchronized Map<String, CssPropertyDescriptor> getDescriptorsMap() {
        Map<String, CssPropertyDescriptor> descriptors = (Map<String, CssPropertyDescriptor>)SoftReference.dereference(this.myDescriptorMapRef);
        return descriptors != null ? descriptors : this.reload();
    }

    @NotNull
    private synchronized Map<String, CssPropertyDescriptor> reload() {
        HashMap<String, List<MyCssPropertyXmlDescription>> propertiesDescriptionMap = new HashMap<String, List<MyCssPropertyXmlDescription>>();
        CssElementDescriptorFactory.loadDescriptors(CssElementDescriptor.CssVersion.CSS_2_1, propertiesDescriptionMap);
        CssElementDescriptorFactory.loadDescriptors(CssElementDescriptor.CssVersion.CSS_3_0, propertiesDescriptionMap);
        CssElementDescriptorFactory.loadDescriptors(CssElementDescriptor.CssVersion.CSS_3_0_MOZILLA, propertiesDescriptionMap);
        CssElementDescriptorFactory.loadDescriptors(CssElementDescriptor.CssVersion.CSS_3_0_SAFARI, propertiesDescriptionMap);
        CssElementDescriptorFactory.loadDescriptors(CssElementDescriptor.CssVersion.CSS_3_0_OPERA, propertiesDescriptionMap);
        Map<String, CssPropertyDescriptor> descriptors = CssElementDescriptorFactory.buildDescriptorsMap(propertiesDescriptionMap);
        this.myDescriptorMapRef = new java.lang.ref.SoftReference<Map<String, CssPropertyDescriptor>>(descriptors);
        Map<String, CssPropertyDescriptor> map = descriptors;
        if (map == null) {
            CssElementDescriptorFactory.$$$reportNull$$$0(0);
        }
        return map;
    }

    @Nullable
    public static CssPropertyDescriptor getDescriptor(@NotNull String propertyName) {
        if (propertyName == null) {
            CssElementDescriptorFactory.$$$reportNull$$$0(1);
        }
        propertyName = StringUtil.toLowerCase((String)propertyName);
        CssElementDescriptorFactory service = (CssElementDescriptorFactory)ApplicationManager.getApplication().getService(CssElementDescriptorFactory.class);
        if (service == null) {
            return null;
        }
        Map<String, CssPropertyDescriptor> descriptors = service.getDescriptorsMap();
        CssPropertyDescriptor descriptor = descriptors.get(propertyName);
        if (descriptor == null) {
            descriptor = descriptors.get(CssVendorSpecificPropertyUtil.getElementNameWithoutVendorPrefix((String)propertyName));
        }
        if (descriptor == null && propertyName.length() > 1 && CssUtilCore.isHackPropertyName((String)propertyName)) {
            descriptor = descriptors.get(propertyName.substring(1));
        }
        return descriptor;
    }

    @NotNull
    private static Map<String, CssPropertyDescriptor> buildDescriptorsMap(@NotNull Map<String, List<MyCssPropertyXmlDescription>> propertiesDescriptionMap) {
        if (propertiesDescriptionMap == null) {
            CssElementDescriptorFactory.$$$reportNull$$$0(2);
        }
        HashMap<String, CssPropertyDescriptor> result = new HashMap<String, CssPropertyDescriptor>();
        for (String propertyName : propertiesDescriptionMap.keySet()) {
            result.put(propertyName, CssElementDescriptorFactory.createDescriptor(propertyName, propertiesDescriptionMap.get(propertyName)));
        }
        HashMap<String, CssPropertyDescriptor> hashMap = result;
        if (hashMap == null) {
            CssElementDescriptorFactory.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    private static void loadDescriptors(@NotNull CssElementDescriptor.CssVersion version, @NotNull Map<String, List<MyCssPropertyXmlDescription>> propertiesDescriptionMap) {
        if (version == null) {
            CssElementDescriptorFactory.$$$reportNull$$$0(4);
        }
        if (propertiesDescriptionMap == null) {
            CssElementDescriptorFactory.$$$reportNull$$$0(5);
        }
        HashMap<String, MyCssPropertyXmlDescription> map = new HashMap<String, MyCssPropertyXmlDescription>();
        CssElementDescriptorFactory.doLoadDescriptors(version, map);
        for (String propertyName : map.keySet()) {
            MyCssPropertyXmlDescription description = (MyCssPropertyXmlDescription)map.get(propertyName);
            List descriptionList = propertiesDescriptionMap.computeIfAbsent(propertyName, k -> new ArrayList());
            descriptionList.add(description);
        }
    }

    private static void doLoadDescriptors(@NotNull CssElementDescriptor.CssVersion version, @NotNull Map<String, MyCssPropertyXmlDescription> propertiesDescriptionMap) {
        String filename;
        if (version == null) {
            CssElementDescriptorFactory.$$$reportNull$$$0(6);
        }
        if (propertiesDescriptionMap == null) {
            CssElementDescriptorFactory.$$$reportNull$$$0(7);
        }
        if (version == CssElementDescriptor.CssVersion.CSS_2_1) {
            filename = "csstable.xml";
        } else if (version == CssElementDescriptor.CssVersion.CSS_3_0) {
            filename = "css3table.xml";
        } else if (version == CssElementDescriptor.CssVersion.CSS_3_0_MOZILLA) {
            filename = "css3mozillatable.xml";
        } else if (version == CssElementDescriptor.CssVersion.CSS_3_0_SAFARI) {
            filename = "css3safaritable.xml";
        } else if (version == CssElementDescriptor.CssVersion.CSS_3_0_OPERA) {
            filename = "css3operatable.xml";
        } else {
            throw new IllegalArgumentException("Unknown CSS version " + String.valueOf(version));
        }
        try (InputStream stream = CssElementDescriptorFactory.class.getResourceAsStream(filename);){
            Element element = JDOMUtil.load((InputStream)stream);
            for (Element each : element.getChildren("property")) {
                ProgressManager.checkCanceled();
                String propertyName = each.getAttributeValue("name");
                assert (propertyName != null);
                propertiesDescriptionMap.put(propertyName, new MyCssPropertyXmlDescription(each, version));
            }
        }
        catch (IOException | JDOMException e) {
            LOG.error(e);
        }
    }

    @NotNull
    private static CssPropertyDescriptor createDescriptor(@NotNull String propertyName, @NotNull List<MyCssPropertyXmlDescription> descriptions) {
        if (propertyName == null) {
            CssElementDescriptorFactory.$$$reportNull$$$0(8);
        }
        if (descriptions == null) {
            CssElementDescriptorFactory.$$$reportNull$$$0(9);
        }
        ProgressManager.checkCanceled();
        Element[] elements = new Element[descriptions.size()];
        int n = descriptions.size();
        for (int i = 0; i < n; ++i) {
            Element element = descriptions.get((int)i).myElement;
            List children = element.getChildren();
            assert (children.size() == 1);
            elements[i] = (Element)children.get(0);
        }
        CssPropertyInfo[] infos = new CssPropertyInfo[descriptions.size()];
        for (int i = 0; i < infos.length; ++i) {
            Element e = descriptions.get((int)i).myElement;
            CssElementDescriptor.CssVersion version = descriptions.get((int)i).myVersion;
            infos[i] = new CssPropertyInfo(e, version);
        }
        CssPropertyDescriptorImpl result = "font-family".equals(propertyName) ? new CssFontFamilyDescriptor(propertyName, infos) : ("voice-family".equals(propertyName) ? new VoiceFamilyPropertyDescriptor(propertyName, infos) : new CssPropertyDescriptorImpl(propertyName, infos));
        ((CssPropertyDescriptorImpl)result).setValue(CssElementDescriptorFactory.createValues(propertyName, elements));
        CssPropertyDescriptorImpl cssPropertyDescriptorImpl = result;
        if (cssPropertyDescriptorImpl == null) {
            CssElementDescriptorFactory.$$$reportNull$$$0(10);
        }
        return cssPropertyDescriptorImpl;
    }

    private static CssPropertyValueImpl createValue(@NotNull String propertyName, @NotNull Element e) {
        String valueType;
        if (propertyName == null) {
            CssElementDescriptorFactory.$$$reportNull$$$0(11);
        }
        if (e == null) {
            CssElementDescriptorFactory.$$$reportNull$$$0(12);
        }
        if ("alphavalue".equals(valueType = e.getAttributeValue("vtype"))) {
            return new CssLookupValue(new IntegerUserLookup(), CssTermTypes.NUMBER);
        }
        if ("color".equals(valueType)) {
            return new CssColorValue();
        }
        if ("uri".equals(valueType)) {
            return new CssLookupValue(new UriUserLookup(), CssTermTypes.URI);
        }
        if ("percentage".equals(valueType)) {
            return new CssLookupValue(new PercentageUserLookup(), CssTermTypes.PERCENTAGE, CssTermTypes.NEGATIVE_PERCENTAGE);
        }
        if ("length".equals(valueType)) {
            return new CssLookupValue(new LengthUserLookup(), CssTermTypes.LENGTH, CssTermTypes.NUMBER, CssTermTypes.NEGATIVE_NUMBER, CssTermTypes.NEGATIVE_LENGTH);
        }
        if ("ref".equals(valueType)) {
            return new CssReferencePropertyValue();
        }
        if ("border-style".equals(valueType)) {
            return CssExpandedValue.createBorderStyleValue();
        }
        if ("border-width".equals(valueType)) {
            return new CssBorderWidthValue();
        }
        if ("angle".equals(valueType)) {
            return new CssLookupValue(new AngleUserLookup(), CssTermTypes.ANGLE, CssTermTypes.NUMBER);
        }
        if ("resolution".equals(valueType)) {
            return new CssLookupValue(new ResolutionUserLookup(), CssTermTypes.RESOLUTION, CssTermTypes.NUMBER);
        }
        if ("shape".equals(valueType)) {
            return new CssLookupValue(new ShapeUserLookup(), CssTermTypes.RECT, CssTermTypes.LENGTH);
        }
        if ("string".equals(valueType)) {
            return new CssStringPropertyValue((Object)e.getText());
        }
        if ("generic-font-family".equals(valueType)) {
            return CssExpandedValue.createGenericFontFamilyValue();
        }
        if ("font-family".equals(valueType)) {
            return new CssFontFamilyValue();
        }
        if ("absolute-size".equals(valueType)) {
            return CssExpandedValue.createAbsoluteSizeValue();
        }
        if ("relative-size".equals(valueType)) {
            return CssExpandedValue.createRelativeSizeValue();
        }
        if ("frequency".equals(valueType)) {
            return new CssLookupValue(new FrequencyUserLookup(), CssTermTypes.FREQUENCY, CssTermTypes.NUMBER);
        }
        if ("margin-width".equals(valueType)) {
            return new CssMarginWidthValue(true);
        }
        if ("padding-width".equals(valueType)) {
            return new CssMarginWidthValue(false);
        }
        if ("integer".equals(valueType)) {
            return new CssLookupValue(new IntegerUserLookup(), CssTermTypes.NEGATIVE_NUMBER, CssTermTypes.NUMBER);
        }
        if ("counter".equals(valueType)) {
            return new CssLookupValue(new CounterUserLookup(), CssTermTypes.COUNTER);
        }
        if ("time".equals(valueType)) {
            return new CssLookupValue(new TimeUserLookup(), CssTermTypes.TIME);
        }
        if ("identifier".equals(valueType)) {
            return new CssPropertyValueImpl(e.getText()){

                public boolean isValueBelongs(@Nullable PsiElement element) {
                    return true;
                }
            };
        }
        if ("overflow".equals(valueType)) {
            return CssExpandedValue.createOverflowValue();
        }
        if ("function".equals(valueType)) {
            String functionName = e.getAttributeValue("function-name");
            assert (functionName != null) : "function name is not specified for property " + propertyName;
            return new CssFunctionPropertyValue(functionName, false);
        }
        if ("optional-function".equals(valueType)) {
            String functionName = e.getAttributeValue("function-name");
            assert (functionName != null) : "function name is not specified for property " + propertyName;
            return new CssFunctionPropertyValue(functionName, true);
        }
        if ("image".equals(valueType)) {
            return new CssImageValue();
        }
        return new CssPropertyValueImpl((Object)e.getText());
    }

    private static CssPropertyValueImpl createValues(@NotNull String propertyName, Element @NotNull [] elements) {
        if (propertyName == null) {
            CssElementDescriptorFactory.$$$reportNull$$$0(13);
        }
        if (elements == null) {
            CssElementDescriptorFactory.$$$reportNull$$$0(14);
        }
        if (elements.length == 1) {
            return CssElementDescriptorFactory.createValues(propertyName, elements[0], null);
        }
        CssPropertyValueImpl value = new CssPropertyValueImpl((Object)"");
        value.setType(CssTableValue.Type.OR);
        for (Element element : elements) {
            CssElementDescriptorFactory.createValues(propertyName, element, value);
        }
        return value;
    }

    private static CssPropertyValueImpl createValues(@NotNull String propertyName, @NotNull Element e, @Nullable CssPropertyValueImpl parent) {
        String refName;
        if (propertyName == null) {
            CssElementDescriptorFactory.$$$reportNull$$$0(15);
        }
        if (e == null) {
            CssElementDescriptorFactory.$$$reportNull$$$0(16);
        }
        CssPropertyValueImpl value = CssElementDescriptorFactory.createValue(propertyName, e);
        value.setComplete(e.getAttributeValue("donotcomplete") == null);
        if (parent != null) {
            parent.addChild((CssTableValue)value);
        }
        String min = e.getAttributeValue("min");
        String max = e.getAttributeValue("max");
        String type = e.getAttributeValue("type");
        if (min != null && max != null) {
            value.setMinCount(Integer.parseInt(min));
            value.setMaxCount(Integer.parseInt(max));
        }
        if (type != null) {
            value.setType(CssTableValue.Type.valueOf((String)StringUtil.toUpperCase((String)type)));
        }
        value.setPrefix(e.getAttributeValue("prefix"));
        value.setHasImmutablePrefix(Boolean.parseBoolean(e.getAttributeValue("immutable-name-prefix")));
        String valuesDelimiter = e.getAttributeValue("values-delimiter");
        if (valuesDelimiter != null) {
            value.setValuesDelimiter(valuesDelimiter);
        }
        if ((refName = e.getAttributeValue("refname")) != null) {
            value.setRefName(refName);
        }
        List children = e.getChildren();
        for (Element child : children) {
            CssElementDescriptorFactory.createValues(propertyName, child, value);
        }
        return value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesDescriptionMap";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptions";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "reload";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDescriptorsMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildDescriptorsMap";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptors";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doLoadDescriptors";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createValues";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16 -> new IllegalArgumentException(string);
        };
    }

    private static final class MyCssPropertyXmlDescription {
        final Element myElement;
        final CssElementDescriptor.CssVersion myVersion;

        private MyCssPropertyXmlDescription(@NotNull Element element, @NotNull CssElementDescriptor.CssVersion version) {
            if (element == null) {
                MyCssPropertyXmlDescription.$$$reportNull$$$0(0);
            }
            if (version == null) {
                MyCssPropertyXmlDescription.$$$reportNull$$$0(1);
            }
            this.myElement = element;
            this.myVersion = version;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "version";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/impl/util/table/CssElementDescriptorFactory$MyCssPropertyXmlDescription";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

