/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.javaee.appServers.run.localRun.ExecutableObject;
import com.intellij.javaee.oss.AppServersCommonBundle;
import com.intellij.javaee.oss.server.WslSupportUtil;
import com.intellij.javaee.oss.server.WslSupportUtilKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.BaseOutputReader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class WslStartupExecutable
implements ExecutableObject {
    private final File myScriptFile;
    private final String myScriptCommand;
    private final List<String> myCustomOptions;
    private final Project myProject;
    @NotNull
    @Nls
    private final String myScriptName;

    public WslStartupExecutable(File scriptFile, String scriptCommand, List<String> customOptions, Project project, @NotNull @Nls String scriptName) {
        if (scriptName == null) {
            WslStartupExecutable.$$$reportNull$$$0(0);
        }
        this.myScriptFile = scriptFile;
        this.myScriptCommand = scriptCommand;
        this.myProject = project;
        this.myCustomOptions = new ArrayList<String>(customOptions);
        this.myCustomOptions.addAll(List.of("-Djava.net.preferIPv4Stack=true", "-Djava.net.preferIPv6Addresses=false"));
        this.myScriptName = scriptName;
    }

    @Nls
    public String getDisplayString() {
        return this.myScriptName;
    }

    public OSProcessHandler createProcessHandler(String workingDirectory, Map<String, String> envVariables) throws ExecutionException {
        String scriptPath = this.myScriptFile.getAbsolutePath();
        String wslDistributionName = WslSupportUtil.getWslDistributionName(scriptPath);
        if (wslDistributionName == null) {
            Logger.getInstance(WslStartupExecutable.class).warn("Failed to get WSL distribution name");
            throw new ExecutionException(AppServersCommonBundle.message("wsl.distribution.detection.error", new Object[0]));
        }
        List<String> patchedCustomJavaOptions = WslSupportUtil.toWslJavaOpts(scriptPath, this.myCustomOptions);
        String patchedJavaOpts = WslSupportUtil.patchJavaOpts(scriptPath, envVariables.get("JAVA_OPTS"));
        String combinedJavaOpts = WslSupportUtilKt.combineJavaOpts(patchedJavaOpts, patchedCustomJavaOptions);
        if (!combinedJavaOpts.isEmpty()) {
            envVariables.put("JAVA_OPTS", combinedJavaOpts);
        }
        Object[] commands = new String[]{WslSupportUtil.fromWslToLinuxPath(scriptPath)};
        if (StringUtil.isNotEmpty((String)this.myScriptCommand)) {
            commands = (String[])ArrayUtil.append((Object[])commands, (Object)this.myScriptCommand);
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine((String[])commands).withEnvironment(this.patchEnvVariables(envVariables, scriptPath));
        GeneralCommandLine wslCommandLine = WslDistributionManager.getInstance().getOrCreateDistributionByMsId(wslDistributionName).patchCommandLine(generalCommandLine, this.myProject, new WSLCommandLineOptions().setExecuteCommandInLoginShell(false));
        return (OSProcessHandler)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> new KillableColoredProcessHandler(wslCommandLine){

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
                if (options == null) {
                    1.$$$reportNull$$$0(0);
                }
                return options;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/server/WslStartupExecutable$1", "readerOptions"));
            }
        }, AppServersCommonBundle.message("dialog.title.starting", new Object[0]), true, this.myProject);
    }

    protected Map<String, String> patchEnvVariables(Map<String, String> envVariables, String scriptPath) {
        return WslSupportUtil.patchWslJavaHome(envVariables, scriptPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptName", "com/intellij/javaee/oss/server/WslStartupExecutable", "<init>"));
    }
}

