/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.breakpoints;

import com.intellij.javascript.debugger.JavaScriptLineBreakpointManager;
import com.intellij.javascript.debugger.scripts.VmScriptFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Vm;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\b&\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B#\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J\u001c\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0002H$J\u001c\u0010\u0012\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00162\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/javascript/debugger/breakpoints/JSLineBreakpointHandlerBase;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "breakpointTypeClass", "Ljava/lang/Class;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "manager", "Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager;", "<init>", "(Ljava/lang/Class;Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager;)V", "getManager", "()Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager;", "registerBreakpoint", "", "breakpoint", "doRegisterBreakpoint", "vm", "Lorg/jetbrains/debugger/Vm;", "unregisterBreakpoint", "temporary", "", "getVMsOfBreakpoint", "", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nJSLineBreakpointHandlerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLineBreakpointHandlerBase.kt\ncom/intellij/javascript/debugger/breakpoints/JSLineBreakpointHandlerBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n1869#2,2:34\n1869#2,2:36\n*S KotlinDebug\n*F\n+ 1 JSLineBreakpointHandlerBase.kt\ncom/intellij/javascript/debugger/breakpoints/JSLineBreakpointHandlerBase\n*L\n16#1:34,2\n24#1:36,2\n*E\n"})
public abstract class JSLineBreakpointHandlerBase
extends XBreakpointHandler<XLineBreakpoint<?>> {
    @NotNull
    private final JavaScriptLineBreakpointManager manager;

    public JSLineBreakpointHandlerBase(@NotNull Class<? extends XLineBreakpointType<?>> breakpointTypeClass, @NotNull JavaScriptLineBreakpointManager manager) {
        Intrinsics.checkNotNullParameter(breakpointTypeClass, (String)"breakpointTypeClass");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        super(breakpointTypeClass);
        this.manager = manager;
    }

    @NotNull
    public final JavaScriptLineBreakpointManager getManager() {
        return this.manager;
    }

    public void registerBreakpoint(@NotNull XLineBreakpoint<?> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        Iterable $this$forEach$iv = this.getVMsOfBreakpoint(breakpoint);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Vm it = (Vm)element$iv;
            boolean bl = false;
            this.doRegisterBreakpoint(it, breakpoint);
        }
    }

    protected abstract void doRegisterBreakpoint(@NotNull Vm var1, @NotNull XLineBreakpoint<?> var2);

    public void unregisterBreakpoint(@NotNull XLineBreakpoint<?> breakpoint, boolean temporary) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        Iterable $this$forEach$iv = this.getVMsOfBreakpoint(breakpoint);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Vm it = (Vm)element$iv;
            boolean bl = false;
            this.manager.removeBreakpoint(it, breakpoint, temporary);
        }
    }

    private final List<Vm> getVMsOfBreakpoint(XLineBreakpoint<?> breakpoint) {
        XSourcePosition xSourcePosition = breakpoint.getSourcePosition();
        VirtualFile file = xSourcePosition != null ? xSourcePosition.getFile() : null;
        return file instanceof VmScriptFile ? CollectionsKt.listOf((Object)((VmScriptFile)file).getScript().getVm()) : this.manager.getDebugProcess$intellij_javascript_debugger_backend().getCollectVMs();
    }
}

