/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.console.Node;
import com.intellij.javascript.debugger.console.StylesConversionKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.SimpleColoredText;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javascript/debugger/console/Variable;", "Lcom/intellij/javascript/debugger/console/Node;", "text", "", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "variable", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode;", "coloredText", "Lcom/intellij/ui/SimpleColoredText;", "<init>", "(Ljava/lang/String;Lcom/intellij/execution/ui/ConsoleViewContentType;Lcom/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode;Lcom/intellij/ui/SimpleColoredText;)V", "getVariable", "()Lcom/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode;", "hasIcon", "", "getJSType", "getJSProps", "", "", "getJSStyles", "", "getIcon", "Ljavax/swing/Icon;", "intellij.javascript.debugger.backend"})
public final class Variable
extends Node {
    @NotNull
    private final XDebuggerTreeNode variable;

    public Variable(@NotNull String text, @NotNull ConsoleViewContentType contentType, @NotNull XDebuggerTreeNode variable, @Nullable SimpleColoredText coloredText) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        super(text, contentType, coloredText);
        this.variable = variable;
    }

    public /* synthetic */ Variable(String string, ConsoleViewContentType consoleViewContentType, XDebuggerTreeNode xDebuggerTreeNode, SimpleColoredText simpleColoredText, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            simpleColoredText = null;
        }
        this(string, consoleViewContentType, xDebuggerTreeNode, simpleColoredText);
    }

    @NotNull
    public final XDebuggerTreeNode getVariable() {
        return this.variable;
    }

    @Override
    public boolean hasIcon() {
        return (Boolean)ActionsKt.runReadAction(() -> Variable.hasIcon$lambda$0(this));
    }

    @Override
    @NotNull
    public String getJSType() {
        return this.variable instanceof MessageTreeNode ? "message-tree-node" : (!this.variable.isLeaf() ? "tree" : (this.variable.getLink() != null ? "tree-link" : "text"));
    }

    @Override
    @NotNull
    public Map<String, Object> getJSProps() {
        Map<String, Object> jsProps;
        block0: {
            jsProps = super.getJSProps();
            jsProps.put("styleClasses", this.getJSStyles());
            XDebuggerTreeNodeHyperlink xDebuggerTreeNodeHyperlink = this.variable.getLink();
            if (xDebuggerTreeNodeHyperlink == null) break block0;
            XDebuggerTreeNodeHyperlink link = xDebuggerTreeNodeHyperlink;
            boolean bl = false;
            Object object = jsProps.get("text");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.String>");
            List list = TypeIntrinsics.asMutableList((Object)object);
            String string = link.getLinkText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLinkText(...)");
            list.add(string);
            Object object2 = jsProps.get("inlineStyles");
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.String>");
            List list2 = TypeIntrinsics.asMutableList((Object)object2);
            TextAttributes textAttributes = link.getTextAttributes().toTextAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"toTextAttributes(...)");
            list2.add(StylesConversionKt.textAttributesToInlineCss(textAttributes));
        }
        return jsProps;
    }

    private final List<String> getJSStyles() {
        return Intrinsics.areEqual((Object)this.getJSType(), (Object)"text") ? CollectionsKt.listOf((Object)StylesConversionKt.getSelectorName(this.getContentType())) : CollectionsKt.emptyList();
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return (Icon)ActionsKt.runReadAction(() -> Variable.getIcon$lambda$0(this));
    }

    private static final boolean hasIcon$lambda$0(Variable this$0) {
        return this$0.variable.getIcon() != null;
    }

    private static final Icon getIcon$lambda$0(Variable this$0) {
        return this$0.variable.getIcon();
    }
}

