/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.ide.browsers.impl.WebBrowserServiceImpl;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfigurationProducerKt;
import com.intellij.javascript.debugger.execution.JavaScriptDebugSettingsEditor;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.UriUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.URLUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.xml.util.HtmlUtil;
import java.net.URI;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.io.LocalFileFinder;

public class JavaScriptDebugConfiguration
extends LocatableConfigurationBase
implements RefactoringListenerProvider,
RunProfileWithCompileBeforeLaunchOption,
RunConfigurationWithSuppressedDefaultRunAction {
    private static final boolean USE_FIRST_LINE_BREAKPOINTS_DEFAULT = false;
    private String uri;
    private String engineId;
    private boolean useFirstLineBreakpoints;
    private boolean useBuiltInWebServerPort;
    private boolean allowSourceMapHeavyProcessing;
    @Property(surroundWithTag=false)
    @XCollection
    private List<RemoteUrlMappingBean> mappings;

    public JavaScriptDebugConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, String name) {
        if (project == null) {
            JavaScriptDebugConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            JavaScriptDebugConfiguration.$$$reportNull$$$0(1);
        }
        super(project, factory, name);
        this.useFirstLineBreakpoints = false;
        this.useBuiltInWebServerPort = false;
        this.allowSourceMapHeavyProcessing = true;
        this.mappings = new SmartList();
    }

    @Attribute
    @Nullable
    public String getUri() {
        Url url;
        String authority;
        if (this.useBuiltInWebServerPort && this.uri != null && (authority = (url = Urls.newFromIdea((CharSequence)this.uri)).getAuthority()) != null) {
            String updatedAuthority = "localhost:" + BuiltInServerOptions.getInstance().getEffectiveBuiltInServerPort();
            return this.uri.replace(authority, updatedAuthority);
        }
        return this.uri;
    }

    public void setUri(@Nullable String value) {
        this.uri = StringUtil.isEmptyOrSpaces((String)value) ? null : value.trim();
        this.useBuiltInWebServerPort = JavaScriptDebugConfiguration.usesBuiltInServerPort(this.uri);
    }

    private static boolean usesBuiltInServerPort(String uri) {
        if (uri == null) {
            return false;
        }
        Url url = Urls.newFromIdea((CharSequence)uri);
        if (url.getAuthority() == null) {
            return false;
        }
        String p = StringUtil.substringAfter((String)url.getAuthority(), (String)"localhost:");
        if (p == null) {
            return false;
        }
        try {
            int port = Integer.parseInt(p);
            if (port == BuiltInServerOptions.getInstance().getEffectiveBuiltInServerPort()) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    @NotNull
    public List<RemoteUrlMappingBean> getMappings() {
        List<RemoteUrlMappingBean> list = this.mappings;
        if (list == null) {
            JavaScriptDebugConfiguration.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void setMappings(@NotNull List<RemoteUrlMappingBean> mappings) {
        if (mappings == null) {
            JavaScriptDebugConfiguration.$$$reportNull$$$0(3);
        }
        this.mappings = mappings;
    }

    @Attribute
    @Nullable
    public String getEngineId() {
        return this.engineId;
    }

    public void setEngineId(@Nullable String browserId) {
        this.engineId = StringUtil.nullize((String)browserId);
    }

    @Attribute
    public boolean isUseFirstLineBreakpoints() {
        return this.useFirstLineBreakpoints;
    }

    public void setUseFirstLineBreakpoints(boolean useFirstLineBreakpoints) {
        this.useFirstLineBreakpoints = useFirstLineBreakpoints;
    }

    @Attribute
    public boolean isUseBuiltInWebServerPort() {
        return this.useBuiltInWebServerPort;
    }

    public void setUseBuiltInWebServerPort(boolean useBuiltInWebServerPort) {
        this.useBuiltInWebServerPort = useBuiltInWebServerPort;
    }

    public boolean isAllowSourceMapHeavyProcessing() {
        return this.allowSourceMapHeavyProcessing;
    }

    public void setAllowSourceMapHeavyProcessing(boolean allowSourceMapHeavyProcessing) {
        this.allowSourceMapHeavyProcessing = allowSourceMapHeavyProcessing;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new JavaScriptDebugSettingsEditor(this.getProject());
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (StringUtil.isEmptyOrSpaces((String)this.uri)) {
            throw new RuntimeConfigurationError(JSDebuggerBundle.message("javascript.debugger.url.is.not.specified", new Object[0]));
        }
        if (URLUtil.containsScheme((String)this.uri)) {
            return;
        }
        VirtualFile file = LocalFileFinder.findFile((String)VirtualFileManager.extractPath((String)UriUtil.trimParameters((String)this.uri)));
        if (file == null) {
            throw new RuntimeConfigurationError(JSDebuggerBundle.message("javascript.debugger.file.not.found", new Object[0]));
        }
        if (!HtmlUtil.isHtmlFile((VirtualFile)file)) {
            throw new RuntimeConfigurationError(JSDebuggerBundle.message("javascript.debugger.file.not.html", new Object[0]));
        }
    }

    @Nullable
    public String suggestedName() {
        String fromPath;
        if (StringUtil.isEmpty((String)this.uri)) {
            return null;
        }
        URI parsedURI = Urls.parseAsJavaUriWithoutParameters((String)this.uri);
        if (parsedURI != null && !(fromPath = PathUtil.getFileName((String)parsedURI.getPath())).isBlank()) {
            return fromPath;
        }
        return PathUtil.getFileName((String)this.uri);
    }

    public RunConfiguration clone() {
        JavaScriptDebugConfiguration configuration = (JavaScriptDebugConfiguration)super.clone();
        configuration.uri = this.uri;
        configuration.engineId = this.engineId;
        configuration.mappings = new SmartList(this.mappings);
        configuration.useFirstLineBreakpoints = this.useFirstLineBreakpoints;
        configuration.useBuiltInWebServerPort = this.useBuiltInWebServerPort;
        configuration.allowSourceMapHeavyProcessing = this.allowSourceMapHeavyProcessing;
        return configuration;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            JavaScriptDebugConfiguration.$$$reportNull$$$0(4);
        }
        if (environment == null) {
            JavaScriptDebugConfiguration.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmptyOrSpaces((String)this.uri)) {
            throw new ExecutionException(JSDebuggerBundle.message("javascript.debugger.url.is.not.specified", new Object[0]));
        }
        return EmptyRunProfileState.INSTANCE;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            JavaScriptDebugConfiguration.$$$reportNull$$$0(6);
        }
        super.readExternal(element);
        String uri = element.getAttributeValue("uri");
        this.setUri(uri);
        String updateWebServerPortValue = element.getAttributeValue("useBuiltInWebServerPort");
        this.useBuiltInWebServerPort = updateWebServerPortValue != null ? Boolean.parseBoolean(updateWebServerPortValue) : false;
        this.engineId = StringUtil.nullize((String)element.getAttributeValue("engineId"));
        for (Element mapping : element.getChildren("mapping")) {
            String remote = StringUtil.nullize((String)mapping.getAttributeValue("url"));
            String local = StringUtil.nullize((String)mapping.getAttributeValue("local-file"));
            if (local == null || remote == null) continue;
            this.mappings.add(new RemoteUrlMappingBean(local, remote));
        }
        String useFirstLineBreakpointsValue = element.getAttributeValue("useFirstLineBreakpoints");
        if (useFirstLineBreakpointsValue != null) {
            this.useFirstLineBreakpoints = Boolean.parseBoolean(useFirstLineBreakpointsValue);
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            JavaScriptDebugConfiguration.$$$reportNull$$$0(7);
        }
        super.writeExternal(element);
        JavaScriptDebugConfiguration.serialize(this, element);
    }

    public static void serialize(JavaScriptDebugConfiguration settings, Element element) {
        if (!StringUtil.isEmpty((String)settings.engineId)) {
            element.setAttribute("engineId", settings.engineId);
        }
        if (!StringUtil.isEmpty((String)settings.uri)) {
            element.setAttribute("uri", settings.uri);
        }
        for (RemoteUrlMappingBean mapping : settings.mappings) {
            if (StringUtil.isEmpty((String)mapping.getRemoteUrl()) || StringUtil.isEmpty((String)mapping.localFilePath)) continue;
            Element tag = new Element("mapping");
            tag.setAttribute("url", mapping.getRemoteUrl());
            tag.setAttribute("local-file", mapping.localFilePath);
            element.addContent(tag);
        }
        if (settings.useFirstLineBreakpoints) {
            element.setAttribute("useFirstLineBreakpoints", Boolean.toString(settings.useFirstLineBreakpoints));
        }
        if (settings.useBuiltInWebServerPort) {
            element.setAttribute("useBuiltInWebServerPort", "true");
        }
        if (!settings.allowSourceMapHeavyProcessing) {
            element.setAttribute("allowSourceMapHeavyProcessing", "false");
        }
    }

    public boolean isBuildBeforeLaunchAddedByDefault() {
        return false;
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (this.uri == null || !JavaScriptDebugConfigurationProducerKt.isConfigurationFromContext(this, element)) {
            return null;
        }
        return new UndoRefactoringElementAdapter(){

            protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
                Url url;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((url = WebBrowserServiceImpl.getDebuggableUrl((PsiElement)element)) != null) {
                    JavaScriptDebugConfiguration.this.uri = url.toDecodedForm();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/debugger/execution/JavaScriptDebugConfiguration$1", "refactored"));
            }
        };
    }

    public String toString() {
        return super.toString() + ", uri: " + this.uri + ", engine: " + this.engineId + ", useFirstLineBreakpoint = " + this.useFirstLineBreakpoints;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/debugger/execution/JavaScriptDebugConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/debugger/execution/JavaScriptDebugConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setMappings";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

