/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.platform.impl.database;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.JavaeeIcons;
import com.intellij.javaee.appServers.appServerIntegrations.AppServerDataSourceProvider;
import com.intellij.javaee.appServers.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServers.run.execution.JavaeeConsoleView;
import com.intellij.javaee.appServers.serverInstances.J2EEServerInstance;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

final class DataSourceAddFromServerAction
extends AnAction {
    DataSourceAddFromServerAction() {
        super(DatabaseBundle.messagePointer((String)"action.name.import.data.sources", (Object[])new Object[]{"server"}), DatabaseBundle.messagePointer((String)"action.description.import.data.sources", (Object[])new Object[]{"server"}), JavaeeIcons.DATASOURCE_REMOTE_INSTANCE);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DataSourceAddFromServerAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DataSourceAddFromServerAction.$$$reportNull$$$0(1);
        }
        JavaeeConsoleView consoleView = (JavaeeConsoleView)e.getData(JavaeeConsoleView.KEY);
        Presentation presentation = e.getPresentation();
        if (consoleView != null) {
            AppServerIntegration integration = consoleView.getIntegration();
            AppServerDataSourceProvider provider = integration.getDataSourceProvider();
            ProcessHandler processHandler = consoleView.getProcessHandler();
            presentation.setVisible(provider != null);
            presentation.setEnabled(processHandler.isStartNotified() && !processHandler.isProcessTerminating() && !processHandler.isProcessTerminated());
            presentation.setText(DatabaseBundle.messagePointer((String)"action.name.import.data.sources", (Object[])new Object[]{integration.getPresentableName()}));
            presentation.setDescription(DatabaseBundle.messagePointer((String)"action.description.import.data.sources", (Object[])new Object[]{integration.getPresentableName()}));
        } else {
            presentation.setEnabledAndVisible(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        JavaeeConsoleView consoleView;
        if (e == null) {
            DataSourceAddFromServerAction.$$$reportNull$$$0(2);
        }
        if ((consoleView = (JavaeeConsoleView)e.getData(JavaeeConsoleView.KEY)) == null) {
            return;
        }
        AppServerDataSourceProvider dataSourceProvider = consoleView.getIntegration().getDataSourceProvider();
        if (dataSourceProvider == null) {
            return;
        }
        J2EEServerInstance serverInstance = consoleView.getServerInstance();
        Project project = serverInstance.getCommonModel().getProject();
        if (!serverInstance.isConnected()) {
            Messages.showErrorDialog((Project)project, (String)J2EEBundle.message((String)"DataSourceAddFromServerAction.server.is.not.connected", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        DataSourceAddFromServerAction.importDataSources(project, dataSourceProvider, serverInstance);
    }

    public static void importDataSources(final @NotNull Project project, final @NotNull AppServerDataSourceProvider dataSourceProvider, final @NotNull J2EEServerInstance serverInstance) {
        if (project == null) {
            DataSourceAddFromServerAction.$$$reportNull$$$0(3);
        }
        if (dataSourceProvider == null) {
            DataSourceAddFromServerAction.$$$reportNull$$$0(4);
        }
        if (serverInstance == null) {
            DataSourceAddFromServerAction.$$$reportNull$$$0(5);
        }
        final DataSourceRegistry registry = new DataSourceRegistry(project);
        Task.Backgroundable task = new Task.Backgroundable(project, DatabaseBundle.message((String)"message.text.refreshing.data.source", (Object[])new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                dataSourceProvider.loadDataSourcesFromServer(serverInstance, registry.getBuilder());
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (registry.isEmpty()) {
                        Messages.showMessageDialog((Project)project, (String)DatabaseBundle.message((String)"message.import.datasources.nothing.found", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"dialog.title.import.datasources", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
                    } else {
                        registry.showDialog();
                    }
                }, project.getDisposed());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/javaee/platform/impl/database/DataSourceAddFromServerAction$1", "run"));
            }
        };
        task.queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/platform/impl/database/DataSourceAddFromServerAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/platform/impl/database/DataSourceAddFromServerAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "importDataSources";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

