/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.AopBundle;
import com.intellij.aop.psi.AopArrayExpression;
import com.intellij.aop.psi.AopBinaryExpression;
import com.intellij.aop.psi.AopElementTypes;
import com.intellij.aop.psi.AopGenericTypeExpression;
import com.intellij.aop.psi.AopNotExpression;
import com.intellij.aop.psi.AopParameterList;
import com.intellij.aop.psi.AopReferenceHolder;
import com.intellij.aop.psi.AopSubtypeExpression;
import com.intellij.aop.psi.AopTypeParameterList;
import com.intellij.aop.psi.PsiArgsExpression;
import com.intellij.aop.psi.PsiExecutionExpression;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.aop.psi.PsiTargetExpression;
import com.intellij.aop.psi.PsiThisExpression;
import com.intellij.aop.psi.PsiWithinExpression;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

final class AopAnnotator
implements Annotator {
    AopAnnotator() {
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        PsiPointcutExpression expression;
        if (psiElement == null) {
            AopAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            AopAnnotator.$$$reportNull$$$0(1);
        }
        PsiElement parent = psiElement.getParent();
        if (psiElement instanceof AopParameterList && !(parent instanceof PsiExecutionExpression)) {
            AopAnnotator.checkEllipsisAllowance(psiElement, holder);
        }
        if (psiElement instanceof AopArrayExpression) {
            if (((AopArrayExpression)psiElement).isVarargs()) {
                PsiElement[] parameters;
                if (!(parent instanceof AopReferenceHolder) || parent.getParent() instanceof AopTypeParameterList || parent.getParent() instanceof AopParameterList && parent.getParent().getParent() instanceof PsiArgsExpression) {
                    holder.newAnnotation(HighlightSeverity.ERROR, AopBundle.message("error.varargs.not.allowed.here", new Object[0])).range(psiElement.getLastChild()).create();
                    return;
                }
                if (parent.getParent() instanceof AopParameterList && parent != (parameters = ((AopParameterList)parent.getParent()).getParameters())[parameters.length - 1]) {
                    holder.newAnnotation(HighlightSeverity.ERROR, AopBundle.message("error.varargs.not.last", new Object[0])).range(psiElement.getLastChild()).create();
                    return;
                }
            }
            if ((expression = (PsiPointcutExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiPointcutExpression.class)) instanceof PsiThisExpression || expression instanceof PsiTargetExpression || expression instanceof PsiWithinExpression) {
                holder.newAnnotation(HighlightSeverity.ERROR, AopBundle.message("error.arrays.not.allowed.here", new Object[0])).range(psiElement.getLastChild()).create();
            }
        }
        if (psiElement instanceof AopGenericTypeExpression && ((expression = (PsiPointcutExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiPointcutExpression.class)) instanceof PsiThisExpression || expression instanceof PsiTargetExpression || expression instanceof PsiWithinExpression)) {
            holder.newAnnotation(HighlightSeverity.ERROR, AopBundle.message("error.generics.not.allowed.here", new Object[0])).range((PsiElement)((AopGenericTypeExpression)psiElement).getTypeParameterList()).create();
        }
        if ((psiElement instanceof AopSubtypeExpression || psiElement instanceof AopReferenceHolder && "*".equals(psiElement.getText())) && PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiArgsExpression.class) != null && PsiTreeUtil.getParentOfType((PsiElement)psiElement, AopTypeParameterList.class) != null && PsiTreeUtil.getParentOfType((PsiElement)psiElement, AopParameterList.class) != null) {
            holder.newAnnotation(HighlightSeverity.ERROR, AopBundle.message("error.wildcards.not.allowed.here", new Object[0])).range(psiElement.getLastChild()).create();
        } else if (!(psiElement.getContainingFile().getContext() instanceof XmlElement)) {
            AopAnnotator.checkAndOrNot(psiElement, holder);
        }
    }

    private static void checkEllipsisAllowance(PsiElement psiElement, AnnotationHolder holder) {
        AopParameterList list = (AopParameterList)psiElement;
        HashSet<PsiElement> ellipsises = new HashSet<PsiElement>();
        for (PsiElement parameter : list.getParameters()) {
            if (parameter.getNode().getElementType() != AopElementTypes.AOP_DOT_DOT) continue;
            ellipsises.add(parameter);
        }
        if (ellipsises.size() > 1) {
            for (PsiElement ellipsis : ellipsises) {
                holder.newAnnotation(HighlightSeverity.ERROR, AopBundle.message("error.double.ellipsis.prohibited", new Object[0])).range(ellipsis).create();
            }
        }
    }

    private static void checkAndOrNot(PsiElement psiElement, AnnotationHolder holder) {
        AopNotExpression expression;
        PsiElement token;
        if (psiElement instanceof AopBinaryExpression) {
            String text;
            PsiElement token2 = ((AopBinaryExpression)psiElement).getOpToken();
            if (token2 != null && ("and".equals(text = token2.getText()) || "or".equals(text))) {
                holder.newAnnotation(HighlightSeverity.ERROR, AopBundle.message("error.0.or.1.expected", "&&", "||")).range(token2).create();
            }
        } else if (psiElement instanceof AopNotExpression && "not".equals((token = (expression = (AopNotExpression)psiElement).getNotToken()).getText())) {
            holder.newAnnotation(HighlightSeverity.ERROR, AopBundle.message("error.0.expected", "!")).range(token).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/aop/psi/AopAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

