/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.NotPattern;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PsiAnnotatedTypePattern
extends AopPsiTypePattern {
    private final AopPsiTypePattern myAnnotationPattern;

    public PsiAnnotatedTypePattern(AopPsiTypePattern annotationPattern) {
        this.myAnnotationPattern = annotationPattern;
    }

    public AopPsiTypePattern getAnnotationPattern() {
        return this.myAnnotationPattern;
    }

    @Override
    public boolean accepts(@NotNull PsiType type) {
        PsiClass psiClass;
        if (type == null) {
            PsiAnnotatedTypePattern.$$$reportNull$$$0(0);
        }
        return type instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null && PsiAnnotatedTypePattern.acceptsAnnotationPattern((PsiModifierListOwner)psiClass, this.myAnnotationPattern, false);
    }

    public static boolean acceptsAnnotationPattern(@NotNull PsiModifierListOwner owner, AopPsiTypePattern annoPattern, boolean shoulBeInherited) {
        if (owner == null) {
            PsiAnnotatedTypePattern.$$$reportNull$$$0(1);
        }
        return PsiAnnotatedTypePattern.acceptsAnnotationPattern(owner, annoPattern, shoulBeInherited, new HashSet<PsiModifierListOwner>());
    }

    private static boolean acceptsAnnotationPattern(PsiModifierListOwner owner, AopPsiTypePattern annoPattern, boolean shoulBeInherited, Set<PsiModifierListOwner> visited) {
        visited.add(owner);
        if (annoPattern instanceof NotPattern) {
            return !PsiAnnotatedTypePattern.acceptsAnnotationPattern(owner, ((NotPattern)annoPattern).getInnerPattern(), shoulBeInherited);
        }
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                String qualifiedName;
                PsiElement psiElement;
                PsiJavaCodeReferenceElement element = annotation.getNameReferenceElement();
                if (element != null && (psiElement = element.resolve()) instanceof PsiClass) {
                    PsiClass annoClass = (PsiClass)psiElement;
                    if (annoPattern.accepts((PsiType)JavaPsiFacade.getInstance((Project)psiElement.getProject()).getElementFactory().createType(annoClass))) {
                        PsiModifierList list = annoClass.getModifierList();
                        return !shoulBeInherited || list != null && list.hasAnnotation("java.lang.annotation.Inherited");
                    }
                }
                if ((qualifiedName = annotation.getQualifiedName()) == null || !annoPattern.accepts(qualifiedName)) continue;
                return true;
            }
        }
        if (owner instanceof PsiClass) {
            PsiClass superClass = ((PsiClass)owner).getSuperClass();
            return superClass != null && !visited.contains(superClass) && PsiAnnotatedTypePattern.acceptsAnnotationPattern((PsiModifierListOwner)superClass, annoPattern, true);
        }
        return false;
    }

    @Override
    @NotNull
    public PointcutMatchDegree canBeAssignableFrom(@NotNull PsiType type) {
        if (type == null) {
            PsiAnnotatedTypePattern.$$$reportNull$$$0(2);
        }
        PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.valueOf(this.accepts(type));
        if (pointcutMatchDegree == null) {
            PsiAnnotatedTypePattern.$$$reportNull$$$0(3);
        }
        return pointcutMatchDegree;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/aop/psi/PsiAnnotatedTypePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/aop/psi/PsiAnnotatedTypePattern";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "canBeAssignableFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "acceptsAnnotationPattern";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canBeAssignableFrom";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

