/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    protected OraDialect() {
        super((TypeHelper)new TypeHelper.OraTypeHelper());
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.ORACLE;
        if (dbms == null) {
            OraDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @NotNull
    public String getDisplayName() {
        return "Oracle";
    }

    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            OraDialect.$$$reportNull$$$0(1);
        }
        if (StringUtil.toLowerCase((String)nativeColumnTypeName).equals("nvarchar2")) {
            return -9;
        }
        if (StringUtil.toLowerCase((String)nativeColumnTypeName).equals("nchar")) {
            return -15;
        }
        if (StringUtil.toLowerCase((String)nativeColumnTypeName).equals("nclob")) {
            return 2011;
        }
        if (StringUtil.toLowerCase((String)nativeColumnTypeName).startsWith("timestamp")) {
            return 93;
        }
        return super.getJavaTypeForNativeType(nativeColumnTypeName);
    }

    protected void sqlParameter(@NotNull DdlBuilder builder, DasArgument parameter, boolean longMode) {
        if (builder == null) {
            OraDialect.$$$reportNull$$$0(2);
        }
        DialectUtils.sqlParameter((DdlBuilder)builder, (DasArgument)parameter, (boolean)longMode, (int)1, (boolean)true);
    }

    public boolean supportsTableInfo() {
        return true;
    }

    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            OraDialect.$$$reportNull$$$0(3);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        String schema = this.getNamingService().catToScript(current.getDisplayName(), current.kind, this.getCodeStyle().getQuotesPriority());
        return String.format("alter session set current_schema = %s", schema);
    }

    public boolean supportsInsertInto() {
        return super.supportsInsertInto();
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (builder == null) {
            OraDialect.$$$reportNull$$$0(4);
        }
        if (identifier == null) {
            OraDialect.$$$reportNull$$$0(5);
        }
        if (qualifier == null) {
            OraDialect.$$$reportNull$$$0(6);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        String pkgName = qualifier instanceof DasRoutine ? ((DasRoutine)qualifier).getPackageName() : null;
        DasObject pkg = pkgName == null ? null : qualifier.getDasParent();
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, pkg, pkgName);
        if (ddlBuilder == null) {
            OraDialect.$$$reportNull$$$0(7);
        }
        return ddlBuilder;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnectionCore connection) throws Exception {
        if (element == null) {
            OraDialect.$$$reportNull$$$0(8);
        }
        if (connection == null) {
            OraDialect.$$$reportNull$$$0(9);
        }
        Dbms dbms = connection.getDbms();
        Map map = DbImplUtilCore.resultRowAsMap((DatabaseConnectionCore)connection, (String)String.format("SELECT NUM_ROWS as \"rows\",  TABLESPACE_NAME as \"tablespace\",  LAST_ANALYZED as \"analyzed on\" FROM SYS.all_tables WHERE owner LIKE '%s' ESCAPE '#' AND table_name LIKE '%s' ESCAPE '#'", DbImplUtilCore.escapeSql((Object)DasUtil.getSchema((DasObject)element), (boolean)true, (Dbms)dbms), DbImplUtilCore.escapeSql((Object)element.getName(), (boolean)true, (Dbms)dbms)));
        if (map == null) {
            OraDialect.$$$reportNull$$$0(10);
        }
        return map;
    }

    public SearchPath tryToLoadSearchPath(@NotNull DatabaseConnectionCore connection) throws SQLException {
        Dbms dbms;
        String s;
        if (connection == null) {
            OraDialect.$$$reportNull$$$0(11);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtilCore.concatStringResults((DatabaseConnectionCore)connection, (Dbms)(dbms = connection.getDbms()), (String)"select sys_context('userenv', 'current_schema') x from dual", (int)1, (DbImplUtilCore.ConcatenationProps)DbImplUtilCore.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    public boolean supportsQualifiedAsteriskInCalls() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 8, 9, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/OraDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeColumnTypeName";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/OraDialect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getJavaTypeForNativeType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 8, 9, 11 -> new IllegalArgumentException(string);
        };
    }
}

