/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.generator;

import com.intellij.database.dialects.base.generator.AbstractCodeGenerator;
import com.intellij.database.dialects.base.generator.BaseExecuteGenerator;
import com.intellij.database.dialects.base.generator.ElementProducer;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.oracle.generator.OraRoutineArgumentsAnalyzer;
import com.intellij.database.dialects.oracle.model.OraArgument;
import com.intellij.database.dialects.oracle.model.OraPackage;
import com.intellij.database.dialects.oracle.model.OraPackageBody;
import com.intellij.database.dialects.oracle.model.OraPackageRoutine;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.dialects.oracle.types.OraRefCursorType;
import com.intellij.database.dialects.oracle.types.OraTypeSystem;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicUserDefinedType;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasBuiltinTypeClass;
import com.intellij.database.types.DasBuiltinTypeWithLength;
import com.intellij.database.types.DasDefinedType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeUtilsKt;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003\u001d\u001e\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u0018*\u0006\u0012\u0002\b\u00030\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006 "}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator;", "Lcom/intellij/database/dialects/base/generator/BaseExecuteGenerator;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "<init>", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;)V", "makeExecuteOperation", "Lcom/intellij/database/dialects/base/generator/Operation;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "root", "makeExecutePackage", "Lcom/intellij/database/dialects/oracle/model/OraPackage;", "generateRoutine", "", "producer", "Lcom/intellij/database/dialects/base/generator/ElementProducer;", "Lcom/intellij/database/model/basic/BasicRoutine;", "argumentName", "", "argument", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "getTypeSpecification", "forcedPrecision", "", "Lcom/intellij/database/types/DasBuiltinTypeClass;", "guessDefaultValue", "dt", "Lcom/intellij/database/types/DasType;", "DataProducingWay", "AsResultSets", "DbmsOutput", "intellij.database.dialects.oracle"})
@SourceDebugExtension(value={"SMAP\nOraExecuteGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraExecuteGenerator.kt\ncom/intellij/database/dialects/oracle/generator/OraExecuteGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ScriptingContext.kt\ncom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter\n*L\n1#1,305:1\n1869#2,2:306\n77#3,4:308\n226#3,10:312\n81#3,2:322\n226#3,5:324\n77#3,4:329\n226#3,10:333\n81#3,2:343\n77#3,6:345\n231#3,5:351\n77#3,6:356\n*S KotlinDebug\n*F\n+ 1 OraExecuteGenerator.kt\ncom/intellij/database/dialects/oracle/generator/OraExecuteGenerator\n*L\n28#1:306,2\n59#1:308,4\n62#1:312,10\n59#1:322,2\n93#1:324,5\n105#1:329,4\n106#1:333,10\n105#1:343,2\n115#1:345,6\n93#1:351,5\n125#1:356,6\n*E\n"})
public final class OraExecuteGenerator
extends BaseExecuteGenerator {
    public OraExecuteGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    @Nullable
    public Operation makeExecuteOperation(@NotNull BasicElement element, @NotNull Operation root) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return element instanceof OraPackage ? this.makeExecutePackage((OraPackage)element, root) : super.makeExecuteOperation(element, root);
    }

    private final Operation makeExecutePackage(OraPackage element, Operation root) {
        ModNamingFamily<? extends OraPackageRoutine> modNamingFamily = element.getRoutines();
        Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getRoutines(...)");
        Iterable $this$forEach$iv = (Iterable)modNamingFamily;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OraPackageRoutine it = (OraPackageRoutine)element$iv;
            boolean bl = false;
            BaseExecuteGenerator baseExecuteGenerator = this;
            Intrinsics.checkNotNull((Object)it);
            BaseExecuteGenerator.prepareElement$default((BaseExecuteGenerator)baseExecuteGenerator, (BasicElement)((BasicElement)it), (Operation)root, (boolean)false, (int)4, null);
        }
        return null;
    }

    protected void generateRoutine(@NotNull ElementProducer<BasicRoutine> producer) {
        Object object;
        OraRoutine routine;
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        BasicElement basicElement = producer.getElement();
        Intrinsics.checkNotNull((Object)basicElement, (String)"null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraRoutine");
        OraRoutine oraRoutine = routine = (OraRoutine)basicElement;
        if (oraRoutine instanceof OraSingleRoutine) {
            object = AbstractCodeGenerator.currentScopeName$default((AbstractCodeGenerator)((AbstractCodeGenerator)this), (BasicElement)((BasicElement)routine), null, (int)1, null);
        } else if (oraRoutine instanceof OraPackageRoutine) {
            AbstractCodeGenerator abstractCodeGenerator = (AbstractCodeGenerator)this;
            OraPackage oraPackage = ((OraPackageRoutine)routine).getPackage();
            Intrinsics.checkNotNull((Object)oraPackage);
            object = AbstractCodeGenerator.currentScopeName$default((AbstractCodeGenerator)abstractCodeGenerator, (BasicElement)((BasicElement)oraPackage), null, (int)1, null) + "." + AbstractCodeGenerator.quote$default((AbstractCodeGenerator)((AbstractCodeGenerator)this), (BasicElement)((BasicElement)routine), null, (int)2, null);
        } else {
            return;
        }
        String callName = object;
        ModPositioningNamingFamily<? extends OraArgument> modPositioningNamingFamily = routine.getArguments();
        Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getArguments(...)");
        List arguments = CollectionsKt.toList((Iterable)((Iterable)modPositioningNamingFamily));
        int n = arguments.size();
        OraRoutineArgumentsAnalyzer analyzer = new OraRoutineArgumentsAnalyzer(routine);
        OraArgument ret = analyzer.getReturnArgument();
        List<OraArgument> cursors = analyzer.getCursorArguments();
        List<OraArgument> associative = analyzer.getAssociativeArrayArguments();
        List<OraArgument> sqlArrays = analyzer.getSqlTypeArrayArguments();
        List<OraArgument> plArrays = analyzer.getPlTypeArrayArguments();
        List<OraArgument> sqlTables = analyzer.getSqlTypeNestedTableArguments();
        List<OraArgument> plTables = analyzer.getPlTypeNestedTableArguments();
        List<OraRoutineArgumentsAnalyzer.PrimitivesPack> primitives = analyzer.getPrimitives(this.getContext().getTask().getVersion());
        DataProducingWay way = (Boolean)this.getContext().getOptions().get(ScriptingOptionStatic.CALL) != false ? (DataProducingWay)new AsResultSets(this) : (DataProducingWay)new DbmsOutput(this);
        this.newCoding(arg_0 -> OraExecuteGenerator.generateRoutine$lambda$0(n, arguments, this, ret, callName, way, plArrays, plTables, associative, cursors, sqlArrays, sqlTables, primitives, arg_0));
    }

    private final String argumentName(OraArgument argument) {
        return argument.getArgumentDirection() == ArgumentDirection.RETURN ? "result" : AbstractCodeGenerator.quote$default((AbstractCodeGenerator)((AbstractCodeGenerator)this), (BasicElement)((BasicElement)argument), null, (int)2, null);
    }

    private final String getTypeSpecification(OraArgument argument) {
        DasType dasType = argument.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        DasType dasType2 = DasTypeUtilsKt.unwrap$default((DasType)dasType, (boolean)false, (DasObject)((DasObject)argument), (int)1, null);
        if (dasType2 instanceof DasBuiltinType) {
            DasType resultType = dasType2;
            if (resultType instanceof DasBuiltinTypeWithLength && ((DasBuiltinTypeWithLength)resultType).getTypeClass().getCategory() == DasTypeCategory.STRING && ((DasBuiltinTypeWithLength)resultType).getLength() == -1) {
                DasBuiltinTypeWithLength dasBuiltinTypeWithLength = (DasBuiltinTypeWithLength)resultType;
                DasBuiltinTypeClass dasBuiltinTypeClass = ((DasBuiltinTypeWithLength)resultType).getTypeClass();
                Intrinsics.checkNotNullExpressionValue((Object)dasBuiltinTypeClass, (String)"getTypeClass(...)");
                DasBuiltinTypeWithLength dasBuiltinTypeWithLength2 = dasBuiltinTypeWithLength.copy(this.forcedPrecision(dasBuiltinTypeClass));
                Intrinsics.checkNotNullExpressionValue((Object)dasBuiltinTypeWithLength2, (String)"copy(...)");
                resultType = (DasType)dasBuiltinTypeWithLength2;
            }
            String string = ((DasBuiltinType)resultType).getSpecification();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSpecification(...)");
            return string;
        }
        if (dasType2 instanceof DasDefinedType) {
            DasUserDefinedType dasUserDefinedType = ((DasDefinedType)dasType2).getTypeClass().getDefinition();
            Intrinsics.checkNotNull((Object)dasUserDefinedType, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicUserDefinedType");
            BasicUserDefinedType definition = (BasicUserDefinedType)dasUserDefinedType;
            BasicElement parent = definition.getParent();
            return parent instanceof OraPackage || parent instanceof OraPackageBody ? AbstractCodeGenerator.currentScopeName$default((AbstractCodeGenerator)((AbstractCodeGenerator)this), (BasicElement)parent, null, (int)1, null) + "." + AbstractCodeGenerator.quote$default((AbstractCodeGenerator)((AbstractCodeGenerator)this), (BasicElement)((BasicElement)definition), null, (int)2, null) : AbstractCodeGenerator.currentScopeName$default((AbstractCodeGenerator)((AbstractCodeGenerator)this), (BasicElement)((BasicElement)definition), null, (int)1, null);
        }
        if (dasType2 instanceof OraRefCursorType) {
            return "sys_refcursor";
        }
        DasType dasType3 = argument.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType3, (String)"getDasType(...)");
        return this.script(dasType3);
    }

    private final int forcedPrecision(DasBuiltinTypeClass<?> $this$forcedPrecision) {
        DasBuiltinTypeClass dasBuiltinTypeClass = $this$forcedPrecision.getCanonical();
        return Intrinsics.areEqual((Object)dasBuiltinTypeClass, (Object)OraTypeSystem.CHAR.getTypeClass()) || Intrinsics.areEqual((Object)dasBuiltinTypeClass, (Object)OraTypeSystem.NCHAR.getTypeClass()) ? 50 : 4000;
    }

    private final String guessDefaultValue(DasType dt) {
        if (!(dt instanceof DasBuiltinType)) {
            return "null";
        }
        return switch (WhenMappings.$EnumSwitchMapping$1[((DasBuiltinType)dt).getTypeClass().getCategory().ordinal()]) {
            case 1, 2 -> "0";
            case 3 -> "sysdate";
            case 4 -> "''";
            default -> "null";
        };
    }

    private static final Unit generateRoutine$lambda$0(int $n, List $arguments, OraExecuteGenerator this$0, OraArgument $ret, String $callName, DataProducingWay $way, List $plArrays, List $plTables, List $associative, List $cursors, List $sqlArrays, List $sqlTables, List $primitives, ScriptingContext.NewCodingAdapter $this$newCoding) {
        Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$this$newCoding");
        ScriptingContext.NewCodingAdapter $this$iv = $this$newCoding;
        boolean nl$iv = true;
        boolean $i$f$withNewLines = false;
        boolean prev$iv = $this$iv.getStartWithNewLine();
        $this$iv.setStartWithNewLine(nl$iv);
        boolean bl = false;
        if (!((Collection)$arguments).isEmpty()) {
            $this$newCoding.unaryPlus((CharSequence)"declare");
            ScriptingContext.NewCodingAdapter this_$iv = $this$newCoding;
            boolean $i$f$indenting = false;
            boolean prev$iv2 = this_$iv.getOnNewLine();
            int length$iv = this_$iv.getBuilder().getLength();
            this_$iv.newLine();
            this_$iv.indent();
            boolean bl2 = false;
            for (OraArgument a : $arguments) {
                ArgumentDirection dir;
                Intrinsics.checkNotNullExpressionValue((Object)a.getArgumentDirection(), (String)"getArgumentDirection(...)");
                Intrinsics.checkNotNullExpressionValue((Object)a.getDasType(), (String)"getDasType(...)");
                Intrinsics.checkNotNull((Object)a);
                String specification = this$0.getTypeSpecification(a);
                String line = switch (WhenMappings.$EnumSwitchMapping$0[dir.ordinal()]) {
                    case 1, 2 -> {
                        DasType dt;
                        String defaultValue = this$0.guessDefaultValue(dt);
                        yield this$0.argumentName(a) + " " + specification + " := " + defaultValue + ";";
                    }
                    case 3, 4 -> this$0.argumentName(a) + " " + specification + ";";
                    default -> null;
                };
                $this$newCoding.unaryPlus((CharSequence)line);
            }
            this_$iv.unindent();
            if (length$iv == this_$iv.getBuilder().getLength()) {
                this_$iv.setOnNewLine(prev$iv2);
            }
        }
        $this$newCoding.unaryPlus((CharSequence)"begin");
        $this$iv.setStartWithNewLine(prev$iv);
        ArrayList<CallSite> passing = new ArrayList<CallSite>($n);
        for (OraArgument a : $arguments) {
            switch (WhenMappings.$EnumSwitchMapping$0[a.getArgumentDirection().ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    Intrinsics.checkNotNull((Object)a);
                    passing.add((CallSite)((Object)(this$0.argumentName(a) + " => " + this$0.argumentName(a))));
                }
            }
        }
        String retClause = $ret != null ? "result :=" : null;
        ScriptingContext.NewCodingAdapter this_$iv = $this$newCoding;
        boolean $i$f$indenting = false;
        boolean prev$iv3 = this_$iv.getOnNewLine();
        int length$iv = this_$iv.getBuilder().getLength();
        this_$iv.newLine();
        this_$iv.indent();
        boolean bl3 = false;
        $this$newCoding.unaryPlus((CharSequence)retClause);
        switch (passing.size()) {
            case 0: {
                ScriptingContext.NewCodingAdapter newCodingAdapter = $this$newCoding.unaryPlus((CharSequence)($callName + ";"));
                break;
            }
            case 1: {
                String passingText = (String)CollectionsKt.first((List)passing);
                ScriptingContext.NewCodingAdapter newCodingAdapter = $this$newCoding.unaryPlus((CharSequence)($callName + "(" + passingText + ");"));
                break;
            }
            default: {
                $this$newCoding.unaryPlus((CharSequence)($callName + "("));
                ScriptingContext.NewCodingAdapter $this$iv2 = $this$newCoding;
                boolean nl$iv2 = true;
                boolean $i$f$withNewLines2 = false;
                boolean prev$iv4 = $this$iv2.getStartWithNewLine();
                $this$iv2.setStartWithNewLine(nl$iv2);
                boolean bl4 = false;
                ScriptingContext.NewCodingAdapter this_$iv2 = $this$newCoding;
                boolean $i$f$indenting2 = false;
                boolean prev$iv5 = this_$iv2.getOnNewLine();
                int length$iv2 = this_$iv2.getBuilder().getLength();
                this_$iv2.newLine();
                this_$iv2.indent();
                boolean bl5 = false;
                Iterator iterator = ((Iterable)passing).iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int i2 = n++;
                    String p = (String)iterator.next();
                    $this$newCoding.unaryPlus((CharSequence)(i2 + 1 < passing.size() ? p + "," : p));
                }
                this_$iv2.unindent();
                if (length$iv2 == this_$iv2.getBuilder().getLength()) {
                    this_$iv2.setOnNewLine(prev$iv5);
                }
                $this$newCoding.unaryPlus((CharSequence)");");
                $this$iv2.setStartWithNewLine(prev$iv4);
                ScriptingContext.NewCodingAdapter newCodingAdapter = Unit.INSTANCE;
            }
        }
        ScriptingContext.NewCodingAdapter $this$iv3 = $this$newCoding;
        boolean nl$iv3 = true;
        boolean $i$f$withNewLines3 = false;
        boolean prev$iv6 = $this$iv3.getStartWithNewLine();
        $this$iv3.setStartWithNewLine(nl$iv3);
        boolean bl6 = false;
        $way.producePlArrays($this$newCoding, $plArrays);
        $way.producePlTables($this$newCoding, $plTables);
        $way.produceAssociativeArrays($this$newCoding, $associative);
        $way.produceCursors($this$newCoding, $cursors);
        $way.produceSqlArrays($this$newCoding, $sqlArrays);
        $way.produceSqlTables($this$newCoding, $sqlTables);
        $way.producePrimitives($this$newCoding, $primitives);
        $this$iv3.setStartWithNewLine(prev$iv6);
        this_$iv.unindent();
        if (length$iv == this_$iv.getBuilder().getLength()) {
            this_$iv.setOnNewLine(prev$iv3);
        }
        ScriptingContext.NewCodingAdapter $this$iv4 = $this$newCoding;
        boolean nl$iv4 = true;
        boolean $i$f$withNewLines4 = false;
        boolean prev$iv7 = $this$iv4.getStartWithNewLine();
        $this$iv4.setStartWithNewLine(nl$iv4);
        boolean bl7 = false;
        $this$newCoding.unaryPlus((CharSequence)"end;");
        $this$iv4.setStartWithNewLine(prev$iv7);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\"\u0010\u000e\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0016J\"\u0010\u0011\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0016J\"\u0010\u0013\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0016J\"\u0010\u0014\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0016J\"\u0010\u0015\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0016J\"\u0010\u0016\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator$AsResultSets;", "Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator$DataProducingWay;", "generator", "Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator;", "<init>", "(Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator;)V", "producePrimitives", "", "adapter", "Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "primitives", "", "Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$PrimitivesPack;", "produceCursors", "cursors", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "produceSqlArrays", "arrays", "producePlArrays", "produceSqlTables", "producePlTables", "produceAssociativeArrays", "associative", "commentMaybe", "", "intellij.database.dialects.oracle"})
    private static final class AsResultSets
    implements DataProducingWay {
        @NotNull
        private final OraExecuteGenerator generator;

        public AsResultSets(@NotNull OraExecuteGenerator generator) {
            Intrinsics.checkNotNullParameter((Object)((Object)generator), (String)"generator");
            this.generator = generator;
        }

        @Override
        public void producePrimitives(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<OraRoutineArgumentsAnalyzer.PrimitivesPack> primitives) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(primitives, (String)"primitives");
            if (primitives.isEmpty()) {
                return;
            }
            ScriptingContext.NewCodingAdapter $this$producePrimitives_u24lambda_u240 = newCodingAdapter = adapter;
            boolean bl = false;
            for (OraRoutineArgumentsAnalyzer.PrimitivesPack pack : primitives) {
                $this$producePrimitives_u24lambda_u240.plus($this$producePrimitives_u24lambda_u240.plus($this$producePrimitives_u24lambda_u240.unaryPlus((CharSequence)((pack.getEnabled() ? "" : "-- ") + "open ? for select ")), (CharSequence)CollectionsKt.joinToString$default((Iterable)pack.getArguments(), null, null, null, (int)0, null, arg_0 -> AsResultSets.producePrimitives$lambda$0$0(this, arg_0), (int)31, null)), (CharSequence)"from dual;");
            }
        }

        @Override
        public void produceCursors(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> cursors) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(cursors, (String)"cursors");
            ScriptingContext.NewCodingAdapter $this$produceCursors_u24lambda_u240 = newCodingAdapter = adapter;
            boolean bl = false;
            for (OraArgument oraArgument : cursors) {
                $this$produceCursors_u24lambda_u240.unaryPlus((CharSequence)("? := " + this.generator.argumentName(oraArgument) + ";"));
            }
        }

        @Override
        public void produceSqlArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            ScriptingContext.NewCodingAdapter $this$produceSqlArrays_u24lambda_u240 = newCodingAdapter = adapter;
            boolean bl = false;
            for (OraArgument oraArgument : arrays) {
                $this$produceSqlArrays_u24lambda_u240.unaryPlus((CharSequence)("open ? for select * from table(" + this.generator.argumentName(oraArgument) + ");"));
            }
        }

        @Override
        public void producePlArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            ScriptingContext.NewCodingAdapter $this$producePlArrays_u24lambda_u240 = newCodingAdapter = adapter;
            boolean bl = false;
            for (OraArgument oraArgument : arrays) {
                $this$producePlArrays_u24lambda_u240.unaryPlus((CharSequence)(this.commentMaybe() + "open ? for select * from table(" + this.generator.argumentName(oraArgument) + ");"));
            }
        }

        @Override
        public void produceSqlTables(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            ScriptingContext.NewCodingAdapter $this$produceSqlTables_u24lambda_u240 = newCodingAdapter = adapter;
            boolean bl = false;
            for (OraArgument oraArgument : arrays) {
                $this$produceSqlTables_u24lambda_u240.unaryPlus((CharSequence)("open ? for select * from table(" + this.generator.argumentName(oraArgument) + ");"));
            }
        }

        @Override
        public void producePlTables(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            ScriptingContext.NewCodingAdapter $this$producePlTables_u24lambda_u240 = newCodingAdapter = adapter;
            boolean bl = false;
            for (OraArgument oraArgument : arrays) {
                $this$producePlTables_u24lambda_u240.unaryPlus((CharSequence)(this.commentMaybe() + "open ? for select * from table(" + this.generator.argumentName(oraArgument) + ");"));
            }
        }

        @Override
        public void produceAssociativeArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> associative) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(associative, (String)"associative");
            ScriptingContext.NewCodingAdapter $this$produceAssociativeArrays_u24lambda_u240 = newCodingAdapter = adapter;
            boolean bl = false;
            for (OraArgument oraArgument : associative) {
                $this$produceAssociativeArrays_u24lambda_u240.unaryPlus((CharSequence)("-- open ? for select * from table(" + this.generator.argumentName(oraArgument) + ");"));
            }
        }

        private final String commentMaybe() {
            return OraRoutineArgumentsAnalyzer.Companion.supportPlTypesInSql(this.generator.getContext().getTask().getVersion()) ? "" : "-- ";
        }

        private static final CharSequence producePrimitives$lambda$0$0(AsResultSets this$0, OraArgument it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String argumentName = this$0.generator.argumentName(it);
            return argumentName + " as " + argumentName;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\bb\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH&J\"\u0010\n\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\bH&J\"\u0010\r\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\bH&J\"\u0010\u000f\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\bH&J\"\u0010\u0010\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\bH&J\"\u0010\u0011\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\bH&J\"\u0010\u0012\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0014\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator$DataProducingWay;", "", "producePrimitives", "", "adapter", "Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "primitives", "", "Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$PrimitivesPack;", "produceCursors", "cursors", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "produceSqlArrays", "arrays", "producePlArrays", "produceSqlTables", "producePlTables", "produceAssociativeArrays", "associative", "intellij.database.dialects.oracle"})
    private static interface DataProducingWay {
        public void producePrimitives(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<OraRoutineArgumentsAnalyzer.PrimitivesPack> var2);

        public void produceCursors(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);

        public void produceSqlArrays(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);

        public void producePlArrays(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);

        public void produceSqlTables(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);

        public void producePlTables(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);

        public void produceAssociativeArrays(@NotNull ScriptingContext.NewCodingAdapter var1, @NotNull List<? extends OraArgument> var2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\"\u0010\u000e\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0016J\"\u0010\u0011\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0016J\"\u0010\u0013\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0016J\"\u0010\u0014\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0016J\"\u0010\u0015\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0016J\"\u0010\u0016\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0016J\"\u0010\u0018\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0002J\"\u0010\u001a\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0002J*\u0010\u001a\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator$DbmsOutput;", "Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator$DataProducingWay;", "generator", "Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator;", "<init>", "(Lcom/intellij/database/dialects/oracle/generator/OraExecuteGenerator;)V", "producePrimitives", "", "adapter", "Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "primitives", "", "Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$PrimitivesPack;", "produceCursors", "cursors", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "produceSqlArrays", "arrays", "producePlArrays", "producePlTables", "produceSqlTables", "produceAssociativeArrays", "associative", "printCommented", "arguments", "print", "prefix", "", "intellij.database.dialects.oracle"})
    @SourceDebugExtension(value={"SMAP\nOraExecuteGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraExecuteGenerator.kt\ncom/intellij/database/dialects/oracle/generator/OraExecuteGenerator$DbmsOutput\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,305:1\n1374#2:306\n1460#2,5:307\n774#2:312\n865#2,2:313\n774#2:315\n865#2,2:316\n*S KotlinDebug\n*F\n+ 1 OraExecuteGenerator.kt\ncom/intellij/database/dialects/oracle/generator/OraExecuteGenerator$DbmsOutput\n*L\n258#1:306\n258#1:307,5\n259#1:312\n259#1:313,2\n260#1:315\n260#1:316,2\n*E\n"})
    private static final class DbmsOutput
    implements DataProducingWay {
        @NotNull
        private final OraExecuteGenerator generator;

        public DbmsOutput(@NotNull OraExecuteGenerator generator) {
            Intrinsics.checkNotNullParameter((Object)((Object)generator), (String)"generator");
            this.generator = generator;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void producePrimitives(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<OraRoutineArgumentsAnalyzer.PrimitivesPack> primitives) {
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object it;
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(primitives, (String)"primitives");
            Iterable $this$flatMap$iv = primitives;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (OraRoutineArgumentsAnalyzer.PrimitivesPack)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = ((OraRoutineArgumentsAnalyzer.PrimitivesPack)it).getArguments();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List arguments = (List)destination$iv$iv;
            $this$flatMap$iv = arguments;
            ScriptingContext.NewCodingAdapter newCodingAdapter = adapter;
            DbmsOutput dbmsOutput = this;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (OraArgument)element$iv$iv;
                boolean bl = false;
                if (!it.getDasType().toDataType().custom) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            dbmsOutput.printCommented(newCodingAdapter, list);
            $this$filter$iv = arguments;
            newCodingAdapter = adapter;
            dbmsOutput = this;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (OraArgument)element$iv$iv;
                boolean bl = false;
                if (!(!it.getDasType().toDataType().custom)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
            dbmsOutput.print(newCodingAdapter, list);
        }

        @Override
        public void produceCursors(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> cursors) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(cursors, (String)"cursors");
            this.printCommented(adapter, cursors);
        }

        @Override
        public void produceSqlArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            this.printCommented(adapter, arrays);
        }

        @Override
        public void producePlArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            this.printCommented(adapter, arrays);
        }

        @Override
        public void producePlTables(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            this.printCommented(adapter, arrays);
        }

        @Override
        public void produceSqlTables(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> arrays) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(arrays, (String)"arrays");
            this.printCommented(adapter, arrays);
        }

        @Override
        public void produceAssociativeArrays(@NotNull ScriptingContext.NewCodingAdapter adapter, @NotNull List<? extends OraArgument> associative) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            Intrinsics.checkNotNullParameter(associative, (String)"associative");
            this.printCommented(adapter, associative);
        }

        private final void printCommented(ScriptingContext.NewCodingAdapter adapter, List<? extends OraArgument> arguments) {
            this.print(adapter, "-- ", arguments);
        }

        private final void print(ScriptingContext.NewCodingAdapter adapter, List<? extends OraArgument> arguments) {
            this.print(adapter, "", arguments);
        }

        private final void print(ScriptingContext.NewCodingAdapter adapter, String prefix, List<? extends OraArgument> arguments) {
            ScriptingContext.NewCodingAdapter newCodingAdapter;
            ScriptingContext.NewCodingAdapter $this$print_u24lambda_u240 = newCodingAdapter = adapter;
            boolean bl = false;
            for (OraArgument oraArgument : arguments) {
                String argumentName = this.generator.argumentName(oraArgument);
                $this$print_u24lambda_u240.unaryPlus((CharSequence)(prefix + "dbms_output.put_line('" + argumentName + " = ' || " + argumentName + ");"));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ArgumentDirection.values().length];
            try {
                nArray[ArgumentDirection.INOUT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArgumentDirection.IN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArgumentDirection.OUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArgumentDirection.RETURN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DasTypeCategory.values().length];
            try {
                nArray[DasTypeCategory.INTEGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.REAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.STRING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

