/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.tns;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.oracle.tns.OraTnsNamesExtractor;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010\t\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/oracle/tns/OraTnsNamesSshInterceptor;", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor;", "<init>", "()V", "interceptConnection", "", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "silent", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.database.dialects.oracle"})
@SourceDebugExtension(value={"SMAP\nOraTnsNamesSshInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraTnsNamesSshInterceptor.kt\ncom/intellij/database/dialects/oracle/tns/OraTnsNamesSshInterceptor\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,43:1\n106#2:44\n78#2,22:45\n*S KotlinDebug\n*F\n+ 1 OraTnsNamesSshInterceptor.kt\ncom/intellij/database/dialects/oracle/tns/OraTnsNamesSshInterceptor\n*L\n31#1:44\n31#1:45,22\n*E\n"})
public final class OraTnsNamesSshInterceptor
implements DatabaseConnectionInterceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object interceptConnection(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, boolean silent, @NotNull Continuation<? super Boolean> $completion) {
        void $this$trim$iv;
        String tnsAlias;
        JdbcUrlParser parsed;
        if (!Intrinsics.areEqual((Object)proto.getConnectionPoint().getDbms(), (Object)Dbms.ORACLE)) {
            return Boxing.boxBoolean((boolean)false);
        }
        if (!DataSourceSshTunnelConfiguration.hasTunnel((DatabaseConnectionPoint)proto.getConnectionPoint())) {
            return Boxing.boxBoolean((boolean)false);
        }
        JdbcUrlParser jdbcUrlParser = parsed = JdbcUrlParserUtil.parsed((RawConnectionConfig)((RawConnectionConfig)proto.getConnectionPoint()));
        String string = tnsAlias = jdbcUrlParser == null ? null : StringUtil.nullize((String)jdbcUrlParser.getParameter("tns_name"));
        if (tnsAlias == null) {
            return Boxing.boxBoolean((boolean)false);
        }
        String tnsAdmin = proto.getConnectionPoint().getAdditionalProperty("TNSADMIN_DIR");
        if (tnsAdmin == null) {
            return Boxing.boxBoolean((boolean)false);
        }
        String descriptor = null;
        try {
            descriptor = OraTnsNamesExtractor.extractAlias(OraTnsNamesExtractor.getTnsNamesOra(tnsAdmin), tnsAlias);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return Boxing.boxBoolean((boolean)false);
        }
        if (descriptor == null) {
            return Boxing.boxBoolean((boolean)false);
        }
        JdbcUrlParser jdbcUrlParser2 = parsed;
        Intrinsics.checkNotNull((Object)jdbcUrlParser2);
        String e = descriptor;
        String string2 = "tns_name";
        JdbcUrlParser jdbcUrlParser3 = jdbcUrlParser2;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String string3 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        jdbcUrlParser3.setParameter(string2, string3);
        String string4 = parsed.getUrlText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getUrlText(...)");
        String newUrl = string4;
        proto.setUrl(newUrl);
        LOG.info("TNS+SSH -> inlined alias: " + newUrl);
        return Boxing.boxBoolean((boolean)true);
    }

    static {
        Logger logger = Logger.getInstance(OraTnsNamesSshInterceptor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/oracle/tns/OraTnsNamesSshInterceptor$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.database.dialects.oracle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

