/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresgreenplumbase;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.dialects.base.BaseDmlHelper;
import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.dialects.postgresgreenplumbase.PgGPlumBaseDmlHelperKt;
import com.intellij.database.dialects.postgresgreenplumbase.generator.dml.PgGPlumBaseQueryColumnsGenerator;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseLikeColumn;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.QueryColumnsTask;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\f\u001a\u0016\u0012\u0004\u0012\u0002H\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\u000f\u0018\u00010\r\"\u0004\b\u0000\u0010\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000fH\u0014J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u001c\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0007H\u0016J \u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J*\u0010&\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u00152\b\u0010(\u001a\u0004\u0018\u00010\u0015H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006*"}, d2={"Lcom/intellij/database/dialects/postgresgreenplumbase/PgGPlumBaseDmlHelper;", "Lcom/intellij/database/dialects/base/BaseDmlHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "supportsInsertDefaultValues", "", "getSupportsInsertDefaultValues", "()Z", "needAliasInUpdateStatement", "getNeedAliasInUpdateStatement", "getGenerator", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "OUT", "Lcom/intellij/database/script/generator/dml/DmlTask;", "task", "appendRowId", "Lcom/intellij/database/util/DdlBuilder;", "builder", "alias", "", "supportsOffset", "table", "Lcom/intellij/database/model/DasObject;", "isEditableTable", "kind", "Lcom/intellij/database/model/ObjectKind;", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "appendPlaceholderForInsert", "", "d", "Lcom/intellij/database/datagrid/AutoValueDescriptor;", "forcePlaceholderForDefaults", "appendPlaceholderForUpdate", "data", "Lcom/intellij/database/datagrid/mutating/ColumnQueryData;", "appendCastIfNeeded", "columnName", "typeName", "Companion", "intellij.database.dialects.postgresgreenplumbase"})
public abstract class PgGPlumBaseDmlHelper
extends BaseDmlHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> needsCastWhenValueIsPassedAsParameterInInsertOrUpdate;

    public PgGPlumBaseDmlHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    public boolean getSupportsInsertDefaultValues() {
        return true;
    }

    public boolean getNeedAliasInUpdateStatement() {
        return false;
    }

    @Nullable
    protected <OUT> DmlGenerator<OUT, DmlTask<OUT>> getGenerator(@NotNull DmlTask<? extends OUT> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        DmlGenerator dmlGenerator = task instanceof QueryColumnsTask ? (DmlGenerator)new PgGPlumBaseQueryColumnsGenerator((QueryColumnsTask)task, this.getDbms(), this) : super.getGenerator(task);
        return dmlGenerator instanceof DmlGenerator ? dmlGenerator : null;
    }

    @NotNull
    public DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        DdlBuilder ddlBuilder = builder.symbol(",").space().literal("CTID");
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"literal(...)");
        return ddlBuilder;
    }

    public boolean supportsOffset(@Nullable DasObject table) {
        return true;
    }

    public boolean isEditableTable(@Nullable ObjectKind kind, @Nullable ModelHelper.ObjectKindVariant variant) {
        return Intrinsics.areEqual((Object)kind, (Object)ObjectKind.VIEW) ? true : super.isEditableTable(kind, variant);
    }

    public void appendPlaceholderForInsert(@NotNull AutoValueDescriptor d, @NotNull DasObject table, @NotNull DdlBuilder builder, boolean forcePlaceholderForDefaults) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (!forcePlaceholderForDefaults && (d.isAutogenerated() || d.hasDefault())) {
            builder.plain("DEFAULT");
            return;
        }
        builder.placeholder();
        String string = d.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.appendCastIfNeeded(builder, table, string, d.getTypeName());
    }

    public boolean appendPlaceholderForUpdate(@NotNull ColumnQueryData data, @NotNull DasObject table, @NotNull DdlBuilder builder) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Object value = data.getObject();
        if (value == ReservedCellValue.DEFAULT) {
            builder.keyword("DEFAULT");
            bl = false;
        } else {
            builder.placeholder();
            String string = data.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.appendCastIfNeeded(builder, table, string, data.getTypeName());
            bl = true;
        }
        return bl;
    }

    private final void appendCastIfNeeded(DdlBuilder builder, DasObject table, String columnName, String typeName) {
        PgGPlumBaseLikeColumn column;
        DasColumn dasColumn = (DasColumn)DasUtil.findChild((DasObject)table, DasColumn.class, (ObjectKind)ObjectKind.COLUMN, (String)columnName);
        Object object = DbImplUtilCore.unwrap((DasObject)((DasObject)dasColumn));
        PgGPlumBaseLikeColumn pgGPlumBaseLikeColumn = column = object instanceof PgGPlumBaseLikeColumn ? (PgGPlumBaseLikeColumn)object : null;
        if (column != null && PgGPlumBaseDmlHelperKt.isNonBasicType(column)) {
            builder.symbol("::").type(column.getDasType().toDataType());
        } else if (typeName != null) {
            object = typeName;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string = ((String)object).toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (needsCastWhenValueIsPassedAsParameterInInsertOrUpdate.contains(string)) {
                DdlBuilder ddlBuilder = builder.symbol("::");
                object = typeName;
                Locale locale2 = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"ENGLISH");
                String string2 = ((String)object).toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                ddlBuilder.type(string2);
            }
        }
    }

    static {
        Object[] objectArray = new String[]{"box", "cidr", "circle", "inet", "line", "lseg", "macaddr", "macaddr8", "path", "pg_lsn", "point", "polygon", "tsquery", "tsvector", "daterange", "int4range", "int8range", "numrange", "tsrange", "tstzrange", "datemultirange", "int4multirange", "int8multirange", "nummultirange", "tsmultirange", "tstzmultirange"};
        needsCastWhenValueIsPassedAsParameterInInsertOrUpdate = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/postgresgreenplumbase/PgGPlumBaseDmlHelper$Companion;", "", "<init>", "()V", "needsCastWhenValueIsPassedAsParameterInInsertOrUpdate", "", "", "getNeedsCastWhenValueIsPassedAsParameterInInsertOrUpdate", "()Ljava/util/Set;", "intellij.database.dialects.postgresgreenplumbase"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getNeedsCastWhenValueIsPassedAsParameterInInsertOrUpdate() {
            return needsCastWhenValueIsPassedAsParameterInInsertOrUpdate;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

