/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.FtlBuiltInDescriptor;
import com.intellij.freemarker.FtlBuiltIns;
import com.intellij.freemarker.FtlReferenceContributor;
import com.intellij.freemarker.inspections.FtlSuppressableInspection;
import com.intellij.freemarker.psi.FtlBuiltIn;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlInterpolation;
import com.intellij.freemarker.psi.FtlMethodCallExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlFileReferenceDirective;
import com.intellij.freemarker.psi.directives.FtlLoopVariableType;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlImplicitVariable;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FtlLanguageInspection
extends FtlSuppressableInspection {
    private static final Pattern FORMAT_STRING_PATTERN = Pattern.compile("(m[0-9]+)?(M[0-9]+)?");

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FtlLanguageInspection.$$$reportNull$$$0(0);
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                FtlLanguageInspection.this.checkElement(element, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/inspections/FtlLanguageInspection$1", "visitElement"));
            }
        };
    }

    private void checkElement(@NotNull PsiElement element, @NotNull ProblemsHolder holder) {
        if (element == null) {
            FtlLanguageInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            FtlLanguageInspection.$$$reportNull$$$0(2);
        }
        if (element.getParent() instanceof FtlBuiltIn && element.getNode().getElementType() == FtlElementTypes.IDENTIFIER) {
            FtlLanguageInspection.checkBuiltIn(element, holder, (FtlBuiltIn)element.getParent());
        } else if (element instanceof PsiComment && FtlReferenceContributor.Holder.FTL_COMMENT.accepts((Object)element)) {
            FtlLanguageInspection.checkDeclarationComment(element, holder);
        } else if (FtlReferenceContributor.Holder.FTL_ROOT_COMMENT.accepts((Object)element)) {
            FtlLanguageInspection.checkFtlRootComment(element, holder);
        } else if (element instanceof FtlInterpolation) {
            FtlLanguageInspection.checkInterpolation(holder, (FtlInterpolation)element);
        }
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = FreeMarkerBundle.message("freemarker.inspections.group", new Object[0]);
        if (string == null) {
            FtlLanguageInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            FtlLanguageInspection.$$$reportNull$$$0(4);
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "FtlLanguageInspection";
    }

    private static void checkBuiltIn(@NotNull PsiElement element, @NotNull ProblemsHolder holder, FtlBuiltIn builtIn) {
        FtlBuiltInDescriptor descriptor;
        String name;
        if (element == null) {
            FtlLanguageInspection.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            FtlLanguageInspection.$$$reportNull$$$0(6);
        }
        if ((name = builtIn.getBuiltInName()) == null) {
            return;
        }
        boolean unknown = FtlBuiltIns.getBuiltIns(null, name).isEmpty();
        TextAttributes attributes = SimpleTextAttributes.DARK_TEXT.toTextAttributes();
        if (unknown) {
            attributes.setFontType(2);
            holder.registerProblem(element, FreeMarkerBundle.message("unknown.builtin", name), ProblemHighlightType.INFORMATION, new LocalQuickFix[0]);
        }
        if ((descriptor = builtIn.getBuiltInDescriptor()) != null && name.equals(descriptor.getSnakeCaseName()) && !name.equals(descriptor.getCamelCaseName()) && FtlPsiUtil.isUsingCamelCase(builtIn.getContainingFtlFile())) {
            holder.registerProblem(element, FreeMarkerBundle.message("error.mixing.camelcase.lowercase", new Object[0]), new LocalQuickFix[0]);
            return;
        }
        FtlType qualifierType = builtIn.getQualifierType();
        if (qualifierType != null) {
            if (builtIn.getType() == null && !builtIn.isEval() && qualifierType != FtlLoopVariableType.INSTANCE) {
                if (!unknown) {
                    holder.registerProblem(element, FreeMarkerBundle.message("builtin.not.applicable", name, qualifierType.getPresentableText()), new LocalQuickFix[0]);
                }
                return;
            }
            PsiElement parent = builtIn.getParent();
            if (parent instanceof FtlMethodCallExpression) {
                FtlMethodCallExpression expression = (FtlMethodCallExpression)parent;
                if (builtIn.getCallableCandidates().length == 0) {
                    holder.registerProblem(element, FreeMarkerBundle.message("builtin.should.not.have.params", name), new LocalQuickFix[0]);
                    return;
                }
                PsiType[] types = expression.getArgumentTypes();
                if (Arrays.asList(types).contains(null)) {
                    return;
                }
                for (FtlCallableType callableType : builtIn.getCallableCandidates()) {
                    if (!FtlLanguageInspection.isApplicable(types, callableType.getParameters())) continue;
                    return;
                }
                holder.registerProblem(element, FreeMarkerBundle.message("wrong.builtin.parameter.types", new Object[0]), new LocalQuickFix[0]);
            } else if (builtIn.isCallableOnly()) {
                holder.registerProblem(element, FreeMarkerBundle.message("builtin.should.have.params", name), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkDeclarationComment(@NotNull PsiElement element, @NotNull ProblemsHolder holder) {
        String text;
        Matcher matcher;
        if (element == null) {
            FtlLanguageInspection.$$$reportNull$$$0(7);
        }
        if (holder == null) {
            FtlLanguageInspection.$$$reportNull$$$0(8);
        }
        if ((matcher = FtlFile.VAR_DECL_PATTERN.matcher(text = element.getText())).matches()) {
            if (FtlLanguageInspection.reportInvalidType(element, holder, text, matcher)) {
                return;
            }
            FileReference[] references = FtlReferenceContributor.getFileReferences(element);
            if (references.length > 0) {
                PsiFileSystemItem item = references[references.length - 1].resolve();
                if (item instanceof FtlFile) {
                    return;
                }
                FileReferenceSet set = references[0].getFileReferenceSet();
                TextRange range = TextRange.from((int)set.getStartInElement(), (int)set.getPathString().length());
                FtlLanguageInspection.addError(element, holder, FreeMarkerBundle.message("invalid.ftl.file", new Object[0]), range);
            }
        }
    }

    private static boolean reportInvalidType(@NotNull PsiElement element, @NotNull ProblemsHolder holder, String text, Matcher matcher) {
        if (element == null) {
            FtlLanguageInspection.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            FtlLanguageInspection.$$$reportNull$$$0(10);
        }
        int start = FtlReferenceContributor.getTypeStartOffset(text);
        int end = FtlReferenceContributor.getTypeEndOffset(text);
        if (start < 0 || end < 0) {
            return true;
        }
        try {
            String invalidType = FtlLanguageInspection.checkType(FtlImplicitVariable.getDeclaredType(matcher.group(2), element), element);
            if (invalidType != null) {
                FtlLanguageInspection.addError(element, holder, invalidType, new TextRange(start, end));
                return true;
            }
        }
        catch (PsiTypeCodeFragment.IncorrectTypeException e) {
            int offset = 0;
            if (e instanceof PsiTypeCodeFragment.TypeSyntaxException && ((PsiTypeCodeFragment.TypeSyntaxException)e).getErrorOffset() > 0) {
                offset = ((PsiTypeCodeFragment.TypeSyntaxException)e).getErrorOffset();
            }
            FtlLanguageInspection.addError(element, holder, e.getMessage(), new TextRange(start + offset, end));
            return true;
        }
        return false;
    }

    private static void addError(@NotNull PsiElement element, @NotNull ProblemsHolder holder, @InspectionMessage String error, TextRange range) {
        if (element == null) {
            FtlLanguageInspection.$$$reportNull$$$0(11);
        }
        if (holder == null) {
            FtlLanguageInspection.$$$reportNull$$$0(12);
        }
        holder.registerProblem(element, range, error, new LocalQuickFix[0]);
    }

    private static void checkFtlRootComment(@NotNull PsiElement element, @NotNull ProblemsHolder holder) {
        String text;
        Matcher matcher;
        if (element == null) {
            FtlLanguageInspection.$$$reportNull$$$0(13);
        }
        if (holder == null) {
            FtlLanguageInspection.$$$reportNull$$$0(14);
        }
        if ((matcher = FtlFileReferenceDirective.FTL_ROOT_PATTERN.matcher(text = element.getText())).matches()) {
            String relativePath = matcher.group(1);
            if (relativePath.startsWith("/")) {
                FtlLanguageInspection.createFtlRootError(element, holder, matcher, FreeMarkerBundle.message("absolute.refs.not.allowed", new Object[0]));
                return;
            }
            List<VirtualFile> roots = FtlFileReferenceDirective.resolveFtlRoots(relativePath, element.getContainingFile().getVirtualFile(), element.getProject());
            if (roots.isEmpty()) {
                FtlLanguageInspection.createFtlRootError(element, holder, matcher, FreeMarkerBundle.message("invalid.relative.path", new Object[0]));
            } else if (roots.stream().noneMatch(VirtualFile::isDirectory)) {
                FtlLanguageInspection.createFtlRootError(element, holder, matcher, FreeMarkerBundle.message("directory.expected", new Object[0]));
            }
        }
    }

    private static void checkInterpolation(@NotNull ProblemsHolder holder, FtlInterpolation interpolation) {
        PsiElement specifier;
        if (holder == null) {
            FtlLanguageInspection.$$$reportNull$$$0(15);
        }
        if (interpolation.isNumeric() && (specifier = interpolation.getFormatSpecifier()) != null && !FORMAT_STRING_PATTERN.matcher(specifier.getText().trim()).matches()) {
            holder.registerProblem(specifier, FreeMarkerBundle.message("error.format.string.syntax", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void createFtlRootError(PsiElement element, ProblemsHolder holder, Matcher matcher, @InspectionMessage String message) {
        int start = matcher.start(1);
        int end = matcher.end(1);
        holder.registerProblem(element, TextRange.from((int)start, (int)(end - start)), message, new LocalQuickFix[0]);
    }

    private static boolean isApplicable(PsiType[] types, FtlVariable[] formalParams) {
        if (types.length != formalParams.length) {
            return false;
        }
        for (int i = 0; i < formalParams.length; ++i) {
            PsiType actual;
            FtlPsiType type = FtlPsiUtil.asInstanceOf(formalParams[i].getType(), FtlPsiType.class);
            if (type == null) {
                return true;
            }
            PsiType expected = type.getPsiType();
            if (expected.isAssignableFrom(actual = types[i]) || expected.equalsToText("java.lang.String") && InheritanceUtil.isInheritor((PsiType)actual, (String)"java.lang.Enum")) continue;
            return false;
        }
        return true;
    }

    @Nullable
    @Nls
    private static String checkType(@Nullable FtlType type, @NotNull PsiElement context) {
        if (context == null) {
            FtlLanguageInspection.$$$reportNull$$$0(16);
        }
        if (type == null) {
            return JavaHighlightUtil.invalidJavaTypeMessage();
        }
        if (type instanceof FtlPsiType) {
            return JavaHighlightUtil.checkPsiTypeUseInContext((PsiType)((FtlPsiType)type).getPsiType(), (PsiElement)context);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/inspections/FtlLanguageInspection";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/inspections/FtlLanguageInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkBuiltIn";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkDeclarationComment";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportInvalidType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addError";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkFtlRootComment";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkInterpolation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

