/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.psi.FtlAssignmentNamespace;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlNameValuePair;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.directives.FtlAssignmentDeclaration;
import com.intellij.freemarker.psi.directives.FtlAssignmentType;
import com.intellij.freemarker.psi.directives.FtlDirective;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.variables.FtlTemplateType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlAssignDirective
extends FtlDirective {
    private volatile Map<FtlNameValuePair, FtlAssignmentDeclaration> myDeclarations;

    public FtlAssignDirective(ASTNode node) {
        super(node);
    }

    @Override
    public boolean processDirectiveDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, boolean honorAssigns) {
        if ((this.getNamespaceExpression() == null || state.get(FtlTemplateType.PROCESSING_NAMESPACE) != null) && FtlAssignmentType.isAssignmentAllowed(state, this) && !this.processOwnDeclarations(processor, state, lastParent)) {
            return false;
        }
        return super.processDirectiveDeclarations(processor, state, lastParent, honorAssigns);
    }

    @Nullable
    public FtlExpression getNamespaceExpression() {
        FtlAssignmentNamespace element = (FtlAssignmentNamespace)((Object)this.findChildByClass(FtlAssignmentNamespace.class));
        return element == null ? null : element.getNamespaceExpression();
    }

    @Nullable
    public FtlFile getTemplateFile() {
        FtlExpression element = this.getNamespaceExpression();
        if (element == null) {
            return null;
        }
        FtlTemplateType type = FtlPsiUtil.asInstanceOf(element.getType(), FtlTemplateType.class);
        if (type == null) {
            return null;
        }
        return type.getTemplateFile();
    }

    public boolean isGlobal() {
        return "global".equals(this.getDirectiveName());
    }

    public boolean isLocal() {
        return "local".equals(this.getDirectiveName());
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            FtlAssignDirective.$$$reportNull$$$0(0);
        }
        if (state == null) {
            FtlAssignDirective.$$$reportNull$$$0(1);
        }
        if (place == null) {
            FtlAssignDirective.$$$reportNull$$$0(2);
        }
        return super.processDeclarations(processor, state, lastParent, place) && this.processOwnDeclarations(processor, state, lastParent);
    }

    private boolean processOwnDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent) {
        Map<FtlNameValuePair, FtlAssignmentDeclaration> map = this.getDeclarationsMap();
        for (FtlNameValuePair pair : map.keySet()) {
            if (lastParent == pair) break;
            FtlAssignmentDeclaration declaration = map.get((Object)pair);
            if (declaration == null || processor.execute((PsiElement)declaration, state)) continue;
            return false;
        }
        return true;
    }

    public void subtreeChanged() {
        this.myDeclarations = null;
        super.subtreeChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<FtlNameValuePair, FtlAssignmentDeclaration> getDeclarationsMap() {
        Map<FtlNameValuePair, FtlAssignmentDeclaration> result = this.myDeclarations;
        if (result == null) {
            LinkedHashMap<FtlNameValuePair, FtlAssignmentDeclaration> newMap = new LinkedHashMap<FtlNameValuePair, FtlAssignmentDeclaration>();
            for (FtlNameValuePair pair : (FtlNameValuePair[])this.findChildrenByClass(FtlNameValuePair.class)) {
                newMap.put(pair, new FtlAssignmentDeclaration(pair));
            }
            FtlAssignDirective ftlAssignDirective = this;
            synchronized (ftlAssignDirective) {
                result = this.myDeclarations;
                if (result == null) {
                    this.myDeclarations = result = newMap;
                }
            }
        }
        Map<FtlNameValuePair, FtlAssignmentDeclaration> map = result;
        if (map == null) {
            FtlAssignDirective.$$$reportNull$$$0(3);
        }
        return map;
    }

    @Nullable
    public FtlAssignmentDeclaration getDeclarationFor(@NotNull FtlNameValuePair pair) {
        if (pair == null) {
            FtlAssignDirective.$$$reportNull$$$0(4);
        }
        assert (pair.getParent() == this);
        return this.getDeclarationsMap().get((Object)pair);
    }

    @Override
    public boolean needsClosing() {
        FtlNameValuePair node = (FtlNameValuePair)((Object)this.findChildByClass(FtlNameValuePair.class));
        if (node != null && node.getOperationToken() != null) {
            return false;
        }
        return super.needsClosing();
    }

    public FtlAssignmentType getType() {
        return this.isLocal() ? FtlAssignmentType.LOCAL : (this.isGlobal() ? FtlAssignmentType.GLOBAL : FtlAssignmentType.ASSIGN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/psi/directives/FtlAssignDirective";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/psi/directives/FtlAssignDirective";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

