/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.inspection;

import com.intellij.codeInsight.intention.AddAnnotationModCommandAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.inspection.LombokJavaInspectionBase;
import org.jetbrains.annotations.NotNull;

public final class DeprecatedLombokAnnotationInspection
extends LombokJavaInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DeprecatedLombokAnnotationInspection.$$$reportNull$$$0(0);
        }
        return new LombokElementVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "de/plushnikov/intellij/plugin/inspection/DeprecatedLombokAnnotationInspection", "createVisitor"));
    }

    private static class LombokElementVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder holder;

        LombokElementVisitor(ProblemsHolder holder) {
            this.holder = holder;
        }

        public void visitAnnotation(@NotNull PsiAnnotation annotation) {
            if (annotation == null) {
                LombokElementVisitor.$$$reportNull$$$0(0);
            }
            this.checkFor("lombok.experimental.Builder", "lombok.Builder", annotation);
            this.checkFor("lombok.experimental.Value", "lombok.Value", annotation);
            this.checkFor("lombok.experimental.Wither", "lombok.With", annotation);
        }

        private void checkFor(String deprecatedFQN, String newFQN, PsiAnnotation psiAnnotation) {
            PsiModifierListOwner listOwner;
            if (psiAnnotation.hasQualifiedName(deprecatedFQN) && null != (listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiModifierListOwner.class, (boolean)false))) {
                String message = LombokBundle.message("inspection.message.lombok.annotation.deprecated.not.supported", deprecatedFQN, newFQN);
                this.holder.problem((PsiElement)psiAnnotation, message).highlight(ProblemHighlightType.ERROR).fix((ModCommandAction)new AddAnnotationModCommandAction(newFQN, listOwner, psiAnnotation.getParameterList().getAttributes(), new String[]{deprecatedFQN})).register();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "de/plushnikov/intellij/plugin/inspection/DeprecatedLombokAnnotationInspection$LombokElementVisitor", "visitAnnotation"));
        }
    }
}

