/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.intention;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import de.plushnikov.intellij.plugin.intention.AbstractLombokIntentionAction;
import de.plushnikov.intellij.plugin.processor.handler.BuilderHandler;
import de.plushnikov.intellij.plugin.processor.handler.BuilderHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAddLombokBuilderMethodsAction
extends AbstractLombokIntentionAction {
    @Override
    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        Presentation presentation;
        if (context == null) {
            AbstractAddLombokBuilderMethodsAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            AbstractAddLombokBuilderMethodsAction.$$$reportNull$$$0(1);
        }
        if ((presentation = super.getPresentation(context, element)) == null) {
            return null;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, PsiMethodCallExpression.class);
        Collection<String> missingLombokBuilderMethods = this.findMissingBuilderMethods(methodCallExpression);
        if (!missingLombokBuilderMethods.isEmpty()) {
            return presentation;
        }
        return null;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Pair<PsiAnnotation, PsiNamedElement> builderAnnotationPair;
        PsiMethodCallExpression psiMethodCallExpression;
        Collection<String> missingLombokBuilderMethods;
        if (context == null) {
            AbstractAddLombokBuilderMethodsAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            AbstractAddLombokBuilderMethodsAction.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            AbstractAddLombokBuilderMethodsAction.$$$reportNull$$$0(4);
        }
        if (!(missingLombokBuilderMethods = this.findRemainingBuilderMethods(psiMethodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, PsiMethodCallExpression.class), builderAnnotationPair = AbstractAddLombokBuilderMethodsAction.findBuilderAnnotationPair(psiMethodCallExpression))).isEmpty() && null != builderAnnotationPair) {
            String expressionText = psiMethodCallExpression.getText();
            String buildMethodName = BuilderHandler.getBuildMethodName((PsiAnnotation)builderAnnotationPair.getFirst());
            String missingMethodsChain = missingLombokBuilderMethods.stream().collect(Collectors.joining("().", ".", "()." + buildMethodName + "()"));
            Object replacedExpressionText = expressionText.contains("." + buildMethodName + "()") ? AbstractAddLombokBuilderMethodsAction.replaceLast(expressionText, "." + buildMethodName + "()", missingMethodsChain) : expressionText + missingMethodsChain;
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)element.getProject()).getElementFactory();
            PsiExpression fixedMethodExpression = factory.createExpressionFromText((String)replacedExpressionText, element.getContext());
            psiMethodCallExpression.replace((PsiElement)fixedMethodExpression);
        }
    }

    @NotNull
    private Collection<String> findMissingBuilderMethods(@Nullable PsiMethodCallExpression methodCallExpression) {
        @Nullable Pair<PsiAnnotation, PsiNamedElement> elementPair = AbstractAddLombokBuilderMethodsAction.findBuilderAnnotationPair(methodCallExpression);
        return this.findRemainingBuilderMethods(methodCallExpression, elementPair);
    }

    @NotNull
    private Collection<String> findRemainingBuilderMethods(@Nullable PsiMethodCallExpression psiMethodCallExpression, @Nullable Pair<PsiAnnotation, PsiNamedElement> builderAnnotationPair) {
        if (null != builderAnnotationPair) {
            List<String> remainingBuilderMethods = this.getBuilderMethodNames(builderAnnotationPair);
            List<String> existingMethodCalls = BuilderHelper.getAllMethodsInChainFromMiddle(psiMethodCallExpression);
            remainingBuilderMethods.removeAll(existingMethodCalls);
            List<String> list = remainingBuilderMethods;
            if (list == null) {
                AbstractAddLombokBuilderMethodsAction.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            AbstractAddLombokBuilderMethodsAction.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    private static Pair<PsiAnnotation, PsiNamedElement> findBuilderAnnotationPair(@Nullable PsiMethodCallExpression psiMethodCallExpression) {
        PsiMethod resolvedMethod;
        if (null != psiMethodCallExpression && (resolvedMethod = psiMethodCallExpression.resolveMethod()) != null) {
            return BuilderHelper.findBuilderAnnotation(resolvedMethod);
        }
        return null;
    }

    abstract List<String> getBuilderMethodNames(@NotNull Pair<PsiAnnotation, PsiNamedElement> var1);

    private static String replaceLast(String input, String oldStr, String newStr) {
        int lastIndex = input.lastIndexOf(oldStr);
        if (lastIndex == -1) {
            return input;
        }
        return input.substring(0, lastIndex) + newStr + input.substring(lastIndex + oldStr.length());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/intention/AbstractAddLombokBuilderMethodsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/intention/AbstractAddLombokBuilderMethodsAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findRemainingBuilderMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

