/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.core.model.dbprop;

import com.google.common.base.Strings;
import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HsqlFileDbProperties
extends DbProperties {
    private static final String DEFAULT_PATH = ".hsqldb/";

    public HsqlFileDbProperties() {
        this.dbType = DbType.HSQL_FILE;
        this.user = "sa";
        this.url = this.getUrlPrefix() + ".hsqldb/test";
    }

    @Override
    public DbProperties setUrl(@NotNull String address, @NotNull String dbName, @NotNull String connectionParams) {
        if (address == null) {
            HsqlFileDbProperties.$$$reportNull$$$0(0);
        }
        if (dbName == null) {
            HsqlFileDbProperties.$$$reportNull$$$0(1);
        }
        if (connectionParams == null) {
            HsqlFileDbProperties.$$$reportNull$$$0(2);
        }
        this.url = this.getUrlPrefix() + DEFAULT_PATH + dbName;
        return this;
    }

    @Override
    @NotNull
    public String getDatabaseName() {
        String params = Strings.nullToEmpty((String)this.getConnectionParams());
        String result = this.url.replace(params, "");
        int lastSlash = result.lastIndexOf("/");
        if (lastSlash < 0) {
            return "";
        }
        String string = this.url.substring(lastSlash + 1);
        if (string == null) {
            HsqlFileDbProperties.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public DbProperties setDatabaseName(@Nullable String databaseName) {
        databaseName = Strings.nullToEmpty((String)databaseName);
        String params = Strings.nullToEmpty((String)this.getConnectionParams());
        String oldDatabaseName = this.url.replace(params, "");
        int lastSlash = oldDatabaseName.lastIndexOf("/");
        if (lastSlash < 0) {
            HsqlFileDbProperties hsqlFileDbProperties = this;
            if (hsqlFileDbProperties == null) {
                HsqlFileDbProperties.$$$reportNull$$$0(4);
            }
            return hsqlFileDbProperties;
        }
        oldDatabaseName = oldDatabaseName.substring(lastSlash + 1);
        this.url = this.url.replace(oldDatabaseName, databaseName);
        HsqlFileDbProperties hsqlFileDbProperties = this;
        if (hsqlFileDbProperties == null) {
            HsqlFileDbProperties.$$$reportNull$$$0(5);
        }
        return hsqlFileDbProperties;
    }

    @Override
    @Nullable
    public String getHost() {
        String params = Strings.nullToEmpty((String)this.getConnectionParams());
        String result = this.url.replace(params, "");
        int lastSlash = (result = result.replace(this.getUrlPrefix(), "")).lastIndexOf("/");
        if (lastSlash < 0) {
            return "";
        }
        return result.substring(0, lastSlash);
    }

    @Override
    @NotNull
    public DbProperties setHost(@Nullable String host) {
        host = Strings.nullToEmpty((String)host);
        String params = Strings.nullToEmpty((String)this.getConnectionParams());
        String oldHost = this.url.replace(params, "");
        int lastSlash = (oldHost = oldHost.replace(this.getUrlPrefix(), "")).lastIndexOf("/");
        if (lastSlash < 0) {
            HsqlFileDbProperties hsqlFileDbProperties = this;
            if (hsqlFileDbProperties == null) {
                HsqlFileDbProperties.$$$reportNull$$$0(6);
            }
            return hsqlFileDbProperties;
        }
        oldHost = oldHost.substring(0, lastSlash);
        this.url = this.url.replace(oldHost, host);
        HsqlFileDbProperties hsqlFileDbProperties = this;
        if (hsqlFileDbProperties == null) {
            HsqlFileDbProperties.$$$reportNull$$$0(7);
        }
        return hsqlFileDbProperties;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "address";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionParams";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/core/model/dbprop/HsqlFileDbProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/core/model/dbprop/HsqlFileDbProperties";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "setDatabaseName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setUrl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

