/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.dialog;

import com.intellij.ide.util.DirectoryChooser;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.core.util.DirectoryUtil;
import com.intellij.jpa.jpb.model.ui.component.SPackageNameReferenceEditorCombo;
import com.intellij.jpa.jpb.model.ui.component.SourceRootField;
import com.intellij.jpa.jpb.model.ui.dialog.StudioElementCreationGridDialog;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.components.JBTextField;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import net.miginfocom.layout.CC;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClassAndPackageCreationDialog<Result>
extends StudioElementCreationGridDialog<Result> {
    protected final PsiManager psiManager;
    protected List<VirtualFile> suitableDestinationSourceRoots;
    protected SPackageNameReferenceEditorCombo targetPackageField;
    protected ComboBox<DirectoryChooser.ItemWrapper> sourceRootField;
    protected final JBTextField classNameField;
    protected boolean isAddSeparator;

    public ClassAndPackageCreationDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NlsContexts.DialogTitle @NotNull String title) {
        if (project == null) {
            ClassAndPackageCreationDialog.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            ClassAndPackageCreationDialog.$$$reportNull$$$0(1);
        }
        if (title == null) {
            ClassAndPackageCreationDialog.$$$reportNull$$$0(2);
        }
        this(project, directory, title, null);
    }

    public ClassAndPackageCreationDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NlsContexts.DialogTitle @NotNull String title, @Nullable List<VirtualFile> sourceRoots) {
        if (project == null) {
            ClassAndPackageCreationDialog.$$$reportNull$$$0(3);
        }
        if (directory == null) {
            ClassAndPackageCreationDialog.$$$reportNull$$$0(4);
        }
        if (title == null) {
            ClassAndPackageCreationDialog.$$$reportNull$$$0(5);
        }
        super(project, directory, title);
        this.classNameField = new JBTextField();
        this.isAddSeparator = true;
        this.psiManager = PsiManager.getInstance((Project)project);
        this.suitableDestinationSourceRoots = sourceRoots != null ? sourceRoots : JavaProjectRootsUtil.getSuitableDestinationSourceRoots((Project)project);
    }

    @Override
    public void setupComponents() {
        String pkgName = this.findPackageName();
        this.targetPackageField = new SPackageNameReferenceEditorCombo(pkgName, this.project, this.getPackageRecentKey(), this.getPackageChooserDialogCaption());
        this.suitableDestinationSourceRoots = SourceRootField.filterSourceRoots(this.suitableDestinationSourceRoots, this.project, this.checkModuleForSourceRoot());
        this.sourceRootField = new SourceRootField(this.project, this.suitableDestinationSourceRoots, this.directory);
        this.setupTopPanel();
        if (this.isAddSeparator) {
            this.getMainPanel().add((Component)new JSeparator(), (Object)new CC().width("100%").spanX().growX().pushX().wrap());
        }
        this.addSourceRootAndPackage();
        boolean isMultipleSourceRoots = this.suitableDestinationSourceRoots.size() != 1;
        this.setVisible("DESTINATION_FOLDER", isMultipleSourceRoots);
    }

    protected void addSourceRootAndPackage() {
        this.addComponent(JpaModelBundle.messageWithColon("source.root", new Object[0]), (JComponent)this.sourceRootField, "DESTINATION_FOLDER");
        this.addComponent(JpaModelBundle.messageWithColon("EntityPropertiesPanel.packageName", new Object[0]), (JComponent)((Object)this.targetPackageField), "TARGET_PACKAGE");
    }

    protected String findPackageName() {
        PsiPackage packageByDir = JavaDirectoryService.getInstance().getPackage(this.directory);
        return packageByDir == null ? null : packageByDir.getQualifiedName();
    }

    protected abstract void setupTopPanel();

    protected abstract String getPackageRecentKey();

    @NotNull
    public PsiDirectory getSelectedDirectory() {
        Object selectedItem = this.sourceRootField.getSelectedItem();
        if (selectedItem == null) {
            PsiDirectory psiDirectory = this.directory;
            if (psiDirectory == null) {
                ClassAndPackageCreationDialog.$$$reportNull$$$0(6);
            }
            return psiDirectory;
        }
        if (selectedItem instanceof DirectoryChooser.ItemWrapper) {
            PsiDirectory directory = ((DirectoryChooser.ItemWrapper)selectedItem).getDirectory();
            PsiDirectory psiDirectory = DirectoryUtil.findOrCreatePackageDirectory(directory, this.getPackageName());
            if (psiDirectory == null) {
                ClassAndPackageCreationDialog.$$$reportNull$$$0(7);
            }
            return psiDirectory;
        }
        throw new IllegalStateException("Selected item incorrect type");
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        ValidationInfo classNameErr = this.validateClassName(this.classNameField.getText(), (JComponent)this.classNameField);
        if (classNameErr != null) {
            List<ValidationInfo> list = Collections.singletonList(classNameErr);
            if (list == null) {
                ClassAndPackageCreationDialog.$$$reportNull$$$0(8);
            }
            return list;
        }
        ValidationInfo packageNameErr = this.validatePackage(this.getPackageName(), this.targetPackageField.getChildComponent());
        if (packageNameErr != null) {
            List<ValidationInfo> list = Collections.singletonList(packageNameErr);
            if (list == null) {
                ClassAndPackageCreationDialog.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (this.getLanguageRadioButtonPanel().isVisible() && this.getLanguageRadioButtonPanel().shouldBeAdded() && this.getLanguageRadioButtonPanel().getSelectedItem() == null) {
            List<ValidationInfo> list = Collections.singletonList(new ValidationInfo(JpaModelBundle.message("Validation.language.null", new Object[0]), (JComponent)((Object)this.getLanguageRadioButtonPanel())));
            if (list == null) {
                ClassAndPackageCreationDialog.$$$reportNull$$$0(10);
            }
            return list;
        }
        List list = StreamEx.of((Object)this.validateElementUniqueness(this.getPackageName(), this.classNameField.getText(), this.getClassNameErrorMessage(), (JComponent)this.classNameField)).nonNull().toImmutableList();
        if (list == null) {
            ClassAndPackageCreationDialog.$$$reportNull$$$0(11);
        }
        return list;
    }

    public String getClassName() {
        return this.classNameField.getText();
    }

    public void setClassName(String className) {
        this.classNameField.setText(className);
    }

    public void setClassNameEnabled(Boolean enabled) {
        this.classNameField.setEnabled(enabled.booleanValue());
    }

    @NlsContexts.DialogMessage
    protected abstract String getClassNameErrorMessage();

    @NotNull
    public String getPackageName() {
        String string = this.targetPackageField.getText().trim();
        if (string == null) {
            ClassAndPackageCreationDialog.$$$reportNull$$$0(12);
        }
        return string;
    }

    public void setPackageValue(@NlsSafe @NotNull String pack) {
        if (pack == null) {
            ClassAndPackageCreationDialog.$$$reportNull$$$0(13);
        }
        ((EditorComboBox)this.targetPackageField.getChildComponent()).setItem((Object)pack);
    }

    @NlsContexts.DialogTitle
    public String getPackageChooserDialogCaption() {
        return JpaModelBundle.message("EntityPropertiesPanel.packageSelector.title", new Object[0]);
    }

    protected Predicate<Module> checkModuleForSourceRoot() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/ui/dialog/ClassAndPackageCreationDialog";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/ui/dialog/ClassAndPackageCreationDialog";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDirectory";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidateAll";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setPackageValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

