/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dataFlow;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dataFlow.CursorState;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dataFlow.SqlFlowGraphBuilder;
import com.intellij.sql.dataFlow.instructions.SqlAssignmentInstruction;
import com.intellij.sql.dataFlow.instructions.SqlCursorInstruction;
import com.intellij.sql.dataFlow.instructions.SqlEnterSubroutineInstruction;
import com.intellij.sql.dataFlow.instructions.SqlFlowGraph;
import com.intellij.sql.dataFlow.instructions.SqlInstruction;
import com.intellij.sql.dataFlow.instructions.SqlInstructionVisitor;
import com.intellij.sql.dataFlow.instructions.SqlJumpInstruction;
import com.intellij.sql.dataFlow.instructions.SqlPseudoValue;
import com.intellij.sql.dataFlow.instructions.SqlPseudoValueSource;
import com.intellij.sql.dataFlow.instructions.SqlSubroutineDefinitionInstruction;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u0001\u001a\u001c\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\b0\u000b*\u00020\u0001\u001a@\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\b0\u000b2$\u0010\u000f\u001a \u0012\u0004\u0012\u00020\t\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00120\u00100\u0010H\u0002\u001ab\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00112$\u0010\u000f\u001a \u0012\u0004\u0012\u00020\t\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00120\u00100\u00102\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00120\u00102\u0006\u0010\u0017\u001a\u00020\rH\u0002\u001aF\u0010\u0018\u001a\u00020\u00042\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00120\u00102\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00120\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0002\u001a \u0010\u001c\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0006\u0012\u0004\u0018\u00010\r0\u001d2\u0006\u0010\u001e\u001a\u00020\tH\u0002\u001a\u0010\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0 *\u00020\u0001\u001a\u0010\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"*\u00020#\u001a\u0010\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00010\"*\u00020\u0001\u00a8\u0006%"}, d2={"buildFlowGraph", "Lcom/intellij/sql/dataFlow/instructions/SqlFlowGraph;", "Lcom/intellij/sql/psi/SqlRoutineDefinition;", "accept", "", "visitor", "Lcom/intellij/sql/dataFlow/instructions/SqlInstructionVisitor;", "findUnreachableInstructions", "", "Lcom/intellij/sql/dataFlow/instructions/SqlInstruction;", "computeCursorStates", "", "Lcom/intellij/sql/dataFlow/instructions/SqlCursorInstruction;", "Lcom/intellij/sql/dataFlow/CursorState;", "extractCursorInstructionsStates", "states", "", "Lcom/intellij/sql/psi/SqlDefinition;", "", "updateStates", "predecessor", "currentDef", "currentStates", "initialState", "merge", "to", "from", "avoid", "getDefinitionAndState", "Lkotlin/Pair;", "inst", "findExitPoints", "", "parentBuilders", "Lkotlin/sequences/Sequence;", "Lcom/intellij/sql/dataFlow/SqlFlowGraphBuilder;", "parentGraphs", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nflowUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 flowUtil.kt\ncom/intellij/sql/dataFlow/FlowUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,156:1\n1869#2,2:157\n1869#2,2:159\n1869#2,2:175\n774#2:177\n865#2,2:178\n382#3,7:161\n382#3,7:168\n*S KotlinDebug\n*F\n+ 1 flowUtil.kt\ncom/intellij/sql/dataFlow/FlowUtilKt\n*L\n22#1:157,2\n39#1:159,2\n145#1:175,2\n58#1:177\n58#1:178,2\n107#1:161,7\n115#1:168,7\n*E\n"})
public final class FlowUtilKt {
    @NotNull
    public static final SqlFlowGraph buildFlowGraph(@NotNull SqlRoutineDefinition $this$buildFlowGraph) {
        Intrinsics.checkNotNullParameter((Object)$this$buildFlowGraph, (String)"<this>");
        DFABuildingVisitor dFABuildingVisitor = SqlPsiUtilKt.getSqlDialect((PsiElement)$this$buildFlowGraph).createDFAVisitor();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)dFABuildingVisitor), (String)"createDFAVisitor(...)");
        DFABuildingVisitor visitor2 = dFABuildingVisitor;
        $this$buildFlowGraph.accept((SqlVisitor)visitor2);
        return visitor2.getFlowGraph();
    }

    public static final void accept(@NotNull SqlFlowGraph $this$accept, @NotNull SqlInstructionVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)$this$accept, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Iterable $this$forEach$iv = $this$accept.getInstructions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlInstruction it = (SqlInstruction)element$iv;
            boolean bl = false;
            it.accept(visitor2);
        }
    }

    @NotNull
    public static final Set<SqlInstruction> findUnreachableInstructions(@NotNull SqlFlowGraph $this$findUnreachableInstructions) {
        Intrinsics.checkNotNullParameter((Object)$this$findUnreachableInstructions, (String)"<this>");
        LinkedHashSet unprocessed = new LinkedHashSet($this$findUnreachableInstructions.getInstructions());
        Stack stack = new Stack();
        stack.push((Object)$this$findUnreachableInstructions.getEntryPoint());
        while (!((Collection)stack).isEmpty()) {
            SqlInstruction instruction = (SqlInstruction)stack.pop();
            if (!unprocessed.remove(instruction)) continue;
            if (instruction instanceof SqlEnterSubroutineInstruction) {
                CollectionsKt.addAll((Collection)unprocessed, (Iterable)((SqlEnterSubroutineInstruction)instruction).getJumpTo().getInstructions());
            }
            if (instruction instanceof SqlSubroutineDefinitionInstruction) {
                CollectionsKt.addAll((Collection)unprocessed, (Iterable)FlowUtilKt.findUnreachableInstructions(((SqlSubroutineDefinitionInstruction)instruction).getFlowGraph()));
            }
            Iterable $this$forEach$iv = instruction.getSuccessors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlInstruction it = (SqlInstruction)element$iv;
                boolean bl = false;
                stack.push((Object)it);
            }
        }
        return unprocessed;
    }

    @NotNull
    public static final Map<SqlCursorInstruction, Set<CursorState>> computeCursorStates(@NotNull SqlFlowGraph $this$computeCursorStates) {
        Intrinsics.checkNotNullParameter((Object)$this$computeCursorStates, (String)"<this>");
        boolean isInitiallyOpen = SqlPsiUtilKt.getSqlDialect((PsiElement)$this$computeCursorStates.getSource()).getDbms().isGreenplum();
        CursorState initialState = isInitiallyOpen ? CursorState.OPEN : CursorState.CLOSE;
        Map states = new LinkedHashMap();
        Iterator iterator = ((JBTreeTraverser)new JBTreeTraverser(arg_0 -> FlowUtilKt.computeCursorStates$lambda$1(arg_0 -> FlowUtilKt.computeCursorStates$lambda$0(states, $this$computeCursorStates, arg_0), arg_0)).withRoot((Object)$this$computeCursorStates.getExitPoint())).postOrderDfsTraversal().typedIterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"typedIterator(...)");
        TreeTraversal.TracingIt it = (TreeTraversal.TracingIt)iterator;
        Object[] objectArray = new SqlInstruction[]{$this$computeCursorStates.getEntryPoint()};
        Set hasProcessedPathToEntryPoint = SetsKt.mutableSetOf((Object[])objectArray);
        while (it.advance()) {
            ProgressManager.checkCanceled();
            SqlInstruction inst = (SqlInstruction)it.current();
            Object v = states.get(inst);
            Intrinsics.checkNotNull(v);
            Map currentStates = (Map)v;
            SqlCursorInstruction sqlCursorInstruction = inst instanceof SqlCursorInstruction ? (SqlCursorInstruction)inst : null;
            PsiElement psiElement = sqlCursorInstruction != null && (sqlCursorInstruction = sqlCursorInstruction.getReference()) != null ? sqlCursorInstruction.resolve() : null;
            SqlDefinition currentDef = psiElement instanceof SqlDefinition ? (SqlDefinition)psiElement : null;
            for (SqlInstruction predecessor : inst.getPredecessors()) {
                if (!hasProcessedPathToEntryPoint.contains(predecessor)) continue;
                Intrinsics.checkNotNull((Object)inst);
                hasProcessedPathToEntryPoint.add(inst);
                FlowUtilKt.updateStates(predecessor, currentDef, states, currentStates, initialState);
            }
        }
        return FlowUtilKt.extractCursorInstructionsStates(states);
    }

    private static final Map<SqlCursorInstruction, Set<CursorState>> extractCursorInstructionsStates(Map<SqlInstruction, Map<SqlDefinition, Set<CursorState>>> states) {
        Map cursorInstructionsStates = new LinkedHashMap();
        for (Map.Entry<SqlInstruction, Map<SqlDefinition, Set<CursorState>>> entry : states.entrySet()) {
            Set<CursorState> s;
            SqlDefinition def;
            SqlInstruction inst = entry.getKey();
            if (!(inst instanceof SqlCursorInstruction)) continue;
            SqlReferenceExpression sqlReferenceExpression = ((SqlCursorInstruction)inst).getReference();
            Object object = sqlReferenceExpression != null ? sqlReferenceExpression.resolve() : null;
            if ((object instanceof SqlDefinition ? (SqlDefinition)object : null) == null) continue;
            def = def;
            if (entry.getValue().get(def) == null) continue;
            cursorInstructionsStates.put(inst, s);
        }
        return cursorInstructionsStates;
    }

    /*
     * WARNING - void declaration
     */
    private static final void updateStates(SqlInstruction predecessor, SqlDefinition currentDef, Map<SqlInstruction, Map<SqlDefinition, Set<CursorState>>> states, Map<SqlDefinition, Set<CursorState>> currentStates, CursorState initialState) {
        Map<SqlDefinition, Set<CursorState>> map;
        Map<SqlDefinition, Set<CursorState>> map2 = states.get(predecessor);
        if (map2 == null) {
            map2 = new LinkedHashMap();
        }
        Map<SqlDefinition, Set<CursorState>> prevStates = map2;
        Pair<SqlDefinition, CursorState> pair = FlowUtilKt.getDefinitionAndState(predecessor);
        SqlDefinition prevDef = (SqlDefinition)pair.component1();
        CursorState updatedState = (CursorState)((Object)pair.component2());
        if (currentDef != null && !prevStates.containsKey(currentDef)) {
            map = prevStates;
            SqlDefinition sqlDefinition = currentDef;
            Object object = new CursorState[]{initialState};
            object = SetsKt.mutableSetOf((Object[])object);
            map.put(sqlDefinition, (Set<CursorState>)object);
        }
        FlowUtilKt.merge(currentStates, prevStates, prevDef);
        if (prevDef != null && updatedState != null) {
            Object object;
            void $this$getOrPut$iv;
            map = currentStates;
            SqlDefinition key$iv = prevDef;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Set)object).add(updatedState);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void merge(Map<SqlDefinition, Set<CursorState>> to, Map<SqlDefinition, Set<CursorState>> from, SqlDefinition avoid) {
        for (Map.Entry<SqlDefinition, Set<CursorState>> entry : from.entrySet()) {
            Object object;
            void $this$getOrPut$iv;
            SqlDefinition cursor = entry.getKey();
            Set<CursorState> cursorStates = entry.getValue();
            if (Intrinsics.areEqual((Object)cursor, (Object)avoid)) continue;
            Map<SqlDefinition, Set<CursorState>> map = to;
            SqlDefinition key$iv = cursor;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Set)object).addAll((Collection)cursorStates);
        }
    }

    private static final Pair<SqlDefinition, CursorState> getDefinitionAndState(SqlInstruction inst) {
        SqlDefinition def = null;
        CursorState state = null;
        SqlInstruction sqlInstruction = inst;
        if (sqlInstruction instanceof SqlCursorInstruction) {
            SqlReferenceExpression sqlReferenceExpression = ((SqlCursorInstruction)inst).getReference();
            PsiElement psiElement = sqlReferenceExpression != null ? sqlReferenceExpression.resolve() : null;
            def = psiElement instanceof SqlDefinition ? (SqlDefinition)psiElement : null;
            state = ((SqlCursorInstruction)inst).getOp() == SqlCursorInstruction.CursorOperation.CLOSE ? CursorState.CLOSE : CursorState.OPEN;
        } else if (sqlInstruction instanceof SqlAssignmentInstruction) {
            SqlPseudoValue sqlPseudoValue = ((SqlAssignmentInstruction)inst).getRValue();
            SqlPseudoValueSource sqlPseudoValueSource = sqlPseudoValue != null ? sqlPseudoValue.getSource() : null;
            SqlPseudoValueSource.Psi psi = sqlPseudoValueSource instanceof SqlPseudoValueSource.Psi ? (SqlPseudoValueSource.Psi)sqlPseudoValueSource : null;
            if (!((psi != null ? psi.getElement() : null) instanceof SqlQueryExpression)) {
                def = (SqlDefinition)((SqlAssignmentInstruction)inst).getLValue();
                state = CursorState.UNKNOWN;
            }
        }
        return new Pair(def, state);
    }

    @NotNull
    public static final Collection<SqlInstruction> findExitPoints(@NotNull SqlFlowGraph $this$findExitPoints) {
        Intrinsics.checkNotNullParameter((Object)$this$findExitPoints, (String)"<this>");
        ArrayDeque<SqlInstruction> candidates = new ArrayDeque<SqlInstruction>();
        ArrayList result = new ArrayList();
        CollectionsKt.addAll((Collection)candidates, (Iterable)$this$findExitPoints.getExitPoint().getPredecessors());
        CollectionsKt.addAll((Collection)candidates, (Iterable)$this$findExitPoints.getErrorPoint().getPredecessors());
        while (!((Collection)candidates).isEmpty()) {
            SqlInstruction candidate = (SqlInstruction)candidates.poll();
            if (candidate instanceof SqlJumpInstruction) {
                Iterable $this$forEach$iv = ((SqlJumpInstruction)candidate).getPredecessors();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlInstruction it = (SqlInstruction)element$iv;
                    boolean bl = false;
                    candidates.offer(it);
                }
                continue;
            }
            ((Collection)result).add(candidate);
        }
        return result;
    }

    @NotNull
    public static final Sequence<SqlFlowGraphBuilder> parentBuilders(@NotNull SqlFlowGraphBuilder $this$parentBuilders) {
        Intrinsics.checkNotNullParameter((Object)$this$parentBuilders, (String)"<this>");
        return SequencesKt.generateSequence((Object)$this$parentBuilders, FlowUtilKt::parentBuilders$lambda$0);
    }

    @NotNull
    public static final Sequence<SqlFlowGraph> parentGraphs(@NotNull SqlFlowGraph $this$parentGraphs) {
        Intrinsics.checkNotNullParameter((Object)$this$parentGraphs, (String)"<this>");
        return SequencesKt.generateSequence((Object)$this$parentGraphs, FlowUtilKt::parentGraphs$lambda$0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable computeCursorStates$lambda$0(Map $states, SqlFlowGraph $this_computeCursorStates, SqlInstruction instr) {
        void $this$filterTo$iv$iv;
        $states.put(instr, (Map)new LinkedHashMap());
        Iterable $this$filter$iv = instr.getPredecessors();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SqlInstruction it = (SqlInstruction)element$iv$iv;
            boolean bl = false;
            if (!(!$states.containsKey(it) && Intrinsics.areEqual((Object)it.getOwnerGraph().getSource(), (Object)$this_computeCursorStates.getSource()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Iterable computeCursorStates$lambda$1(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final SqlFlowGraphBuilder parentBuilders$lambda$0(SqlFlowGraphBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParentBuilder();
    }

    private static final SqlFlowGraph parentGraphs$lambda$0(SqlFlowGraph it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }
}

