/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.functions;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypeAwareObject;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbElement;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasDataBuiltinType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinitionParser;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlInfoElementType;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessorBase;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlFunctionsUtil {
    public static final BuiltinFunction.Type ANY = SqlFunctionsUtil.newType("ANY", DataTypeFactory.of((String)"any"));
    public static final BuiltinFunction.Type UNNEST = new BuiltinFunction.Type("table(...args)");
    public static final BuiltinFunction.Type REF = new BuiltinFunction.Type("ref", (DasType)DasTypeSystemBase.REFERENCE);
    public static final BuiltinFunction.Type TOKEN = SqlFunctionsUtil.newType("token", DataTypeFactory.of((String)"token"));
    public static final BuiltinFunction.Type DATATYPE = SqlFunctionsUtil.newType("datatype", DataTypeFactory.of((String)"datatype"));
    public static final BuiltinFunction.Type CAST_DATATYPE = SqlFunctionsUtil.newType("cast_datatype", DataTypeFactory.of((String)"cast_datatype"));
    public static final BuiltinFunction.Type INTERVAL_LITERAL = SqlFunctionsUtil.newType("interval_literal", DataTypeFactory.of((String)"interval_literal"));
    public static final BuiltinFunction.Type EXPRESSION_LIST = SqlFunctionsUtil.newType("expr_list", DataTypeFactory.of((String)"expr_list"));
    public static final BuiltinFunction.Type TABLE = new BuiltinFunction.Type("table", (DasType)SqlTableTypeBase.EMPTY_TABLE);
    public static final BuiltinFunction.Type SETOF = SqlFunctionsUtil.newType("setof", DataTypeFactory.of((String)"setof"));
    public static final BuiltinFunction.Type TUPLE = SqlFunctionsUtil.newType("tuple", DataTypeFactory.of((String)"tuple"));
    public static final BuiltinFunction.Type PARAM_LIST = SqlFunctionsUtil.newType("P$", DataTypeFactory.of((String)"P$"));
    public static final BuiltinFunction.Type STRING_LITERAL = SqlFunctionsUtil.newType("string_literal", DataTypeFactory.of((String)"string_literal"));

    @NotNull
    public static BuiltinFunction.Type newType(@NonNls String name, DataType dataType) {
        return new BuiltinFunction.Type(name, DasUnresolvedTypeReference.of((DataType)dataType));
    }

    public static void addSimpleType(@NotNull Map<String, BuiltinFunction.Type> types, @NotNull BuiltinFunction.Type type) {
        if (types == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(0);
        }
        if (type == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(1);
        }
        types.put(type.getName(), type);
    }

    public static void addSimpleType(@NotNull Map<String, BuiltinFunction.Type> types, @NotNull String name, @NotNull String spec, @NotNull SqlLanguageDialectEx dialect) {
        if (types == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(2);
        }
        if (name == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(3);
        }
        if (spec == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(4);
        }
        if (dialect == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(5);
        }
        DasTypeSystemBase typeSystem = dialect.getTypeSystem();
        String typeName = typeSystem.getNormalizedTypeName(spec);
        DataType dataType = DataTypeFactory.of((String)typeName);
        DasTypeCategory category = typeSystem.getTypeCategory(dataType);
        SqlFunctionsUtil.addSimpleType(types, new BuiltinFunction.Type(name, (DasType)DasDataBuiltinType.of((String)typeName, (DasTypeCategory)category, (DataType)dataType)));
    }

    public static void addSimpleType(@NotNull Map<String, BuiltinFunction.Type> types, @NotNull String name, @NotNull DasTypeCategory category, @NotNull SqlLanguageDialectEx dialect) {
        if (types == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(6);
        }
        if (name == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(7);
        }
        if (category == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(8);
        }
        if (dialect == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(9);
        }
        SqlFunctionsUtil.addSimpleType(types, new BuiltinFunction.Type(name, dialect.getTypeSystem().getDefaultType(category)));
    }

    public static void addSimpleTypes(@NotNull Map<String, BuiltinFunction.Type> types, @NotNull SqlLanguageDialectEx dialect) {
        if (types == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(10);
        }
        if (dialect == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(11);
        }
        SqlFunctionsUtil.addSimpleType(types, ANY);
        SqlFunctionsUtil.addSimpleType(types, REF);
        SqlFunctionsUtil.addSimpleType(types, TOKEN);
        SqlFunctionsUtil.addSimpleType(types, DATATYPE);
        SqlFunctionsUtil.addSimpleType(types, CAST_DATATYPE);
        SqlFunctionsUtil.addSimpleType(types, STRING_LITERAL);
        SqlFunctionsUtil.addSimpleType(types, INTERVAL_LITERAL);
        SqlFunctionsUtil.addSimpleType(types, EXPRESSION_LIST);
        SqlFunctionsUtil.addSimpleType(types, TABLE);
        SqlFunctionsUtil.addSimpleType(types, SETOF);
        SqlFunctionsUtil.addSimpleType(types, TUPLE);
        SqlFunctionsUtil.addSimpleType(types, PARAM_LIST);
        SqlFunctionsUtil.addSimpleType(types, new BuiltinFunction.Type("array", (DasType)dialect.getTypeSystem().getAnyArrayType()));
        SqlFunctionsUtil.addSimpleType(types, "N", DasTypeCategory.INTEGER, dialect);
        SqlFunctionsUtil.addSimpleType(types, "X", DasTypeCategory.REAL, dialect);
        SqlFunctionsUtil.addSimpleType(types, "str", DasTypeCategory.STRING, dialect);
        SqlFunctionsUtil.addSimpleType(types, "bytes", DasTypeCategory.BYTES, dialect);
        SqlFunctionsUtil.addSimpleType(types, "B", DasTypeCategory.BOOLEAN, dialect);
        SqlFunctionsUtil.addSimpleType(types, "time", DasTypeCategory.TIME, dialect);
        SqlFunctionsUtil.addSimpleType(types, "date", DasTypeCategory.DATE, dialect);
        SqlFunctionsUtil.addSimpleType(types, "timestamp", DasTypeCategory.TIMESTAMP, dialect);
        SqlFunctionsUtil.addSimpleType(types, "datetime", DasTypeCategory.DATE_TIME, dialect);
        SqlFunctionsUtil.addSimpleType(types, "interval", DasTypeCategory.INTERVAL, dialect);
    }

    @NotNull
    private static Case getCasing(@NotNull ObjectKind kind, @NotNull SqlLanguageDialectEx dialect) {
        Case casing;
        if (kind == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(12);
        }
        if (dialect == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(13);
        }
        if ((casing = dialect.getCasing((ObjectKind)kind, null).plain) != Case.EXACT || dialect.getDbms().isTransactSql() || dialect.getDbms().isBigQuery()) {
            casing = Case.UPPER;
        }
        Case case_ = casing;
        if (case_ == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(14);
        }
        return case_;
    }

    private static <T> Map<String, T> getNameHashingStrategy(@NotNull Case casing) {
        if (casing == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(15);
        }
        return casing.sensitive ? new HashMap() : CollectionFactory.createCaseInsensitiveStringMap();
    }

    public static SqlLanguageDialectEx.BuiltinFunctions emptyFunctionDefinition() {
        return new BuiltinFunctionsMap(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }

    public static SqlLanguageDialectEx.BuiltinFunctions loadFunctionDefinition(@NotNull SqlLanguageDialectEx dialect) {
        if (dialect == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(16);
        }
        dialect.getBuiltInTypes();
        Case routineCasing = SqlFunctionsUtil.getCasing(ObjectKind.ROUTINE, dialect);
        Map<String, BuiltinFunction> globalMap = SqlFunctionsUtil.getNameHashingStrategy(routineCasing);
        Map<String, BuiltinFunctionsMap> typeMethods = SqlFunctionsUtil.getNameHashingStrategy(SqlFunctionsUtil.getCasing(ObjectKind.OBJECT_TYPE, dialect));
        Map<String, BuiltinFunctionsMap> typeInstanceMethods = SqlFunctionsUtil.getNameHashingStrategy(SqlFunctionsUtil.getCasing(ObjectKind.OBJECT_TYPE, dialect));
        BuiltinFunctionsMap builtins = new BuiltinFunctionsMap(globalMap, typeMethods, typeInstanceMethods);
        try {
            Class<?> dialectClass = ((Object)((Object)dialect)).getClass();
            SqlFunctionDefinitionParser parser = new SqlFunctionDefinitionParser(dialect);
            for (BuiltinFunction definition : parser.parse(SqlFunctionsUtil.getDialectFunctionDefinitions(dialectClass))) {
                String self = definition.getSelf();
                boolean optionalSelf = definition.isOptionalSelf();
                if (self != null) {
                    String typeName;
                    Map<String, BuiltinFunctionsMap> typeMap = definition.isInstanceMethod() ? typeInstanceMethods : typeMethods;
                    BuiltinFunctionsMap typeBuiltins = typeMap.get(typeName = routineCasing.apply(self));
                    if (typeBuiltins == null) {
                        typeBuiltins = new BuiltinFunctionsMap(SqlFunctionsUtil.getNameHashingStrategy(routineCasing), Collections.emptyMap(), Collections.emptyMap());
                        typeMap.put(typeName, typeBuiltins);
                    }
                    SqlFunctionsUtil.recordBuiltinFunction(routineCasing, definition, typeBuiltins.myMap);
                    if (!optionalSelf) continue;
                    SqlFunctionsUtil.recordBuiltinFunction(routineCasing, definition, globalMap);
                    continue;
                }
                SqlFunctionsUtil.recordBuiltinFunction(routineCasing, definition, globalMap);
            }
        }
        catch (IOException e) {
            SqlDialectImplUtilCore.LOG.error((Throwable)e);
        }
        return builtins;
    }

    private static void recordBuiltinFunction(Case routineCasing, BuiltinFunction definition, Map<String, BuiltinFunction> targetMap) {
        BuiltinFunction def = targetMap.put(routineCasing.apply(definition.getName()), definition);
        assert (def == null) : definition.getName() + " already exists";
        if (routineCasing.sensitive && "true".equals(definition.getDialectAttribute("insensitive"))) {
            targetMap.put(Case.LOWER.apply(definition.getName()), definition);
        }
    }

    @NotNull
    public static String getDialectFunctionDefinitions(Class<?> dialectClass) throws IOException {
        String string = SqlDialectImplUtilCore.loadDialectResource(dialectClass, "functions.xml");
        if (string == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Nullable
    public static SqlReferenceElementType getReferenceType(BuiltinFunction.ReferenceParameter parameter) {
        return (SqlReferenceElementType)SqlTokenRegistry.findCompositeType((String)("SQL_" + parameter.getRefTypeName() + "_REFERENCE"));
    }

    public static boolean isAssignable(BuiltinFunction.Parameter parameter, SqlExpression expression, DasType exprType) {
        if (parameter instanceof BuiltinFunction.ReferenceParameter) {
            SqlReferenceElementType refType = SqlFunctionsUtil.getReferenceType((BuiltinFunction.ReferenceParameter)parameter);
            DasSymbol symbol = expression instanceof SqlReferenceExpression ? DasSymbolUtil.getInlineSymbol(((SqlReferenceExpression)expression).getReference()) : SqlImplUtil.ANY_SYMBOL;
            return refType == null || SqlScopeProcessorBase.acceptsElement(symbol, SqlImplUtil.getSqlDialectSafe((PsiElement)expression), refType.getTargetKind(), false, null);
        }
        if (parameter instanceof BuiltinFunction.SimpleParameter) {
            DataType dataType;
            BuiltinFunction.Type type = ((BuiltinFunction.SimpleParameter)parameter).getType();
            if (type == ANY) {
                return true;
            }
            DasType dasType = type.getDasType();
            DataType dataType2 = dataType = dasType != null ? dasType.toDataType() : null;
            if (dataType == null || "table".equalsIgnoreCase(dataType.typeName) && exprType instanceof SqlTableType) {
                return true;
            }
            return SqlFunctionsUtil.isAssignable(dasType, exprType);
        }
        return false;
    }

    @Nullable
    public static BuiltinFunction.Prototype chooseTheBestPrototype(SqlFunctionCallExpression expression, boolean returnTypeOnly) {
        BuiltinFunction definition = expression.getFunctionDefinition();
        if (definition == null) {
            return null;
        }
        if (returnTypeOnly) {
            BuiltinFunction.Prototype cur = null;
            for (BuiltinFunction.Prototype p2 : definition.getPrototypes()) {
                if (cur == null) {
                    cur = p2;
                    continue;
                }
                if (Comparing.equal((Object)cur.getReturnType(), (Object)p2.getReturnType())) continue;
                cur = null;
                break;
            }
            if (cur != null) {
                return cur;
            }
        }
        Map<BuiltinFunction.Prototype, Map<PsiElement, BuiltinFunction.Parameter>> map = SqlFunctionsUtil.getAcceptedPrototypes(definition, expression.getParameterList());
        BuiltinFunction.Prototype maxMatched = null;
        int maxMatchedCount = -1;
        Map cache = FactoryMap.create(DasTypeAwareObject::getDasType);
        for (BuiltinFunction.Prototype prototype : map.keySet()) {
            Map<PsiElement, BuiltinFunction.Parameter> mapping = map.get(prototype);
            int count = 0;
            for (PsiElement element : mapping.keySet()) {
                if (!(element instanceof SqlExpression) || !SqlFunctionsUtil.isAssignable(mapping.get(element), (SqlExpression)element, (DasType)cache.get(element))) continue;
                ++count;
            }
            if (maxMatchedCount >= count) continue;
            maxMatchedCount = count;
            maxMatched = prototype;
        }
        return maxMatched;
    }

    @NotNull
    private static Map<BuiltinFunction.Prototype, Map<PsiElement, BuiltinFunction.Parameter>> getAcceptedPrototypes(@NotNull BuiltinFunction definition, @Nullable SqlExpressionList parameterList) {
        if (definition == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(18);
        }
        ASTNode[] nodes = SqlFunctionsUtil.getArgNodes(parameterList);
        LinkedHashMap<BuiltinFunction.Prototype, Map<PsiElement, BuiltinFunction.Parameter>> result = new LinkedHashMap<BuiltinFunction.Prototype, Map<PsiElement, BuiltinFunction.Parameter>>();
        for (BuiltinFunction.Prototype prototype : definition.getPrototypes()) {
            LinkedHashMap map = new LinkedHashMap();
            SqlFunctionsUtil.mapArguments(prototype, nodes, (PairProcessor<? super PsiElement, ? super BuiltinFunction.Parameter>)((PairProcessor)(psi, param) -> {
                map.put(psi, param);
                return true;
            }));
            if (map.isEmpty() && prototype.getParams().length != 0) continue;
            result.put(prototype, map);
        }
        LinkedHashMap<BuiltinFunction.Prototype, Map<PsiElement, BuiltinFunction.Parameter>> linkedHashMap = result;
        if (linkedHashMap == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(19);
        }
        return linkedHashMap;
    }

    public static boolean mapArguments(@NotNull BuiltinFunction.Prototype prototype, @Nullable SqlExpressionList parameterList, @NotNull PairProcessor<? super PsiElement, ? super BuiltinFunction.Parameter> processor) {
        if (prototype == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(20);
        }
        if (processor == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(21);
        }
        return SqlFunctionsUtil.mapArguments(prototype, SqlFunctionsUtil.getArgNodes(parameterList), processor);
    }

    private static ASTNode[] getArgNodes(@Nullable SqlExpressionList parameterList) {
        ASTNode astNode = parameterList == null ? null : parameterList.getNode();
        return astNode == null ? ASTNode.EMPTY_ARRAY : astNode.getChildren(null);
    }

    private static boolean mapArguments(@NotNull BuiltinFunction.Prototype prototype, ASTNode @NotNull [] paramNodes, @NotNull PairProcessor<? super PsiElement, ? super BuiltinFunction.Parameter> processor) {
        if (prototype == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(22);
        }
        if (processor == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(23);
        }
        if (paramNodes == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(24);
        }
        if (paramNodes.length == 0) {
            return true;
        }
        PsiElement prev = null;
        for (ASTNode node : paramNodes) {
            BuiltinFunction.Parameter value = SqlInfoElementType.getValue(node, BuiltinFunction.Parameter.class);
            if (value == null) {
                PsiElement psi = node.getPsi();
                if (psi instanceof PsiWhiteSpace || psi instanceof PsiComment) continue;
                prev = psi;
                continue;
            }
            int prototypeId = value.getPrototypeId();
            if (prev == null || prototypeId != prototype.getPrototypeId() && prototypeId != -1 || processor.process((Object)prev, (Object)value)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static Number getSignatureNumber(@NotNull SqlFunctionCallExpression o) {
        if (o == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(25);
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApiReversed();
        SqlExpressionList params = o.getParameterList();
        return params == null ? (Number)null : (Number)((Number)api.children((Object)params).transform(p2 -> SqlInfoElementType.getValue(p2, Number.class)).filter(Conditions.notNull()).first());
    }

    @Nullable
    public static DasRoutine getRoutineOrConstructor(@Nullable DasSymbol symbol) {
        Object object;
        DasObject dasObject = object = symbol != null ? symbol.getDasObject() : null;
        if (symbol != null && symbol.getKind() == ObjectKind.OBJECT_TYPE && !(object instanceof DasUserDefinedType)) {
            object = ObjectUtils.tryCast((Object)DasSymbolUtil.getSinglePsiSource(symbol), DasObject.class);
        }
        if (object instanceof DbElement) {
            object = ((DbElement)object).getDelegate();
        }
        if (object instanceof DasUserDefinedType) {
            return ((DasUserDefinedType)object).getConstructor();
        }
        return (DasRoutine)ObjectUtils.tryCast((Object)object, DasRoutine.class);
    }

    @NotNull
    public static List<Pair<DasRoutine, Boolean>> getNonPredefSignatures(@NotNull SqlFunctionCallExpression o) {
        if (o == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(26);
        }
        SmartList nonPredefSigs = new SmartList();
        SqlReferenceExpression nameElement = o.getNameElement();
        if (nameElement != null) {
            for (ResolveResult resolve : nameElement.multiResolve(false)) {
                if (resolve.getElement() == o) continue;
                boolean isHidden = resolve instanceof SqlResolveResult && ((SqlResolveResult)resolve).isHidden();
                DasSymbol symbol = DasSymbolUtil.getSymbol(resolve);
                DasRoutine routine = SqlFunctionsUtil.getRoutineOrConstructor(symbol);
                if (routine == null) continue;
                ContainerUtil.addIfNotNull((Collection)nonPredefSigs, (Object)Pair.create((Object)routine, (Object)(!isHidden ? 1 : 0)));
            }
        }
        SmartList smartList = nonPredefSigs;
        if (smartList == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(27);
        }
        return smartList;
    }

    @Nullable
    public static DasRoutine findSignature(@Nullable SqlExpressionList args, @NotNull List<? extends DasRoutine> protos) {
        if (protos == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(28);
        }
        return (DasRoutine)ContainerUtil.getFirstItem(protos);
    }

    public static boolean isAssignable(DasTypedObject obj, DasType candidate, SqlLanguageDialectEx dialect) {
        return SqlFunctionsUtil.isAssignable(obj.getDasType(), candidate);
    }

    public static boolean isAssignable(DataType dataType, DasType candidate, SqlLanguageDialectEx dialect) {
        return SqlFunctionsUtil.isAssignable(dialect.getTypeSystem().getTypeCategory(dataType), candidate);
    }

    public static boolean isAssignable(DasType target, DasType candidate) {
        return SqlFunctionsUtil.isAssignable(DasTypeUtilsKt.getCategory((DasType)target), candidate);
    }

    public static boolean isAssignable(@Nullable DasTypeCategory target, DasType candidate) {
        DasTypeCategory candidateCategory = DasTypeUtilsKt.getCategory((DasType)candidate);
        if (target == candidateCategory) {
            return true;
        }
        if (target == DasTypeCategory.REAL && candidateCategory == DasTypeCategory.INTEGER) {
            return true;
        }
        return target == DasTypeCategory.DATE_TIME && (candidateCategory == DasTypeCategory.DATE || candidateCategory == DasTypeCategory.TIME || candidateCategory == DasTypeCategory.TIMESTAMP);
    }

    public static boolean isSingleArgumentRoutine(@Nullable DasObject target) {
        if (target instanceof DbElement) {
            target = (DasObject)ObjectUtils.tryCast((Object)((DbElement)target).getDelegate(), DasRoutine.class);
        }
        if (target instanceof DasRoutine) {
            return SqlFunctionsUtil.getAcceptedArguments(target).single() != null;
        }
        if (target instanceof BuiltinFunction) {
            BuiltinFunction.Prototype[] prototypes;
            for (BuiltinFunction.Prototype prototype : prototypes = ((BuiltinFunction)target).getPrototypes()) {
                if (prototype.getParams().length != 1) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isNoArgumentRoutine(@Nullable DasObject target) {
        if (target instanceof DbElement) {
            target = (DasObject)ObjectUtils.tryCast((Object)((DbElement)target).getDelegate(), DasRoutine.class);
        }
        if (target instanceof DasRoutine) {
            return SqlFunctionsUtil.getAcceptedArguments(target).first() == null;
        }
        if (target instanceof BuiltinFunction) {
            BuiltinFunction.Prototype[] prototypes;
            for (BuiltinFunction.Prototype prototype : prototypes = ((BuiltinFunction)target).getPrototypes()) {
                if (prototype.getParams().length != 0) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static JBIterable<DasArgument> getAcceptedArguments(@Nullable DasObject target) {
        target = target instanceof DbElement ? (DasObject)ObjectUtils.tryCast((Object)((DbElement)target).getDelegate(), DasObject.class) : target;
        return target == null ? JBIterable.empty() : target.getDasChildren(ObjectKind.ARGUMENT).filter(DasArgument.class).filter(a -> !a.getArgumentDirection().isReturnOrResult());
    }

    public static ExpressionList @NotNull [] getOverloads(@NotNull SqlFunctionCallExpression call) {
        SqlReferenceExpression element;
        if (call == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(29);
        }
        boolean notBuiltin = (element = call.getNameElement()) != null && element.getQualifierExpression() != null;
        ArrayList<ExpressionList> prototypes = new ArrayList<ExpressionList>();
        BuiltinFunction def = notBuiltin ? null : call.getFunctionDefinition();
        boolean anyMatched = false;
        if (def != null) {
            Number number = SqlFunctionsUtil.getSignatureNumber(call);
            Set<BuiltinFunction.Location> locations = SqlImplUtil.getSqlDialectSafe((PsiElement)call).getExpectedFunctionLocations((SqlExpression)element);
            for (BuiltinFunction.Prototype proto : def.getPrototypes()) {
                if (!locations.contains(proto.getLocation())) continue;
                boolean matched = number != null && number.intValue() == proto.getPrototypeId();
                anyMatched |= matched;
                prototypes.add(new BuiltinPrototypeWrapper(call, proto, matched));
            }
        }
        for (Pair<DasRoutine, Boolean> sig : SqlFunctionsUtil.getNonPredefSignatures(call)) {
            prototypes.add(new RoutineWrapper(call, (DasRoutine)sig.getFirst(), !anyMatched && (Boolean)sig.getSecond() != false));
        }
        ExpressionList[] expressionListArray = prototypes.toArray(new ExpressionList[0]);
        if (expressionListArray == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(30);
        }
        return expressionListArray;
    }

    public static ExpressionList @NotNull [] getInsertVariants(@NotNull SqlDmlInstruction instruction, @NotNull SqlExpressionList expr) {
        if (instruction == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(31);
        }
        if (expr == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(32);
        }
        ArrayList lists = new ArrayList();
        SqlTableType targetType = instruction.getTargetType();
        lists.add(new ArrayList());
        for (int i = 0; i < targetType.getColumnCount(); ++i) {
            String columnType = null;
            boolean bl = false;
            if (StringUtil.isNotEmpty((String)targetType.getColumnDasType(i).getDescription())) {
                PsiElement resolve;
                PsiElement columnElement = targetType.getColumnElement(i);
                PsiElement psiElement = resolve = columnElement instanceof SqlReferenceExpression ? ((SqlReferenceExpression)columnElement).resolve() : null;
                if (resolve instanceof DasColumn) {
                    columnType = ((DasColumn)resolve).getDasType().getSpecification();
                } else if (columnElement instanceof DasColumn) {
                    columnType = ((DasColumn)columnElement).getDasType().getSpecification();
                    bl = DasUtil.isAuto((DasColumn)((DasColumn)columnElement));
                } else {
                    columnType = targetType.getColumnDasType(i).getDescription();
                }
            }
            if (bl) {
                lists.add(new ArrayList((Collection)lists.get(lists.size() - 1)));
            }
            Pair pair = Pair.create((Object)targetType.getColumnName(i), columnType);
            for (int j = 0; j < lists.size(); ++j) {
                if (j == lists.size() - 1 && bl) continue;
                ((List)lists.get(j)).add(pair);
            }
        }
        ArrayList<ColumnListWrapper> res = new ArrayList<ColumnListWrapper>(lists.size());
        for (List list : lists) {
            res.add(new ColumnListWrapper(list, expr));
        }
        ExpressionList[] expressionListArray = res.toArray(new ExpressionList[0]);
        if (expressionListArray == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(33);
        }
        return expressionListArray;
    }

    public static ExpressionList @NotNull [] getCreateTable(@NotNull SqlCreateStatement createStatement, @NotNull SqlExpressionList expr) {
        ExpressionList[] expressionListArray;
        if (createStatement == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(34);
        }
        if (expr == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(35);
        }
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        for (DasColumn column : DasUtil.getColumns((DasObject)createStatement)) {
            String type = column.getDasType().getSpecification();
            pairs.add((Pair<String, String>)Pair.create((Object)column.getName(), (Object)(StringUtil.isNotEmpty((String)type) ? type : null)));
        }
        if (pairs.isEmpty()) {
            expressionListArray = new ExpressionList[]{};
        } else {
            ExpressionList[] expressionListArray2 = new ExpressionList[1];
            expressionListArray = expressionListArray2;
            expressionListArray2[0] = new ColumnListWrapper(pairs, expr);
        }
        if (expressionListArray == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(36);
        }
        return expressionListArray;
    }

    @NotNull
    public static Collection<DasType> evaluateExpectedTypesForArgument(@Nullable PsiElement place) {
        if (!(place instanceof SqlReferenceExpression)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlFunctionsUtil.$$$reportNull$$$0(37);
            }
            return list;
        }
        PsiElement parent = SqlImplUtil.sqlParent(place);
        if (!(parent instanceof SqlExpressionList)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlFunctionsUtil.$$$reportNull$$$0(38);
            }
            return list;
        }
        int index = ((SqlExpressionList)parent).getExpressionList().indexOf(place);
        if (index < 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlFunctionsUtil.$$$reportNull$$$0(39);
            }
            return list;
        }
        PsiElement callExpression = parent.getParent();
        if (!(callExpression instanceof SqlFunctionCallExpression)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlFunctionsUtil.$$$reportNull$$$0(40);
            }
            return list;
        }
        SqlExpression callable = ((SqlFunctionCallExpression)callExpression).getCallableExpression();
        if (!(callable instanceof SqlReferenceExpression)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlFunctionsUtil.$$$reportNull$$$0(41);
            }
            return list;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(place);
        ResolveResult[] allResults = ((SqlReferenceExpression)callable).multiResolve(true);
        HashSet<DasType> types = new HashSet<DasType>(allResults.length);
        for (ResolveResult result : allResults) {
            DasSymbol symbol = DasSymbolUtil.getSymbol(result);
            DasObject object = symbol != null ? symbol.getDasObject() : null;
            SqlFunctionsUtil.addExpectedTypesFromRoutine(index, dialect, types, (DasRoutine)ObjectUtils.tryCast((Object)object, DasRoutine.class));
            SqlFunctionsUtil.addExpectedTypesFromDefinition(index, types, (BuiltinFunction)ObjectUtils.tryCast((Object)object, BuiltinFunction.class));
        }
        HashSet<DasType> hashSet = types;
        if (hashSet == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(42);
        }
        return hashSet;
    }

    private static void addExpectedTypesFromDefinition(int index, @NotNull Set<? super DasType> types, @Nullable BuiltinFunction definition) {
        if (types == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(43);
        }
        if (definition == null) {
            return;
        }
        block0: for (BuiltinFunction.Prototype prototype : definition.getPrototypes()) {
            BuiltinFunction.Parameter[] params = prototype.getParams();
            if (index >= params.length) continue;
            int currentIndex = 0;
            for (BuiltinFunction.Parameter param : params) {
                if (!(param instanceof BuiltinFunction.SimpleParameter)) continue;
                if (index == currentIndex) {
                    DataType dataType;
                    BuiltinFunction.Type type = ((BuiltinFunction.SimpleParameter)param).getType();
                    DasType dasType = type.getDasType();
                    DataType dataType2 = dataType = dasType != null ? dasType.toDataType() : null;
                    if (dataType == null) continue block0;
                    types.add((DasType)dasType);
                    continue block0;
                }
                ++currentIndex;
            }
        }
    }

    private static void addExpectedTypesFromRoutine(int index, @NotNull SqlLanguageDialectEx dialect, @NotNull Set<? super DasType> types, @Nullable DasRoutine routine) {
        if (dialect == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(44);
        }
        if (types == null) {
            SqlFunctionsUtil.$$$reportNull$$$0(45);
        }
        if (routine == null) {
            return;
        }
        int currentIndex = 0;
        for (DasArgument argument : routine.getArguments()) {
            if (currentIndex == index) {
                @NotNull DasType dasType = argument.getDasType();
                ContainerUtil.addIfNotNull(types, (Object)dasType);
                break;
            }
            ++currentIndex;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 17, 19, 27, 30, 33, 36, 37, 38, 39, 40, 41, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 14: 
            case 17: 
            case 19: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/functions/SqlFunctionsUtil";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prototype";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramNodes";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protos";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/functions/SqlFunctionsUtil";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectFunctionDefinitions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedPrototypes";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonPredefSignatures";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverloads";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertVariants";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateTable";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateExpectedTypesForArgument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addSimpleType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addSimpleTypes";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 14: 
            case 17: 
            case 19: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNameHashingStrategy";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadFunctionDefinition";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAcceptedPrototypes";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "mapArguments";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureNumber";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getNonPredefSignatures";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findSignature";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getOverloads";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getInsertVariants";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getCreateTable";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addExpectedTypesFromDefinition";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addExpectedTypesFromRoutine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 17, 19, 27, 30, 33, 36, 37, 38, 39, 40, 41, 42 -> new IllegalStateException(string);
        };
    }

    private static class BuiltinFunctionsMap
    implements SqlLanguageDialectEx.BuiltinFunctions {
        private final Map<String, BuiltinFunction> myMap;
        private final Map<String, BuiltinFunctionsMap> myTypeMethods;
        private final Map<String, BuiltinFunctionsMap> myTypeInstanceMethods;

        private BuiltinFunctionsMap(Map<String, BuiltinFunction> map, Map<String, BuiltinFunctionsMap> typeMethods, Map<String, BuiltinFunctionsMap> typeInstanceMethods) {
            this.myMap = map;
            this.myTypeMethods = typeMethods;
            this.myTypeInstanceMethods = typeInstanceMethods;
        }

        @Override
        @Nullable
        public BuiltinFunction get(@Nullable String name) {
            return this.myMap.get(name);
        }

        @Override
        public boolean contains(@Nullable String name) {
            return this.myMap.containsKey(name);
        }

        @Override
        @NotNull
        public Iterable<BuiltinFunction> byMatcher(@NotNull PrefixMatcher matcher) {
            if (matcher == null) {
                BuiltinFunctionsMap.$$$reportNull$$$0(0);
            }
            JBIterable jBIterable = JBIterable.from(this.myMap.entrySet()).filterMap(e -> matcher.prefixMatches((String)e.getKey()) ? (BuiltinFunction)e.getValue() : null);
            if (jBIterable == null) {
                BuiltinFunctionsMap.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public Collection<BuiltinFunction> forTokens() {
            Collection<BuiltinFunction> collection = this.myMap.values();
            if (collection == null) {
                BuiltinFunctionsMap.$$$reportNull$$$0(2);
            }
            return collection;
        }

        @Override
        @Nullable
        public SqlLanguageDialectEx.BuiltinFunctions typeMethods(@NotNull String typeName, boolean forInstance) {
            if (typeName == null) {
                BuiltinFunctionsMap.$$$reportNull$$$0(3);
            }
            Map<String, BuiltinFunctionsMap> map = forInstance ? this.myTypeInstanceMethods : this.myTypeMethods;
            return map != null ? (SqlLanguageDialectEx.BuiltinFunctions)map.get(typeName) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/functions/SqlFunctionsUtil$BuiltinFunctionsMap";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/functions/SqlFunctionsUtil$BuiltinFunctionsMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "byMatcher";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "forTokens";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "byMatcher";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "typeMethods";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class BuiltinPrototypeWrapper
    implements ExpressionList {
        private final SqlFunctionCallExpression myCallExpression;
        private final BuiltinFunction.Prototype myPrototype;
        private final boolean myMatched;

        public BuiltinPrototypeWrapper(@NotNull SqlFunctionCallExpression callExpression, @NotNull BuiltinFunction.Prototype prototype, boolean matched) {
            if (callExpression == null) {
                BuiltinPrototypeWrapper.$$$reportNull$$$0(0);
            }
            if (prototype == null) {
                BuiltinPrototypeWrapper.$$$reportNull$$$0(1);
            }
            this.myCallExpression = callExpression;
            this.myPrototype = prototype;
            this.myMatched = matched;
        }

        @Override
        public boolean isValid() {
            return this.myCallExpression.isValid();
        }

        @Override
        public boolean isMatched() {
            return this.myMatched;
        }

        @Override
        public boolean buildText(@NotNull StringBuilder sb, final int paramIdx, int[] paramRange) {
            if (sb == null) {
                BuiltinPrototypeWrapper.$$$reportNull$$$0(2);
            }
            final Ref selectedParam = Ref.create((Object)((BuiltinFunction.Parameter)ArrayUtil.getFirstElement((Object[])this.myPrototype.getParams())));
            SqlFunctionsUtil.mapArguments(this.myPrototype, this.myCallExpression.getParameterList(), (PairProcessor<? super PsiElement, ? super BuiltinFunction.Parameter>)new PairProcessor<PsiElement, BuiltinFunction.Parameter>(this){
                int i = 0;

                public boolean process(PsiElement element, BuiltinFunction.Parameter parameter) {
                    selectedParam.set((Object)parameter);
                    return this.i++ != paramIdx;
                }
            });
            this.myPrototype.toString(sb, (parameter, start) -> {
                if (parameter == selectedParam.get() && selectedParam.get() != BuiltinFunction.COMMA) {
                    paramRange[start.booleanValue() ? 0 : 1] = sb.length();
                }
            });
            sb.append(":").append(this.myPrototype.getReturnType());
            return this.myPrototype.getParams().length == 0;
        }

        @Override
        public boolean processArgumentTypes(@NotNull ExpressionList.ParameterProcessor processor) {
            if (processor == null) {
                BuiltinPrototypeWrapper.$$$reportNull$$$0(3);
            }
            return SqlFunctionsUtil.mapArguments(this.myPrototype, this.myCallExpression.getParameterList(), (PairProcessor<? super PsiElement, ? super BuiltinFunction.Parameter>)((PairProcessor)(psi, param) -> {
                BuiltinFunction.SimpleParameter sparam = (BuiltinFunction.SimpleParameter)ObjectUtils.tryCast((Object)param, BuiltinFunction.SimpleParameter.class);
                if (sparam != null) {
                    return processor.process((PsiElement)psi, sparam.getName(), sparam.getType().getDisplayName());
                }
                return true;
            }));
        }

        public BuiltinFunction.Prototype getPrototype() {
            return this.myPrototype;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prototype";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/dialects/functions/SqlFunctionsUtil$BuiltinPrototypeWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processArgumentTypes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RoutineWrapper
    implements ExpressionList {
        private final SqlFunctionCallExpression myCallExpression;
        private final DasRoutine myRoutine;
        private final boolean myMatched;

        public RoutineWrapper(@NotNull SqlFunctionCallExpression callExpression, @NotNull DasRoutine routine, boolean matched) {
            if (callExpression == null) {
                RoutineWrapper.$$$reportNull$$$0(0);
            }
            if (routine == null) {
                RoutineWrapper.$$$reportNull$$$0(1);
            }
            this.myCallExpression = callExpression;
            this.myRoutine = routine;
            this.myMatched = matched;
        }

        @Override
        public boolean isMatched() {
            return this.myMatched;
        }

        @Override
        public boolean isValid() {
            return this.myCallExpression.isValid();
        }

        public DasRoutine getRoutine() {
            return this.myRoutine;
        }

        @Override
        public boolean buildText(@NotNull StringBuilder sb, int paramIdx, int[] paramRange) {
            if (sb == null) {
                RoutineWrapper.$$$reportNull$$$0(2);
            }
            ASTNode[] astNodes = SqlFunctionsUtil.getArgNodes(this.myCallExpression.getParameterList());
            int selectedIndex = paramIdx == -1 ? (astNodes.length == 0 ? 0 : astNodes.length - 1) : paramIdx;
            DasArgument returnArg = this.myRoutine.getReturnArgument();
            PsiFile file = this.myCallExpression.getContainingFile();
            SqlLanguageDialectEx sqlDialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            DatabaseDialectEx dbDialect = sqlDialect.getDatabaseDialect();
            DdlBuilder ddlBuilder = new DdlBuilder(sb).configureBuilder(SqlCodeStyles.getSqlSettings((PsiFile)file)).withDialect(dbDialect);
            int i = 0;
            JBIterable<? extends DasArgument> parameters = sqlDialect.getSignatureParameters(this.myRoutine);
            for (DasArgument o : parameters) {
                if (o.getArgumentDirection() == ArgumentDirection.OUT && sqlDialect.getDbms().isPostgres()) continue;
                if (i > 0) {
                    sb.append(", ");
                }
                if (i == selectedIndex) {
                    paramRange[0] = sb.length();
                }
                ddlBuilder.identifier((DasObject)o, (String)ObjectUtils.notNull((Object)o.getName(), (Object)"")).symbol(":").keyword(o.getDasType().getSpecification());
                if (i == selectedIndex) {
                    paramRange[1] = sb.length();
                }
                ++i;
            }
            if (returnArg != null) {
                sb.append(":");
                SqlPsiMiscUtil.addReturnTypeText(ddlBuilder, returnArg);
            }
            return true;
        }

        @Override
        public boolean processArgumentTypes(@NotNull ExpressionList.ParameterProcessor processor) {
            PsiElement next;
            SqlExpressionList list;
            if (processor == null) {
                RoutineWrapper.$$$reportNull$$$0(3);
            }
            JBIterable children = (list = this.myCallExpression.getParameterList()) == null ? Collections.emptyList() : SqlImplUtil.childrenIt((PsiElement)list).filter(e -> e instanceof SqlExpression || RoutineWrapper.isComma(e));
            Iterator parIt = SqlImplUtil.getSqlDialectSafe((PsiElement)this.myCallExpression).getSignatureParameters(this.myRoutine).iterator();
            JBIterator psiIt = JBIterator.from(children.iterator());
            if (!psiIt.advance()) {
                return true;
            }
            PsiElement cur = (PsiElement)psiIt.current();
            PsiElement psiElement = next = psiIt.advance() ? (PsiElement)psiIt.current() : null;
            while (parIt.hasNext() && cur != null) {
                DasArgument par = (DasArgument)parIt.next();
                if (!processor.process(cur, par.getName(), DasTypeUtilsKt.getTypeName((DasType)par.getDasType()))) {
                    return false;
                }
                cur = next;
                PsiElement psiElement2 = next = psiIt.advance() ? (PsiElement)psiIt.current() : null;
                if (!RoutineWrapper.isComma(cur) || next == null || RoutineWrapper.isComma(next)) continue;
                cur = next;
                next = psiIt.advance() ? (PsiElement)psiIt.current() : null;
            }
            return true;
        }

        private static boolean isComma(PsiElement e) {
            return PsiUtilCore.getElementType((PsiElement)e) == SqlCommonTokens.SQL_COMMA;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "routine";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/dialects/functions/SqlFunctionsUtil$RoutineWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processArgumentTypes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ExpressionList {
        public boolean isMatched();

        public boolean isValid();

        public boolean buildText(@NotNull StringBuilder var1, int var2, int[] var3);

        public boolean processArgumentTypes(@NotNull ParameterProcessor var1);

        @FunctionalInterface
        public static interface ParameterProcessor {
            public boolean process(@NotNull PsiElement var1, @Nullable String var2, @Nullable String var3);
        }
    }

    public static class ColumnListWrapper
    implements ExpressionList {
        private final List<Pair<String, String>> myColumns;
        private final SqlExpressionList myList;

        public ColumnListWrapper(@NotNull List<Pair<String, String>> columns, @NotNull SqlExpressionList list) {
            if (columns == null) {
                ColumnListWrapper.$$$reportNull$$$0(0);
            }
            if (list == null) {
                ColumnListWrapper.$$$reportNull$$$0(1);
            }
            this.myColumns = columns;
            this.myList = list;
        }

        @Override
        public boolean isMatched() {
            return this.myColumns.size() == this.myList.getExpressionList().size();
        }

        @Override
        public boolean isValid() {
            return this.myList.isValid();
        }

        @Override
        public boolean buildText(@NotNull StringBuilder sb, int paramIdx, int[] paramRange) {
            if (sb == null) {
                ColumnListWrapper.$$$reportNull$$$0(2);
            }
            for (int i = 0; i < this.myColumns.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                if (i == paramIdx) {
                    paramRange[0] = sb.length();
                }
                Pair<String, String> pair = this.myColumns.get(i);
                sb.append((String)pair.first);
                if (StringUtil.isNotEmpty((String)((String)pair.second))) {
                    sb.append(":").append((String)pair.second);
                }
                if (i != paramIdx) continue;
                paramRange[1] = sb.length();
            }
            if (sb.isEmpty()) {
                sb.append(SqlBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
            }
            return true;
        }

        @Override
        public boolean processArgumentTypes(@NotNull ExpressionList.ParameterProcessor processor) {
            if (processor == null) {
                ColumnListWrapper.$$$reportNull$$$0(3);
            }
            List expressions = this.myList.getExpressionList();
            Iterator psiIt = expressions.iterator();
            Iterator<Pair<String, String>> typeIt = this.myColumns.iterator();
            while (typeIt.hasNext() && psiIt.hasNext()) {
                SqlExpression psi = (SqlExpression)psiIt.next();
                Pair<String, String> type = typeIt.next();
                if (processor.process((PsiElement)psi, (String)type.first, (String)type.second)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/dialects/functions/SqlFunctionsUtil$ColumnListWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processArgumentTypes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

