/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.types.DasType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStringLiteralConcatenation;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlLiteralExpressionImpl;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralEscaper;
import com.intellij.sql.psi.impl.SqlStringLiteralManipulator;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStringLiteralExpressionImpl
extends SqlLiteralExpressionImpl
implements SqlStringLiteralExpression {
    public SqlStringLiteralExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlStringLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlStringLiteralExpression((SqlStringLiteralExpression)this);
    }

    @Override
    @NotNull
    public DasType getDasType() {
        DasType dasType = SqlImplUtil.getTypeSystem((PsiElement)this).getStringType();
        if (dasType == null) {
            SqlStringLiteralExpressionImpl.$$$reportNull$$$0(1);
        }
        return dasType;
    }

    public PsiReference getReference() {
        final PsiElement parent = this.getParent();
        if (!(parent instanceof SqlOrderByClause) && !(parent instanceof SqlGroupByClause)) {
            return super.getReference();
        }
        if (parent instanceof SqlStringLiteralConcatenation) {
            return super.getReference();
        }
        SqlReferenceImpl reference = new SqlReferenceImpl((SqlElement)this){

            @Override
            public SqlExpression getQualifierExpression() {
                return parent instanceof SqlReferenceExpression ? ((SqlReferenceExpression)parent).getQualifierExpression() : null;
            }

            @Override
            @NotNull
            public String getReferenceName() {
                String string = StringUtil.notNullize((String)SqlStringLiteralExpressionImpl.this.getValue());
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public TextRange getRangeInElement() {
                TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)SqlStringLiteralExpressionImpl.this);
                if (textRange == null) {
                    1.$$$reportNull$$$0(1);
                }
                return textRange;
            }

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                if (newElementName == null) {
                    1.$$$reportNull$$$0(2);
                }
                return ElementManipulators.handleContentChange((PsiElement)SqlStringLiteralExpressionImpl.this, (String)newElementName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/psi/impl/SqlStringLiteralExpressionImpl$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newElementName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferenceName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRangeInElement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/psi/impl/SqlStringLiteralExpressionImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "handleElementRename";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 2 -> new IllegalArgumentException(string);
                };
            }
        };
        if (reference.resolve() != null) {
            return reference;
        }
        return super.getReference();
    }

    @Nullable
    public String getValue() {
        return SqlStringLiteralManipulator.getLiteralText(this);
    }

    public boolean isValidHost() {
        return true;
    }

    public SqlStringLiteralExpressionImpl updateText(@NotNull String text) {
        if (text == null) {
            SqlStringLiteralExpressionImpl.$$$reportNull$$$0(2);
        }
        SqlExpression expression = SqlPsiElementFactory.createExpressionFromText(text, SqlImplUtil.getSqlDialectSafe((PsiElement)this), (PsiElement)this);
        assert (expression instanceof SqlStringLiteralExpression) : text + "-->" + String.valueOf(expression);
        return (SqlStringLiteralExpressionImpl)this.replace((PsiElement)expression);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new SqlStringLiteralEscaper(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlStringLiteralExpressionImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlStringLiteralExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

