/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh.dialogs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ssh.config.unified.SshConfig;
import com.jetbrains.gateway.ssh.SshMultistagePanelContext;
import com.jetbrains.gateway.ssh.panels.ChooseHostPanel;
import com.jetbrains.gateway.welcomeScreen.MultistagePanelContainer;
import com.jetbrains.gateway.welcomeScreen.MultistagePanelDelegate;
import javax.swing.Action;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001!B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0014J\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lcom/jetbrains/gateway/ssh/dialogs/SshConnectionDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "Lcom/jetbrains/gateway/welcomeScreen/MultistagePanelDelegate;", "Lcom/jetbrains/gateway/ssh/SshMultistagePanelContext;", "host", "", "user", "port", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;I)V", "panelContext", "sshPanel", "Lcom/jetbrains/gateway/ssh/panels/ChooseHostPanel;", "carousel", "Lcom/jetbrains/gateway/welcomeScreen/MultistagePanelContainer;", "sshConfig", "Lcom/intellij/ssh/config/unified/SshConfig;", "getSshConfig", "()Lcom/intellij/ssh/config/unified/SshConfig;", "setSshConfig", "(Lcom/intellij/ssh/config/unified/SshConfig;)V", "createCenterPanel", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "getStyle", "Lcom/intellij/openapi/ui/DialogWrapper$DialogStyle;", "onMultistagePanelDone", "", "context", "onMultistagePanelBack", "Companion", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nSshConnectionDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshConnectionDialog.kt\ncom/jetbrains/gateway/ssh/dialogs/SshConnectionDialog\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,56:1\n13#2:57\n*S KotlinDebug\n*F\n+ 1 SshConnectionDialog.kt\ncom/jetbrains/gateway/ssh/dialogs/SshConnectionDialog\n*L\n17#1:57\n*E\n"})
public final class SshConnectionDialog
extends DialogWrapper
implements MultistagePanelDelegate<SshMultistagePanelContext> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SshMultistagePanelContext panelContext;
    @NotNull
    private final ChooseHostPanel sshPanel;
    @NotNull
    private final MultistagePanelContainer<SshMultistagePanelContext> carousel;
    @Nullable
    private SshConfig sshConfig;
    @NotNull
    private static final Logger LOG;

    public SshConnectionDialog(@NotNull String host2, @NotNull String user, int port) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        super(null);
        this.panelContext = new SshMultistagePanelContext(null, 1, null);
        this.sshPanel = new ChooseHostPanel();
        this.carousel = new MultistagePanelContainer<SshMultistagePanelContext>(CollectionsKt.listOf((Object)this.sshPanel), this.panelContext, this);
        this.init();
        this.sshPanel.fillConfigData(host2, user, port);
    }

    @Nullable
    public final SshConfig getSshConfig() {
        return this.sshConfig;
    }

    public final void setSshConfig(@Nullable SshConfig sshConfig) {
        this.sshConfig = sshConfig;
    }

    @NotNull
    protected MultistagePanelContainer<SshMultistagePanelContext> createCenterPanel() {
        return this.carousel;
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[0];
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        return DialogWrapper.DialogStyle.COMPACT;
    }

    @Override
    public void onMultistagePanelDone(@NotNull SshMultistagePanelContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        LOG.info("Wizard is done. Starting SSH connection flow");
        this.sshConfig = context.getConfig();
        if (this.sshConfig == null) {
            LOG.warn("Invariant is broken: SSH config is null");
        }
        this.doOKAction();
    }

    @Override
    public void onMultistagePanelBack(@NotNull SshMultistagePanelContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        WelcomeFrame.Companion.showNow();
        this.doCancelAction();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SshConnectionDialog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/gateway/ssh/dialogs/SshConnectionDialog$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

