/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.creating;

import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputSettings;
import com.intellij.jupyter.core.jupyter.editor.JupyterEditorCustomizer;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.kotlin.jupyter.core.editor.creating.KotlinJupyterEditorCustomizerKt;
import com.intellij.kotlin.jupyter.core.editor.highlighting.NotebookHighlightingFileManager;
import com.intellij.kotlin.jupyter.core.editor.highlighting.NotebookHighlightingService;
import com.intellij.kotlin.jupyter.core.editor.highlighting.editor.NotebookEditorCreatedListener;
import com.intellij.kotlin.jupyter.core.editor.highlighting.utils.UtilKt;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookApplicationOptions;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookApplicationOptionsProvider;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.kotlin.jupyter.core.util.KotlinNotebookPluginScope;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/creating/KotlinJupyterEditorCustomizer;", "Lcom/intellij/jupyter/core/jupyter/editor/JupyterEditorCustomizer;", "<init>", "()V", "onEditorCreated", "", "project", "Lcom/intellij/openapi/project/Project;", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "intellij.kotlin.jupyter.core"})
public final class KotlinJupyterEditorCustomizer
implements JupyterEditorCustomizer {
    public void onEditorCreated(@NotNull Project project, @NotNull TextEditor textEditor, @NotNull BackedNotebookVirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)textEditor, (String)"textEditor");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (!IsKotlinNotebookKt.isKotlinNotebook(virtualFile.getFile())) {
            return;
        }
        KotlinNotebookApplicationOptionsProvider options2 = KotlinNotebookApplicationOptions.INSTANCE.get();
        textEditor.putUserData(FoldingUpdate.INJECTED_CODE_FOLDING_ENABLED, (Object)options2.getShouldShowFoldings());
        Editor editor = textEditor.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        if (JupyterEditorExtensionsKt.isJupyter((Editor)editor2)) {
            if (!KotlinJupyterEditorCustomizerKt.access$getInputDataCellsEnabledInKotlinNotebook()) {
                JupyterDataInputSettings.INSTANCE.disableInputCellsForEditor(editor2);
            }
            NotebookHighlightingFileManager highlightingService = NotebookHighlightingService.Companion.getForFile(project, virtualFile);
            EditorImpl editorImpl = editor2 instanceof EditorImpl ? (EditorImpl)editor2 : null;
            if (editorImpl == null || (editorImpl = editorImpl.getDisposable()) == null) {
                editorImpl = highlightingService;
            }
            EditorImpl parentDisposable = editorImpl;
            BuildersKt.async$default((CoroutineScope)KotlinNotebookPluginScope.Companion.getForProject(project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, editor2, virtualFile, null){
                int label;
                final /* synthetic */ Project $project;
                final /* synthetic */ Editor $editor;
                final /* synthetic */ BackedNotebookVirtualFile $virtualFile;
                {
                    this.$project = $project;
                    this.$editor = $editor;
                    this.$virtualFile = $virtualFile;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            ((NotebookEditorCreatedListener)this.$project.getMessageBus().syncPublisher(NotebookEditorCreatedListener.Companion.getTOPIC())).editorCreated(this.$editor, this.$virtualFile);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)parentDisposable);
            Topic topic = EditorColorsManager.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, arg_0 -> KotlinJupyterEditorCustomizer.onEditorCreated$lambda$0(virtualFile, project, arg_0));
        }
    }

    private static final void onEditorCreated$lambda$0(BackedNotebookVirtualFile $virtualFile, Project $project, EditorColorsScheme it) {
        UtilKt.reactOnThemeChangedEvent($virtualFile, $project);
    }
}

