/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.language;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.scratch.ScratchFileCreationHelper;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileExtensionsKt;
import com.intellij.kotlin.jupyter.core.jupyter.actions.CreateNotebookFactory;
import com.intellij.kotlin.jupyter.core.jupyter.actions.NotebookMode;
import com.intellij.kotlin.jupyter.core.language.NotebookTemplateKt;
import com.intellij.kotlin.jupyter.core.projectWizard.KotlinNotebookRootTypeKt;
import com.intellij.kotlin.jupyter.core.projectWizard.KotlinNotebookWelcomeTabFactoryKt;
import com.intellij.kotlin.jupyter.core.resources.i18n.KotlinNotebookBundle;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ApplicationKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/kotlin/jupyter/core/language/JupyterKotlinScratchCreationHelper;", "Lcom/intellij/ide/scratch/ScratchFileCreationHelper;", "<init>", "()V", "prepareText", "", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/ide/scratch/ScratchFileCreationHelper$Context;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.kotlin.jupyter.core"})
public final class JupyterKotlinScratchCreationHelper
extends ScratchFileCreationHelper {
    public boolean prepareText(@NotNull Project project, @NotNull ScratchFileCreationHelper.Context context, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        try {
            ApplicationKt.getApplication().runWriteAction(() -> JupyterKotlinScratchCreationHelper.prepareText$lambda$0(project, dataContext, context));
        }
        catch (Exception ex) {
            Object[] objectArray = new Object[1];
            String string = ex.getMessage();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            String message = KotlinNotebookBundle.message("action.CreateNewScratchKotlinNotebook.error.dialog.text", objectArray);
            throw new IllegalStateException(message, ex);
        }
        return true;
    }

    private static final void prepareText$lambda$0(Project $project, DataContext $dataContext, ScratchFileCreationHelper.Context $context) {
        ScratchFileCreationHelper.Context context;
        File file = FileUtil.generateRandomTemporaryPath((String)"kotlin-notebook", (String)"");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"generateRandomTemporaryPath(...)");
        File tempDir = file;
        String fileName = "template.ipynb";
        VirtualFile dir = VfsUtil.createDirectories((String)tempDir.getPath());
        PsiDirectory psiDirectory = PsiManager.getInstance((Project)$project).findDirectory(dir);
        Intrinsics.checkNotNull((Object)psiDirectory);
        PsiDirectory psiDir = psiDirectory;
        FileTemplate fileTemplate = (FileTemplate)NotebookTemplateKt.getFILE_TEMPLATE_KEY().getData($dataContext);
        if (fileTemplate == null) {
            Project project = psiDir.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            fileTemplate = NotebookTemplateKt.getEmptyNotebookTemplate(project);
        }
        FileTemplate notebookTemplate = fileTemplate;
        PsiFile psiFile = CreateNotebookFactory.createFileFromTemplate$default(CreateNotebookFactory.INSTANCE, fileName, notebookTemplate, psiDir, null, false, NotebookMode.LIGHT, 8, null);
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile tempFile = psiFile;
        VirtualFile virtualFile = tempFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        String notebookJsonText = JupyterFileExtensionsKt.getGetOrReadJsonText((VirtualFile)virtualFile);
        ScratchFileCreationHelper.Context $this$prepareText_u24lambda_u240_u240 = context = $context;
        boolean bl = false;
        $this$prepareText_u24lambda_u240_u240.text = notebookJsonText;
        $this$prepareText_u24lambda_u240_u240.language = null;
        $this$prepareText_u24lambda_u240_u240.fileExtension = JupyterFileType.INSTANCE.getDefaultExtension();
        $this$prepareText_u24lambda_u240_u240.createOption = ScratchFileService.Option.create_new_always;
        if (KotlinNotebookWelcomeTabFactoryKt.getKotlinNotebookWelcomeFeaturesEnabled()) {
            $this$prepareText_u24lambda_u240_u240.filePrefix = "notebook";
            $this$prepareText_u24lambda_u240_u240.defaultRootType = KotlinNotebookRootTypeKt.getKotlinNotebookRootTypeInstance();
        }
        psiDir.delete();
    }
}

