/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.TextRegex;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u001a\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\b\u001a\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"getObjectLabel", "Lkotlin/Pair;", "", "element", "Lcom/intellij/psi/PsiElement;", "getSelectorMatchLabel", "getLabel", "labelsMatch", "", "matchLabels", "Lorg/jetbrains/yaml/psi/YAMLMapping;", "declaredLabels", "isLabelTextValid", "text", "isKey", "regex", "Lcom/intellij/kubernetes/TextRegex;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesLabelUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLabelUtil.kt\ncom/intellij/kubernetes/KubernetesLabelUtilKt\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n19#2:113\n1869#3,2:114\n*S KotlinDebug\n*F\n+ 1 KubernetesLabelUtil.kt\ncom/intellij/kubernetes/KubernetesLabelUtilKt\n*L\n18#1:113\n44#1:114,2\n*E\n"})
public final class KubernetesLabelUtilKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final Pair<String, String> getObjectLabel(@NotNull PsiElement element) {
        YAMLKeyValue yAMLKeyValue;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        YAMLKeyValue yAMLKeyValue2 = (YAMLKeyValue)YamlUtilKt.getTypedAncestorOrSelf((PsiElement)element, YAMLKeyValue.class);
        if (yAMLKeyValue2 == null) {
            return null;
        }
        YAMLKeyValue labelKeyValue = yAMLKeyValue2;
        YamlMetaType yamlMetaType = KubernetesUtilKt.getK8sMetaType((YAMLPsiElement)labelKeyValue);
        if (yamlMetaType == null) {
            return null;
        }
        YamlMetaType labelContainerType = yamlMetaType;
        if (!KubernetesUtilKt.isKubernetesLabelContainer(labelContainerType)) {
            return null;
        }
        YAMLKeyValue it = yAMLKeyValue = labelKeyValue;
        boolean bl = false;
        YAMLMapping yAMLMapping = it.getParentMapping();
        YAMLMapping yAMLMapping2 = yAMLMapping;
        if (yAMLMapping == null) return null;
        PsiElement psiElement = yAMLMapping2.getParent();
        yAMLMapping2 = psiElement;
        if (psiElement == null) return null;
        YAMLMapping $this$asSafely$iv = yAMLMapping2;
        boolean $i$f$asSafely = false;
        YAMLMapping yAMLMapping3 = $this$asSafely$iv;
        if (!(yAMLMapping3 instanceof YAMLPsiElement)) {
            yAMLMapping3 = null;
        }
        YAMLPsiElement yAMLPsiElement = (YAMLPsiElement)yAMLMapping3;
        yAMLMapping2 = yAMLPsiElement;
        if (yAMLPsiElement == null) return null;
        YamlMetaType yamlMetaType2 = KubernetesUtilKt.getK8sMetaType((YAMLPsiElement)yAMLMapping2);
        yAMLMapping2 = yamlMetaType2;
        if (yamlMetaType2 == null) return null;
        if (!KubernetesUtilKt.isObjectMeta((YamlMetaType)yAMLMapping2)) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        YAMLKeyValue yAMLKeyValue3 = yAMLKeyValue;
        YAMLKeyValue yAMLKeyValue4 = yAMLKeyValue3;
        if (yAMLKeyValue4 == null) return null;
        Pair pair = YamlUtilKt.getEffectiveTextPair((YAMLKeyValue)yAMLKeyValue4);
        return pair;
    }

    @Nullable
    public static final Pair<String, String> getSelectorMatchLabel(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)YamlUtilKt.getTypedAncestorOrSelf((PsiElement)element, YAMLKeyValue.class);
        if (yAMLKeyValue == null) {
            return null;
        }
        YAMLKeyValue labelKeyValue = yAMLKeyValue;
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = KubernetesUtilKt.getK8sMetaTypeProxy((YAMLPsiElement)labelKeyValue);
        if (metaTypeProxy == null) {
            return null;
        }
        YamlMetaTypeProvider.MetaTypeProxy labelContainerTypeProxy = metaTypeProxy;
        YamlMetaType yamlMetaType = labelContainerTypeProxy.getMetaType();
        Intrinsics.checkNotNullExpressionValue((Object)yamlMetaType, (String)"getMetaType(...)");
        if (!KubernetesUtilKt.isKubernetesLabelContainer(yamlMetaType)) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)labelContainerTypeProxy.getField().getName(), (Object)"selector") && !Intrinsics.areEqual((Object)labelContainerTypeProxy.getField().getName(), (Object)"matchLabels")) {
            return null;
        }
        return YamlUtilKt.getEffectiveTextPair((YAMLKeyValue)labelKeyValue);
    }

    @Nullable
    public static final Pair<String, String> getLabel(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Pair<String, String> pair = KubernetesLabelUtilKt.getObjectLabel(element);
        if (pair == null) {
            pair = KubernetesLabelUtilKt.getSelectorMatchLabel(element);
        }
        return pair;
    }

    public static final boolean labelsMatch(@NotNull YAMLMapping matchLabels, @NotNull YAMLMapping declaredLabels) {
        Intrinsics.checkNotNullParameter((Object)matchLabels, (String)"matchLabels");
        Intrinsics.checkNotNullParameter((Object)declaredLabels, (String)"declaredLabels");
        boolean cleanLabelsPresent = false;
        Collection collection = matchLabels.getKeyValues();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getKeyValues(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            YAMLKeyValue matchLabel;
            block4: {
                block3: {
                    YAMLKeyValue yAMLKeyValue;
                    matchLabel = (YAMLKeyValue)element$iv;
                    boolean bl = false;
                    if (YamlUtilKt.containsOtherLanguageElement$default((YAMLPsiElement)((YAMLPsiElement)matchLabel), null, (int)2, null)) continue;
                    cleanLabelsPresent = true;
                    Intrinsics.checkNotNull((Object)matchLabel);
                    object = YamlUtilKt.getKeyValueByKeyIgnoreSpaces((YAMLMapping)declaredLabels, (String)YamlUtilKt.getEffectiveKeyText((YAMLKeyValue)matchLabel));
                    if (object == null) break block3;
                    YAMLKeyValue it = yAMLKeyValue = object;
                    boolean bl2 = false;
                    object = !YamlUtilKt.containsOtherLanguageElement$default((YAMLPsiElement)((YAMLPsiElement)it), null, (int)2, null) ? yAMLKeyValue : null;
                    if (object != null) break block4;
                }
                return false;
            }
            YAMLKeyValue declaredLabel = object;
            if (Intrinsics.areEqual((Object)YamlUtilKt.getEffectiveValueText((YAMLKeyValue)declaredLabel), (Object)YamlUtilKt.getEffectiveValueText((YAMLKeyValue)matchLabel))) continue;
            return false;
        }
        return cleanLabelsPresent;
    }

    public static final boolean isLabelTextValid(@NotNull String text, boolean isKey) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return KubernetesLabelUtilKt.isLabelTextValid(text, isKey ? TextRegex.KEY : TextRegex.VALUE);
    }

    public static final boolean isLabelTextValid(@NotNull String text, @NotNull TextRegex regex) {
        String name;
        String prefix;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)regex), (String)"regex");
        if (!regex.matches(text)) {
            return false;
        }
        if (regex == TextRegex.MERGE_KEY) {
            return true;
        }
        char[] cArray = new char[]{'/'};
        List parts = StringsKt.split$default((CharSequence)text, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        int n = parts.size();
        if (!(1 <= n ? n < 3 : false)) {
            return false;
        }
        String string = prefix = parts.size() == 2 ? (String)parts.get(0) : null;
        if (prefix != null && prefix.length() > 253) {
            return false;
        }
        String string2 = name = parts.size() == 2 ? (String)parts.get(1) : (String)parts.get(0);
        if (regex == TextRegex.VALUE && ((CharSequence)name).length() == 0) {
            return true;
        }
        if (name.length() > 63) {
            return false;
        }
        if (!Character.isLetterOrDigit(StringsKt.first((CharSequence)name))) {
            return false;
        }
        return Character.isLetterOrDigit(StringsKt.last((CharSequence)name));
    }
}

