/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.debug;

import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.debug.KubectlDebugParameters;
import com.intellij.kubernetes.debug.KubectlDebugUtilsKt;
import com.intellij.kubernetes.debug.KubectlDebugWithSpecifiedParamsAction;
import com.intellij.kubernetes.view.ui.actions.ActionUtilsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import io.kubernetes.client.openapi.models.V1Pod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b \u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\nH$J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010\t\u001a\u00020\nH$J\b\u0010\u0015\u001a\u00020\u0012H$J\b\u0010\u0016\u001a\u00020\u0012H$J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH$\u00a8\u0006\u0018"}, d2={"Lcom/intellij/kubernetes/debug/KubectlDebugMultipleTargetsActionGroupBase;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabledAndVisible", "", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "getPod", "", "getTargets", "", "getImage", "getOptionalParameters", "getExecutable", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubectlDebugMultipleTargetsActionGroupBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubectlDebugMultipleTargetsActionGroupBase.kt\ncom/intellij/kubernetes/debug/KubectlDebugMultipleTargetsActionGroupBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,67:1\n1563#2:68\n1634#2,3:69\n37#3,2:72\n*S KotlinDebug\n*F\n+ 1 KubectlDebugMultipleTargetsActionGroupBase.kt\ncom/intellij/kubernetes/debug/KubectlDebugMultipleTargetsActionGroupBase\n*L\n46#1:68\n46#1:69,3\n58#1:72,2\n*E\n"})
public abstract class KubectlDebugMultipleTargetsActionGroupBase
extends DefaultActionGroup
implements DumbAware {
    @NotNull
    public final ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public final void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!KubectlDebugUtilsKt.isKubectlDebugSupportEnabled()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(this.isEnabledAndVisible(e));
    }

    private final boolean isEnabledAndVisible(AnActionEvent e) {
        return ActionUtilsKt.getBackendApiModel((AnActionEvent)e) != null && this.getPod(e) != null && this.getTargets(e).size() > 1;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @NotNull
    public final AnAction[] getChildren(@Nullable AnActionEvent e) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        if (e == null) {
            return new AnAction[0];
        }
        KubernetesApiModel kubernetesApiModel = ActionUtilsKt.getBackendApiModel((AnActionEvent)e);
        if (kubernetesApiModel == null) {
            return new AnAction[0];
        }
        KubernetesApiModel apiModel2 = kubernetesApiModel;
        String string = this.getPod(e);
        if (string == null) {
            return new AnAction[0];
        }
        String pod = string;
        String image = this.getImage();
        String optionalParameters = this.getOptionalParameters();
        String executable = this.getExecutable(e);
        V1Pod selectedPod2 = (V1Pod)KubectlDebugUtilsKt.getSelectedPodAndContainer(e).component1();
        if (selectedPod2 == null) {
            return new AnAction[0];
        }
        Iterable iterable = this.getTargets(e);
        boolean $i$f$map = false;
        void var10_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void target;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KubectlDebugParameters debugParameters = new KubectlDebugParameters(apiModel2.getNamespace(), pod, (String)target, image, optionalParameters, executable);
            void actionName = target;
            collection.add(new KubectlDebugWithSpecifiedParamsAction((KubernetesApiModelInterface)apiModel2, debugParameters, (String)actionName));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new AnAction[0]);
    }

    @Nullable
    protected abstract String getPod(@NotNull AnActionEvent var1);

    @NotNull
    protected abstract List<String> getTargets(@NotNull AnActionEvent var1);

    @NotNull
    protected abstract String getImage();

    @NotNull
    protected abstract String getOptionalParameters();

    @NotNull
    protected abstract String getExecutable(@NotNull AnActionEvent var1);
}

