/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.logs.KubernetesLogStateManager;
import com.intellij.kubernetes.logs.KubernetesTextLogFilterSettings;
import com.intellij.kubernetes.logs.TimeSlice;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"diff", "", "Lcom/intellij/kubernetes/logs/TimeSlice;", "other", "collectUsages", "", "stateManager", "Lcom/intellij/kubernetes/logs/KubernetesLogStateManager;", "newSettings", "Lcom/intellij/kubernetes/logs/KubernetesTextLogFilterSettings;", "snapshot", "intellij.clouds.kubernetes.backend"})
public final class KubernetesLogFiltersKt {
    @NotNull
    public static final List<TimeSlice> diff(@NotNull TimeSlice $this$diff, @NotNull TimeSlice other) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$diff), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)other), (String)"other");
        if ($this$diff.getBeginTime() == null || $this$diff.getEndTime() == null) {
            return CollectionsKt.emptyList();
        }
        if (other.getBeginTime() == null || other.getEndTime() == null) {
            return CollectionsKt.listOf((Object)((Object)$this$diff));
        }
        if ($this$diff.getBeginTime().compareTo(other.getEndTime()) > 0) {
            return CollectionsKt.listOf((Object)((Object)new TimeSlice(other.getEndTime(), $this$diff.getEndTime())));
        }
        if ($this$diff.getEndTime().compareTo(other.getBeginTime()) < 0) {
            return CollectionsKt.listOf((Object)((Object)new TimeSlice($this$diff.getBeginTime(), other.getBeginTime())));
        }
        List result2 = new ArrayList();
        if ($this$diff.getBeginTime().compareTo(other.getBeginTime()) < 0) {
            result2.add(new TimeSlice($this$diff.getBeginTime(), other.getBeginTime()));
        }
        if ($this$diff.getEndTime().compareTo(other.getEndTime()) > 0) {
            result2.add(new TimeSlice(other.getEndTime(), $this$diff.getEndTime()));
        }
        return result2;
    }

    private static final void collectUsages(KubernetesLogStateManager stateManager, KubernetesTextLogFilterSettings newSettings, KubernetesTextLogFilterSettings snapshot) {
        if (!Intrinsics.areEqual((Object)newSettings.getRequest(), (Object)snapshot.getRequest())) {
            KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(stateManager.getApiModel$intellij_clouds_kubernetes_backend().getProject(), (Object)"logs-log-text-filter-used-action");
        }
        if (newSettings.getUseRegex() != snapshot.getUseRegex()) {
            KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(stateManager.getApiModel$intellij_clouds_kubernetes_backend().getProject(), (Object)"logs-log-text-filter-use-regex-selected");
        }
        if (newSettings.getMatchCase() != snapshot.getMatchCase()) {
            KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(stateManager.getApiModel$intellij_clouds_kubernetes_backend().getProject(), (Object)"logs-log-text-filter-match-case-selected");
        }
    }

    public static final /* synthetic */ void access$collectUsages(KubernetesLogStateManager stateManager, KubernetesTextLogFilterSettings newSettings, KubernetesTextLogFilterSettings snapshot) {
        KubernetesLogFiltersKt.collectUsages(stateManager, newSettings, snapshot);
    }
}

