/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.view;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.data.utils.SpringDataBundle;
import com.intellij.spring.data.utils.model.RepositoriesSearchUtil;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.toolWindow.beans.SpringBeanStereotype;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/spring/data/commons/view/SpringRepositoryStereotype;", "Lcom/intellij/spring/toolWindow/beans/SpringBeanStereotype;", "<init>", "()V", "accept", "", "pointer", "Lcom/intellij/spring/model/SpringBeanPointer;", "module", "Lcom/intellij/openapi/module/Module;", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "intellij.spring.data"})
public final class SpringRepositoryStereotype
extends SpringBeanStereotype {
    public SpringRepositoryStereotype() {
        Supplier<String> supplier = SpringDataBundle.messagePointer("spring.data.repository", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        super("repository", null, supplier);
    }

    public boolean accept(@NotNull SpringBeanPointer<?> pointer, @NotNull Module module) {
        Intrinsics.checkNotNullParameter(pointer, (String)"pointer");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return RepositoriesSearchUtil.getAllRepositories(module, true).contains(pointer.getSpringBean());
    }

    @Nullable
    public PsiElement getDocumentationElement(@NotNull SpringBeanPointer<?> pointer) {
        Intrinsics.checkNotNullParameter(pointer, (String)"pointer");
        PsiClass psiClass = pointer.getBeanClass();
        return psiClass != null ? (PsiElement)psiClass : super.getDocumentationElement(pointer);
    }
}

