/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.compiler.util.InspectionValidatorWrapper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnchorOwner;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UastContextKt;

public abstract class CdiBaseInspection
extends AbstractBaseUastLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CdiBaseInspection.$$$reportNull$$$0(0);
        }
        if (InspectionValidatorWrapper.isCompilationThread()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                CdiBaseInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)holder.getFile());
        if (module == null || !CdiCommonUtils.isCdiInstalled(module)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                CdiBaseInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            CdiBaseInspection.$$$reportNull$$$0(3);
        }
        return psiElementVisitor;
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiElement sourcePsi;
        if (uClass == null) {
            CdiBaseInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            CdiBaseInspection.$$$reportNull$$$0(5);
        }
        if ((sourcePsi = uClass.getSourcePsi()) == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiFile containingFile = sourcePsi.getContainingFile();
        ProblemsHolder holder = new ProblemsHolder(manager, containingFile, isOnTheFly);
        List problemDescriptors = holder.getResults();
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)containingFile);
        if (module == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiClass psiElement = uClass.getJavaPsi();
        this.checkClassInternal(psiElement, holder, module);
        return problemDescriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private void checkClassInternal(@NotNull PsiClass aClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (aClass == null) {
            CdiBaseInspection.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            CdiBaseInspection.$$$reportNull$$$0(7);
        }
        if (module == null) {
            CdiBaseInspection.$$$reportNull$$$0(8);
        }
        this.checkClass(aClass, holder, module);
        for (PsiClass psiClass : aClass.getInnerClasses()) {
            ProgressManager.checkCanceled();
            this.checkClass(psiClass, holder, module);
        }
    }

    protected void checkClass(@NotNull PsiClass aClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (aClass == null) {
            CdiBaseInspection.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            CdiBaseInspection.$$$reportNull$$$0(10);
        }
        if (module == null) {
            CdiBaseInspection.$$$reportNull$$$0(11);
        }
    }

    protected static void registerProblem(@NotNull ProblemsHolder holder, @Nullable PsiElement problemElement, @NotNull @InspectionMessage String inspectionMessage) {
        if (holder == null) {
            CdiBaseInspection.$$$reportNull$$$0(12);
        }
        if (inspectionMessage == null) {
            CdiBaseInspection.$$$reportNull$$$0(13);
        }
        if (problemElement != null) {
            holder.registerProblem(problemElement, inspectionMessage, new LocalQuickFix[0]);
        }
    }

    @Nullable
    protected static PsiElement getIdentifyingElement(@Nullable PsiAnnotation psiAnnotation) {
        UAnchorOwner uAnchorOwner = (UAnchorOwner)UastContextKt.toUElement((PsiElement)psiAnnotation, UAnchorOwner.class);
        if (uAnchorOwner != null && uAnchorOwner.getUastAnchor() != null) {
            return uAnchorOwner.getUastAnchor().getSourcePsi();
        }
        return null;
    }

    @Nullable
    protected static PsiElement getIdentifyingElement(@Nullable PsiModifierListOwner psiElement) {
        UDeclaration uDeclaration = (UDeclaration)UastContextKt.toUElement((PsiElement)psiElement, UDeclaration.class);
        if (uDeclaration != null && uDeclaration.getUastAnchor() != null) {
            return uDeclaration.getUastAnchor().getSourcePsi();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/highlighting/CdiBaseInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/highlighting/CdiBaseInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkClassInternal";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

