/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.constants.CdiAnnoConstants;
import com.intellij.javaee.ejb.EjbHelper;
import com.intellij.javaee.ejb.model.EjbAnnotationConstants;
import com.intellij.javaee.ejb.model.EnterpriseBean;
import com.intellij.javaee.ejb.model.SessionBean;
import com.intellij.javaee.ejb.model.common.enums.SessionType;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class CdiScopeInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(@NotNull PsiClass psiClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (psiClass == null) {
            CdiScopeInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CdiScopeInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            CdiScopeInspection.$$$reportNull$$$0(2);
        }
        CdiScopeInspection.checkSingletonBeanScopes(psiClass, holder);
        CdiScopeInspection.checkStatelessSessionBeanScope(psiClass, holder);
    }

    private static void checkStatelessSessionBeanScope(PsiClass aClass, ProblemsHolder holder) {
        if (CdiScopeInspection.isSessionStatelessBean(aClass) && !CdiScopeInspection.isBeanOfScopeType(aClass, CdiAnnoConstants.DEPENDENT_ANNOTATION.fqn((PsiElement)aClass))) {
            CdiScopeInspection.registerProblem(holder, CdiScopeInspection.getIdentifyingElement((PsiModifierListOwner)aClass), CdiInspectionBundle.message("CdiScopeInspection.session.stateless.bean.incorrect.scopes", new Object[0]));
        }
    }

    private static boolean isSessionStatelessBean(@NotNull PsiClass aClass) {
        EjbHelper ejbHelper;
        if (aClass == null) {
            CdiScopeInspection.$$$reportNull$$$0(3);
        }
        if ((ejbHelper = EjbHelper.getEjbHelper()) == null) {
            return AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, Arrays.asList(EjbAnnotationConstants.STATELESS_ANNO.all()), (int)8);
        }
        for (EjbClassRole role : ejbHelper.getEjbRoles(aClass)) {
            EnterpriseBean bean = role.getEnterpriseBean();
            if (!(bean instanceof SessionBean)) continue;
            return SessionType.STATELESS.equals(((SessionBean)bean).getSessionType().getValue());
        }
        return false;
    }

    private static void checkSingletonBeanScopes(PsiClass psiClass, ProblemsHolder holder) {
        PsiAnnotation singletonAnno = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{CdiAnnoConstants.SINGLETON_ANNOTATION.fqn((PsiElement)psiClass)});
        if (singletonAnno != null && !CdiScopeInspection.isBeanOfScopeType(psiClass, CdiAnnoConstants.APPLICATION_SCOPED_ANNOTATION.fqn((PsiElement)psiClass), CdiAnnoConstants.DEPENDENT_ANNOTATION.fqn((PsiElement)psiClass))) {
            CdiScopeInspection.registerProblem(holder, CdiScopeInspection.getIdentifyingElement(singletonAnno), CdiInspectionBundle.message("CdiScopeInspection.singleton.bean.incorrect.scopes", new Object[0]));
        }
    }

    private static boolean isBeanOfScopeType(PsiClass psiClass, String ... scopeTypes) {
        PsiClass type = CdiDescriptorsFactory.createCdiBeanDescriptor(psiClass).getScopeType();
        if (type != null) {
            String qualifiedName = type.getQualifiedName();
            for (String scopeType : scopeTypes) {
                if (!scopeType.equals(qualifiedName)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cdi/highlighting/CdiScopeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSessionStatelessBean";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

