/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.ManagedBeanDescriptor;
import com.intellij.cdi.beans.ProducerBeanDescriptor;
import com.intellij.cdi.highlighting.CdiBeanDescriptorInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.constants.CdiAnnoConstants;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class CdiUnknownProducersForDisposerMethodInspection
extends CdiBeanDescriptorInspection {
    @Override
    protected void checkManagedBean(ManagedBeanDescriptor descriptor, ProblemsHolder holder) {
        PsiClass annotatedItem = descriptor.getAnnotatedItem();
        String disposesAnno = CdiAnnoConstants.DISPOSES_ANNOTATION.fqn((PsiElement)annotatedItem);
        for (PsiMethod method : CdiCommonUtils.getDisposerMethods(annotatedItem)) {
            for (PsiParameter psiParameter : CdiUnknownProducersForDisposerMethodInspection.getDisposeParameters(method)) {
                PsiAnnotation annotation;
                if (!CdiUnknownProducersForDisposerMethodInspection.getProducerDescriptors(psiParameter).isEmpty() || (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiParameter, (String[])new String[]{disposesAnno})) == null) continue;
                CdiUnknownProducersForDisposerMethodInspection.registerProblem(holder, CdiUnknownProducersForDisposerMethodInspection.getIdentifyingElement(annotation), CdiInspectionBundle.message("CdiUnknownProducersForDisposerMethodInspection.cannot.find.corresponding.producers", new Object[0]));
            }
        }
    }

    @NotNull
    public static Set<CdiBeanDescriptor<?>> getProducerDescriptors(@NotNull PsiParameter psiParameter) {
        if (psiParameter == null) {
            CdiUnknownProducersForDisposerMethodInspection.$$$reportNull$$$0(0);
        }
        Collection<CdiBeanDescriptor<?>> beans = CdiInjectionUtils.getInjectedBeans((PsiModifierListOwner)psiParameter, psiParameter.getType(), true, true, true);
        Set<CdiBeanDescriptor<?>> set = beans.stream().filter(ds -> ds instanceof ProducerBeanDescriptor).collect(Collectors.toSet());
        if (set == null) {
            CdiUnknownProducersForDisposerMethodInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    private static Set<PsiParameter> getDisposeParameters(@NotNull PsiMethod method) {
        if (method == null) {
            CdiUnknownProducersForDisposerMethodInspection.$$$reportNull$$$0(2);
        }
        HashSet<PsiParameter> disposedParameters = new HashSet<PsiParameter>();
        for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, (String)CdiAnnoConstants.DISPOSES_ANNOTATION.fqn((PsiElement)method), (int)0)) continue;
            disposedParameters.add(psiParameter);
        }
        return disposedParameters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiParameter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/highlighting/CdiUnknownProducersForDisposerMethodInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/highlighting/CdiUnknownProducersForDisposerMethodInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducerDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProducerDescriptors";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDisposeParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

