/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.css.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssImageUtil {
    private static final String BACKGROUND_IMAGE_PROPERTY_NAME = "background-image";
    private static final String BACKGROUND_PROPERTY_NAME = "background";
    private static final List<String> supportedExtensions = Arrays.asList(ImageIO.getReaderFormatNames());

    private CssImageUtil() {
    }

    @NotNull
    public static Collection<CssUri> findBackgroundImageUris(@NotNull PsiElement element) {
        Collection uris;
        CssDeclaration declaration;
        if (element == null) {
            CssImageUtil.$$$reportNull$$$0(0);
        }
        if ((declaration = (CssDeclaration)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{CssDeclaration.class})) != null && CssImageUtil.isBackgroundDeclaration(declaration) && !(uris = PsiTreeUtil.findChildrenOfType((PsiElement)declaration.getValue(), CssUri.class)).isEmpty()) {
            Collection collection = uris;
            if (collection == null) {
                CssImageUtil.$$$reportNull$$$0(1);
            }
            return collection;
        }
        List<CssUri> list = Collections.emptyList();
        if (list == null) {
            CssImageUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static Collection<CssUri> findBackgroundImageUrlsInBlock(@NotNull CssBlock block) {
        if (block == null) {
            CssImageUtil.$$$reportNull$$$0(3);
        }
        ArrayList<CssUri> uris = new ArrayList<CssUri>();
        for (CssDeclaration cssDeclaration : block.getDeclarations()) {
            if (!CssImageUtil.isBackgroundDeclaration(cssDeclaration)) continue;
            uris.addAll(PsiTreeUtil.findChildrenOfType((PsiElement)cssDeclaration.getValue(), CssUri.class));
        }
        ArrayList<CssUri> arrayList = uris;
        if (arrayList == null) {
            CssImageUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public static boolean isBackgroundDeclaration(@NotNull CssDeclaration declaration) {
        String propertyName;
        if (declaration == null) {
            CssImageUtil.$$$reportNull$$$0(5);
        }
        return BACKGROUND_IMAGE_PROPERTY_NAME.equalsIgnoreCase(propertyName = declaration.getPropertyName()) || BACKGROUND_PROPERTY_NAME.equalsIgnoreCase(propertyName);
    }

    @NotNull
    public static Collection<VirtualFile> getImageFiles(@Nullable CssElement cssUriOrString) {
        if (cssUriOrString == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                CssImageUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        Object[] psiFiles = CssResolveManager.getInstance().resolveFiles((PsiElement)cssUriOrString);
        List virtualFiles = ContainerUtil.map((Object[])psiFiles, file -> file.getVirtualFile());
        List list = ContainerUtil.filter((Collection)virtualFiles, file -> {
            if (file == null) {
                return false;
            }
            String extension = file.getExtension();
            return extension != null && supportedExtensions.contains(StringUtil.toLowerCase((String)extension));
        });
        if (list == null) {
            CssImageUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    public static boolean isDataUri(@Nullable PsiElement uri) {
        if (uri instanceof CssUri) {
            return URLUtil.isDataUri((String)((CssUri)uri).getValue());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/css/util/CssImageUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/css/util/CssImageUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findBackgroundImageUris";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findBackgroundImageUrlsInBlock";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getImageFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findBackgroundImageUris";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findBackgroundImageUrlsInBlock";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isBackgroundDeclaration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

