/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.raster.mapping.svg;

import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.datamodel.mapping.svg.shared.TargetPeer;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTextNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimElements;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimNode;
import org.jetbrains.letsPlot.datamodel.svg.event.SvgEventSpec;
import org.jetbrains.letsPlot.raster.mapping.svg.SvgCanvasPeer;
import org.jetbrains.letsPlot.raster.mapping.svg.SvgUtils;
import org.jetbrains.letsPlot.raster.shape.Circle;
import org.jetbrains.letsPlot.raster.shape.Element;
import org.jetbrains.letsPlot.raster.shape.Group;
import org.jetbrains.letsPlot.raster.shape.Line;
import org.jetbrains.letsPlot.raster.shape.Path;
import org.jetbrains.letsPlot.raster.shape.Rectangle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J \u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/raster/mapping/svg/CanvasTargetPeer;", "Lorg/jetbrains/letsPlot/datamodel/mapping/svg/shared/TargetPeer;", "Lorg/jetbrains/letsPlot/raster/shape/Element;", "peer", "Lorg/jetbrains/letsPlot/raster/mapping/svg/SvgCanvasPeer;", "(Lorg/jetbrains/letsPlot/raster/mapping/svg/SvgCanvasPeer;)V", "appendChild", "", "target", "child", "hookEventHandlers", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "source", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgElement;", "eventSpecs", "", "Lorg/jetbrains/letsPlot/datamodel/svg/event/SvgEventSpec;", "newSvgElement", "newSvgSlimNode", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/slim/SvgSlimNode;", "newSvgTextNode", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTextNode;", "removeAllChildren", "setAttribute", "name", "", "value", "plot-raster"})
public final class CanvasTargetPeer
implements TargetPeer<Element> {
    @NotNull
    private final SvgCanvasPeer peer;

    public CanvasTargetPeer(@NotNull SvgCanvasPeer peer) {
        Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
        this.peer = peer;
    }

    public void appendChild(@NotNull Element target, @NotNull Element child) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        SvgUtils.INSTANCE.getChildren((Group)target).add(child);
    }

    public void removeAllChildren(@NotNull Element target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (target instanceof Group) {
            SvgUtils.INSTANCE.getChildren(target).clear();
        }
    }

    @NotNull
    public Element newSvgElement(@NotNull SvgElement source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return SvgUtils.INSTANCE.newElement((SvgNode)source, this.peer);
    }

    @NotNull
    public Element newSvgTextNode(@NotNull SvgTextNode source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public Element newSvgSlimNode(@NotNull SvgSlimNode source) {
        Element element;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String string = source.getElementName();
        if (Intrinsics.areEqual((Object)string, (Object)SvgSlimElements.INSTANCE.getGROUP())) {
            element = new Group();
        } else if (Intrinsics.areEqual((Object)string, (Object)SvgSlimElements.INSTANCE.getLINE())) {
            element = new Line();
        } else if (Intrinsics.areEqual((Object)string, (Object)SvgSlimElements.INSTANCE.getCIRCLE())) {
            element = new Circle();
        } else if (Intrinsics.areEqual((Object)string, (Object)SvgSlimElements.INSTANCE.getRECT())) {
            element = new Rectangle();
        } else if (Intrinsics.areEqual((Object)string, (Object)SvgSlimElements.INSTANCE.getPATH())) {
            element = new Path();
        } else {
            throw new IllegalStateException("Unsupported slim node " + Reflection.getOrCreateKotlinClass(source.getClass()).getSimpleName() + " '" + source.getElementName() + '\'');
        }
        return element;
    }

    public void setAttribute(@NotNull Element target, @NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        SvgUtils.INSTANCE.setAttribute(target, name, value);
    }

    @NotNull
    public Registration hookEventHandlers(@NotNull SvgElement source, @NotNull Element target, @NotNull Set<? extends SvgEventSpec> eventSpecs) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(eventSpecs, (String)"eventSpecs");
        throw new IllegalStateException("UNSUPPORTED: hookEventHandlers".toString());
    }
}

