/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.raster.mapping.svg;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.encoding.Png;
import org.jetbrains.letsPlot.commons.encoding.RGBEncoder;
import org.jetbrains.letsPlot.commons.logging.Logger;
import org.jetbrains.letsPlot.commons.logging.PortableLogging;
import org.jetbrains.letsPlot.commons.values.Bitmap;
import org.jetbrains.letsPlot.datamodel.mapping.framework.Mapper;
import org.jetbrains.letsPlot.datamodel.mapping.framework.MapperFactory;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgImageElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgImageElementEx;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgStyleElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgSvgElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTextElement;
import org.jetbrains.letsPlot.raster.mapping.svg.SvgCanvasPeer;
import org.jetbrains.letsPlot.raster.mapping.svg.SvgElementMapper;
import org.jetbrains.letsPlot.raster.mapping.svg.SvgGElementMapper;
import org.jetbrains.letsPlot.raster.mapping.svg.SvgImageElementMapper;
import org.jetbrains.letsPlot.raster.mapping.svg.SvgStyleElementMapper;
import org.jetbrains.letsPlot.raster.mapping.svg.SvgSvgElementMapper;
import org.jetbrains.letsPlot.raster.mapping.svg.SvgTextElementMapper;
import org.jetbrains.letsPlot.raster.mapping.svg.SvgUtils;
import org.jetbrains.letsPlot.raster.shape.Element;
import org.jetbrains.letsPlot.raster.shape.Group;
import org.jetbrains.letsPlot.raster.shape.Image;
import org.jetbrains.letsPlot.raster.shape.Text;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \f2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\fB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0002\u0012\u0006\b\u0001\u0012\u00020\u00030\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/raster/mapping/svg/SvgNodeMapperFactory;", "Lorg/jetbrains/letsPlot/datamodel/mapping/framework/MapperFactory;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "Lorg/jetbrains/letsPlot/raster/shape/Element;", "peer", "Lorg/jetbrains/letsPlot/raster/mapping/svg/SvgCanvasPeer;", "(Lorg/jetbrains/letsPlot/raster/mapping/svg/SvgCanvasPeer;)V", "rgbEncoder", "Lorg/jetbrains/letsPlot/commons/encoding/RGBEncoder;", "createMapper", "Lorg/jetbrains/letsPlot/datamodel/mapping/framework/Mapper;", "source", "Companion", "plot-raster"})
public final class SvgNodeMapperFactory
implements MapperFactory<SvgNode, Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SvgCanvasPeer peer;
    @NotNull
    private final RGBEncoder rgbEncoder;
    @NotNull
    private static final Logger LOG = PortableLogging.INSTANCE.logger(Reflection.getOrCreateKotlinClass(SvgNodeMapperFactory.class));

    public SvgNodeMapperFactory(@NotNull SvgCanvasPeer peer) {
        Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
        this.peer = peer;
        this.rgbEncoder = new RGBEncoder(){

            @NotNull
            public String toDataUrl(@NotNull Bitmap bitmap) {
                Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
                return Png.INSTANCE.encodeDataImage(bitmap);
            }
        };
    }

    @NotNull
    public Mapper<? extends SvgNode, ? extends Element> createMapper(@NotNull SvgNode source) {
        Mapper mapper;
        SvgNode svgNode;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        SvgNode src = source;
        Element target = SvgUtils.INSTANCE.newElement(src, this.peer);
        if (src instanceof SvgImageElementEx) {
            src = (SvgNode)((SvgImageElementEx)src).asImageElement(this.rgbEncoder);
        }
        if ((svgNode = src) instanceof SvgStyleElement) {
            SvgStyleElement svgStyleElement = (SvgStyleElement)src;
            Intrinsics.checkNotNull((Object)target, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.raster.shape.Group");
            mapper = new SvgStyleElementMapper(svgStyleElement, (Group)target, this.peer);
        } else if (svgNode instanceof SvgGElement) {
            SvgGElement svgGElement = (SvgGElement)src;
            Intrinsics.checkNotNull((Object)target, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.raster.shape.Group");
            mapper = new SvgGElementMapper(svgGElement, (Group)target, this.peer);
        } else if (svgNode instanceof SvgSvgElement) {
            mapper = new SvgSvgElementMapper((SvgSvgElement)src, this.peer);
        } else if (svgNode instanceof SvgTextElement) {
            SvgTextElement svgTextElement = (SvgTextElement)src;
            Intrinsics.checkNotNull((Object)target, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.raster.shape.Text");
            mapper = new SvgTextElementMapper(svgTextElement, (Text)target, this.peer);
        } else if (svgNode instanceof SvgImageElement) {
            SvgImageElement svgImageElement = (SvgImageElement)src;
            Intrinsics.checkNotNull((Object)target, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.raster.shape.Image");
            mapper = new SvgImageElementMapper(svgImageElement, (Image)target, this.peer);
        } else if (svgNode instanceof SvgElement) {
            mapper = new SvgElementMapper<SvgElement, Element>((SvgElement)src, target, this.peer);
        } else {
            throw new IllegalArgumentException("Unsupported SvgElement: " + Reflection.getOrCreateKotlinClass(src.getClass()).getSimpleName());
        }
        return mapper;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/raster/mapping/svg/SvgNodeMapperFactory$Companion;", "", "()V", "LOG", "Lorg/jetbrains/letsPlot/commons/logging/Logger;", "plot-raster"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

