/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.features.ide.inspections.workflow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.vcs.github.ultimate.features.i18n.GithubUltimateBundle;
import com.intellij.vcs.github.ultimate.features.ide.PluginSettingsUtilKt;
import com.intellij.vcs.github.ultimate.features.ide.inspections.ActionInspectionsUtilKt;
import com.intellij.vcs.github.ultimate.features.ide.inspections.BaseGitHubActionInspection;
import com.intellij.vcs.github.ultimate.features.workflow.job.needs.JobNeedReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.extensions.GithubYamlFileDetectionKt;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/vcs/github/ultimate/features/ide/inspections/workflow/IllegalJobDependencyInspection;", "Lcom/intellij/vcs/github/ultimate/features/ide/inspections/BaseGitHubActionInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isAvailableForFile", "file", "Lcom/intellij/psi/PsiFile;", "RemoveJobReferenceQuickFix", "intellij.vcs.github.ultimate.features"})
public final class IllegalJobDependencyInspection
extends BaseGitHubActionInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new YamlPsiElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            /*
             * WARNING - void declaration
             */
            public void visitScalar(YAMLScalar scalar) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)scalar, (String)"scalar");
                if (!ActionInspectionsUtilKt.getJobIdNeedsPattern().accepts((Object)scalar)) {
                    return;
                }
                PsiReference[] psiReferenceArray = scalar.getReferences();
                Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
                Object[] $this$filterIsInstance$iv = psiReferenceArray;
                boolean $i$f$filterIsInstance = false;
                Object[] objectArray = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof JobNeedReference)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    JobNeedReference it = (JobNeedReference)((Object)element$iv$iv);
                    boolean bl = false;
                    if (!(it.resolve() == null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List jobNeedReferences = (List)destination$iv$iv;
                $this$filter$iv = jobNeedReferences;
                ProblemsHolder problemsHolder = this.$holder;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JobNeedReference it = (JobNeedReference)((Object)element$iv);
                    boolean bl = false;
                    Object[] objectArray2 = new Object[]{it.getElement().getText()};
                    String string = GithubUltimateBundle.message("github.action.inspections.message.illegal.job.dependency", objectArray2);
                    objectArray2 = new LocalQuickFix[]{new RemoveJobReferenceQuickFix()};
                    problemsHolder.registerProblem((PsiElement)scalar, string, (LocalQuickFix[])objectArray2);
                }
            }
        };
    }

    @Override
    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return PluginSettingsUtilKt.githubActionsSupportEnabled() && GithubYamlFileDetectionKt.isGithubWorkflowFile((PsiFile)file);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/github/ultimate/features/ide/inspections/workflow/IllegalJobDependencyInspection$RemoveJobReferenceQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.vcs.github.ultimate.features"})
    private static final class RemoveJobReferenceQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = GithubUltimateBundle.message("github.action.intention.family.name.remove.illegal.job", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            descriptor.getPsiElement().delete();
        }
    }
}

