/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.data.parser;

import com.intellij.micronaut.data.parser.MicronautPartTreeParserContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MicronautProjection {
    @Nullable
    private String expressionType;
    private String propertyName;

    public MicronautProjection(@NotNull String projectionExpression) {
        if (projectionExpression == null) {
            MicronautProjection.$$$reportNull$$$0(0);
        }
        this.propertyName = StringUtil.decapitalize((String)projectionExpression);
        for (String projectionPredicate : MicronautPartTreeParserContext.PROJECTION_PREDICATES) {
            if (!projectionExpression.startsWith(projectionPredicate)) continue;
            this.expressionType = projectionPredicate;
            this.propertyName = StringUtil.decapitalize((String)projectionExpression.substring(projectionPredicate.length()));
        }
    }

    @Nullable
    public PsiType getType(@NotNull PsiClass domainClass) {
        if (domainClass == null) {
            MicronautProjection.$$$reportNull$$$0(1);
        }
        if (this.expressionType != null && MicronautProjection.isNumberProjection(this.expressionType)) {
            return JavaPsiFacade.getElementFactory((Project)domainClass.getProject()).createTypeByFQClassName("java.lang.Number");
        }
        if (StringUtil.isEmpty((String)this.propertyName)) {
            return null;
        }
        PsiMethod getter = PropertyUtilBase.findPropertyGetter((PsiClass)domainClass, (String)this.propertyName, (boolean)false, (boolean)true);
        return getter != null ? getter.getReturnType() : null;
    }

    private static boolean isNumberProjection(@Nullable String expressionType) {
        return expressionType != null && MicronautPartTreeParserContext.COUNT_PROJECTION_PREDICATES.contains(expressionType);
    }

    @Nullable
    public String getExpressionType() {
        return this.expressionType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectionExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/micronaut/data/parser/MicronautProjection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

